/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayerSwimNodeEvaluator
extends PlayerNodeEvaluator {
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    @Override
    public void prepare(PathNavigationRegion level, Player p) {
        super.prepare(level, p);
        this.pathTypesByPosCache.clear();
        PathingDebug.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    public Node getStart() {
        AABB aABB = PathingRenderer.getBigHitbox().m_82383_(Vec3.m_82539_((Vec3i)PathingDebug.pos1));
        return super.getNode(Mth.m_14107_((double)aABB.f_82288_), Mth.m_14107_((double)(aABB.f_82289_ + 0.5)), Mth.m_14107_((double)aABB.f_82290_));
    }

    @Override
    public int getNeighbors(Node[] nodes, Node node) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node2 = this.getNode(node.f_77271_ + direction.m_122429_(), node.f_77272_ + direction.m_122430_(), node.f_77273_ + direction.m_122431_());
            map.put(direction, node2);
            if (!this.isNodeValid(node2)) continue;
            nodes[i++] = node2;
        }
        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
            Direction direction3 = direction2.m_122427_();
            Node node3 = this.getNode(node.f_77271_ + direction2.m_122429_() + direction3.m_122429_(), node.f_77272_, node.f_77273_ + direction2.m_122431_() + direction3.m_122431_());
            if (!this.isDiagonalNodeValid(node3, (Node)map.get(direction2), (Node)map.get(direction3))) continue;
            nodes[i++] = node3;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node node) {
        return node != null && !node.f_77279_;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node node, @Nullable Node node2, @Nullable Node node3) {
        return this.isNodeValid(node) && node2 != null && node2.f_77281_ >= 0.0f && node3 != null && node3.f_77281_ >= 0.0f;
    }

    @Override
    @Nullable
    protected Node getNode(int x, int y, int z) {
        Node node = null;
        BlockPathTypes blockPathTypes = this.getCachedBlockType(x, y, z);
        if (blockPathTypes == BlockPathTypes.WATER) {
            float f;
            float f2 = PathingDebug.getPathfindingMalus(blockPathTypes);
            if (f >= 0.0f) {
                node = super.getNode(x, y, z);
                node.f_77282_ = blockPathTypes;
                node.f_77281_ = Math.max(node.f_77281_, f2);
                if (this.level.m_6425_(new BlockPos(x, y, z)).m_76178_()) {
                    node.f_77281_ += 8.0f;
                }
            }
        }
        return node;
    }

    @Override
    public Target getGoal(double x, double y, double z) {
        return new Target(super.getNode(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    protected BlockPathTypes getCachedBlockType(int x, int y, int z) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)x, (int)y, (int)z), l -> this.getBlockPathType((BlockGetter)this.level, x, y, z));
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter level, int x, int y, int z) {
        return this.getBlockPathType(level, x, y, z, this.player, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors());
    }

    @Override
    public BlockPathTypes getBlockPathType(BlockGetter blockaccess, int x, int y, int z, Player entityliving, int xSize, int ySize, int zSize, boolean canBreakDoors, boolean canEnterDoors) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = x; i < x + xSize; ++i) {
            for (int j = y; j < y + ySize; ++j) {
                for (int k = z; k < z + zSize; ++k) {
                    FluidState fluidState = blockaccess.m_6425_((BlockPos)mutableBlockPos.m_122178_(i, j, k));
                    BlockState blockState = blockaccess.m_8055_((BlockPos)mutableBlockPos.m_122178_(i, j, k));
                    if (fluidState.m_76178_() && blockState.m_60647_(blockaccess, mutableBlockPos.m_7495_(), PathComputationType.WATER) && blockState.m_60795_()) {
                        return BlockPathTypes.BREACH;
                    }
                    if (fluidState.m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.BLOCKED;
                }
            }
        }
        BlockState blockState2 = blockaccess.m_8055_((BlockPos)mutableBlockPos);
        if (blockState2.m_60647_(blockaccess, (BlockPos)mutableBlockPos, PathComputationType.WATER)) {
            return BlockPathTypes.WATER;
        }
        return BlockPathTypes.BLOCKED;
    }
}

