/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.filters;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import com.github.teamfossilsarcheology.fossil.client.gui.filters.FilterTab;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CreativeTabFilters {
    private static final Map<CreativeModeTab, FilterTab> tabs = new Object2ObjectOpenHashMap();
    private static CreativeModeTab activeTab;

    public static void register() {
        NonNullList entityItems = NonNullList.m_122779_();
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_BONES, new ItemStack((ItemLike)PrehistoricEntityInfo.TRICERATOPS.skullBoneItem)));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_DNA, new ItemStack((ItemLike)PrehistoricEntityInfo.TRICERATOPS.dnaItem)));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_EGGS, new ItemStack((ItemLike)PrehistoricEntityInfo.TRICERATOPS.spawnEggItem)));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_MEAT, new ItemStack((ItemLike)PrehistoricEntityInfo.TRICERATOPS.foodItem)));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_PLANTS, new ItemStack((ItemLike)ModItems.FERN_SEED.get())));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_BUCKETS, new ItemStack((ItemLike)PrehistoricEntityInfo.NAUTILUS.bucketItem)));
        entityItems.add((Object)new FilterTab.Filter(ModItemTags.FILTER_OTHER, new ItemStack((ItemLike)ModItems.MAMMOTH_FUR.get())));
        NonNullList blocks = NonNullList.m_122779_();
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_TREES, new ItemStack((ItemLike)ModBlocks.PALM_LOG.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_VASES, new ItemStack((ItemLike)ModBlocks.AMPHORA_VASE_RESTORED.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FIGURINES, new ItemStack((ItemLike)ModBlocks.ANU_FIGURINE_DESTROYED.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_PLANTS, new ItemStack((ItemLike)PrehistoricPlantInfo.BENNETTITALES_LARGE.getPlantBlock())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_UNBREAKABLE, new ItemStack((ItemLike)ModBlocks.REINFORCED_GLASS.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_MACHINES, new ItemStack((ItemLike)ModBlocks.ANALYZER.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_BUILDING_BLOCKS, new ItemStack((ItemLike)ModBlocks.ANCIENT_STONE_BRICKS.get())));
        blocks.add((Object)new FilterTab.Filter(ModItemTags.FILTER_PARK, new ItemStack((ItemLike)ModItems.TOY_BALLS.get(DyeColor.RED).get())));
        ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.register((screen, guiGraphics, mouseX, mouseY, delta) -> {
            if (screen instanceof CreativeModeInventoryScreen && tabs.containsKey(CreativeModeInventoryScreen.f_98507_)) {
                tabs.get(CreativeModeInventoryScreen.f_98507_).renderButtons(guiGraphics, mouseX, mouseY, delta);
            }
        });
        ClientGuiEvent.RENDER_PRE.register((screen, matrices, mouseX, mouseY, delta) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)screen;
                if (tabs.containsKey(CreativeModeInventoryScreen.f_98507_)) {
                    activeTab = CreativeModeInventoryScreen.f_98507_;
                    CreativeModeTab oldTab = activeTab;
                    boolean switchedTab = activeTab != oldTab;
                    FilterTab filterTab = tabs.get(activeTab);
                    if (oldTab == null) {
                        filterTab.enableButtons();
                    } else if (switchedTab) {
                        tabs.get(oldTab).disableButtons();
                        filterTab.enableButtons();
                    }
                    tabs.get(activeTab).getTag().ifPresent(tag -> {
                        ((CreativeModeInventoryScreen.ItemPickerMenu)creativeScreen.m_6262_()).f_98639_.clear();
                        ((CreativeModeInventoryScreen.ItemPickerMenu)creativeScreen.m_6262_()).f_98639_.addAll(activeTab.m_260957_().stream().filter(itemStack -> itemStack.m_204117_(tag)).toList());
                    });
                    ((CreativeModeInventoryScreen.ItemPickerMenu)creativeScreen.m_6262_()).m_98642_(switchedTab ? 0.0f : creativeScreen.f_98508_);
                }
            }
            return EventResult.pass();
        });
        ClientGuiEvent.INIT_POST.register((screen, access) -> {
            if (screen instanceof CreativeModeInventoryScreen) {
                tabs.put((CreativeModeTab)ModTabs.FA_MOB_ITEM_TAB.get(), FilterTab.build(screen, (List<FilterTab.Filter>)entityItems, access));
                tabs.put((CreativeModeTab)ModTabs.FA_BLOCK_TAB.get(), FilterTab.build(screen, (List<FilterTab.Filter>)blocks, access));
                activeTab = null;
            }
        });
    }
}

