/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.entity.Javelin;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.NotNull;

public class JavelinRenderer
extends ArrowRenderer<Javelin>
implements RendererFabricFix {
    private static final ResourceLocation WOODEN_JAVELIN = FossilMod.location("textures/entity/wooden_javelin.png");
    private static final ResourceLocation STONE_JAVELIN = FossilMod.location("textures/entity/stone_javelin.png");
    private static final ResourceLocation IRON_JAVELIN = FossilMod.location("textures/entity/iron_javelin.png");
    private static final ResourceLocation GOLD_JAVELIN = FossilMod.location("textures/entity/gold_javelin.png");
    private static final ResourceLocation DIAMOND_JAVELIN = FossilMod.location("textures/entity/diamond_javelin.png");
    private static final ResourceLocation ANCIENT_JAVELIN = FossilMod.location("textures/entity/ancient_javelin.png");

    public JavelinRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Javelin entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        super.m_7392_((AbstractArrow)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(Javelin entity) {
        if (entity.isAncient()) {
            return ANCIENT_JAVELIN;
        }
        Tier tier = entity.getTier();
        if (tier instanceof Tiers) {
            Tiers tiers = (Tiers)tier;
            switch (tiers) {
                case WOOD: {
                    return WOODEN_JAVELIN;
                }
                case STONE: {
                    return STONE_JAVELIN;
                }
                case GOLD: {
                    return GOLD_JAVELIN;
                }
                case IRON: {
                    return IRON_JAVELIN;
                }
                case DIAMOND: {
                    return DIAMOND_JAVELIN;
                }
            }
        }
        return ANCIENT_JAVELIN;
    }

    @Override
    public ResourceLocation _getTextureLocation(Entity entity) {
        return this.getTextureLocation((Javelin)entity);
    }
}

