/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.rei;

import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class WithFuelDisplay
implements Display {
    protected final EntryIngredient input;
    protected final EntryIngredient fuel;
    protected final EntryStack<?> output;
    protected final ResourceLocation location;

    protected WithFuelDisplay(WithFuelRecipe recipe) {
        this(EntryIngredients.ofIngredient((Ingredient)recipe.getInput()), EntryIngredients.ofIngredient((Ingredient)recipe.getFuel()), EntryStacks.of((ItemStack)recipe.m_8043_(null)), recipe.m_6423_());
    }

    protected WithFuelDisplay(EntryIngredient input, EntryIngredient fuel, EntryStack<?> output, ResourceLocation location) {
        this.input = input;
        this.fuel = fuel;
        this.output = output;
        this.location = location;
    }

    public List<EntryIngredient> getInputEntries() {
        return Lists.newArrayList((Object[])new EntryIngredient[]{this.input, this.fuel});
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredient.of(this.output));
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.location);
    }

    public static class Serializer<T extends WithFuelDisplay>
    implements DisplaySerializer<T> {
        protected final Constructor<T> constructor;

        protected Serializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        public CompoundTag save(CompoundTag tag, T display) {
            tag.m_128365_("Input", (Tag)((WithFuelDisplay)display).input.saveIngredient());
            tag.m_128365_("Fuel", (Tag)((WithFuelDisplay)display).fuel.saveIngredient());
            tag.m_128365_("Output", (Tag)((WithFuelDisplay)display).output.saveStack());
            tag.m_128359_("Location", ((WithFuelDisplay)display).location.toString());
            return tag;
        }

        public T read(CompoundTag tag) {
            EntryIngredient input = EntryIngredient.read((ListTag)tag.m_128437_("Input", 10));
            EntryIngredient fuel = EntryIngredient.read((ListTag)tag.m_128437_("Fuel", 10));
            EntryStack output = EntryStack.read((CompoundTag)tag.m_128469_("Output"));
            ResourceLocation location = new ResourceLocation(tag.m_128461_("Location"));
            return (T)((WithFuelDisplay)this.constructor.construct(input, fuel, output, location));
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(EntryIngredient var1, EntryIngredient var2, EntryStack<?> var3, ResourceLocation var4);
        }
    }
}

