/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AncientLightningBolt
extends LightningBolt {
    private static final int START_LIFE = 2;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    private int life = 2;
    private int flashes = this.f_19796_.m_188503_(3) + 1;
    private boolean visualOnly;
    @Nullable
    private ServerPlayer cause;
    private int blocksSetOnFire;

    public AncientLightningBolt(EntityType<AncientLightningBolt> entityType, Level level) {
        super(entityType, level);
    }

    public void m_20874_(boolean visualOnly) {
        this.visualOnly = visualOnly;
    }

    @Nullable
    public ServerPlayer m_147158_() {
        return this.cause;
    }

    public void m_20879_(@Nullable ServerPlayer cause) {
        this.cause = cause;
    }

    public void m_8119_() {
        this.m_6075_();
        if (this.life == 2) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
            } else {
                Difficulty difficulty = this.m_9236_().m_46791_();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.spawnFire(4);
                }
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.f_20859_ = this.f_19796_.m_188505_();
                this.spawnFire(0);
            }
        }
        if (this.life >= 0) {
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_6580_(2);
            } else if (!this.visualOnly) {
                List nearbyEntities = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                for (Entity entity : nearbyEntities) {
                    boolean canHit = true;
                    if (this.cause == null && entity instanceof AnuBoss) {
                        canHit = false;
                    } else if (this.cause != null) {
                        OwnableEntity ownable;
                        if (entity == this.cause || entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() == this.cause) {
                            canHit = false;
                        }
                    } else if (entity instanceof Pig) {
                        canHit = false;
                    }
                    if (!canHit) continue;
                    entity.m_8038_((ServerLevel)this.m_9236_(), (LightningBolt)this);
                    this.hitEntities.add(entity);
                }
                if (this.cause != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.cause, (Collection)nearbyEntities);
                }
            }
        }
    }

    private void spawnFire(int extraIgnitions) {
        if (this.visualOnly || this.m_9236_().f_46443_ || !this.m_9236_().m_46469_().m_46207_(GameRules.f_46131_)) {
            return;
        }
        if (this.cause != null && !this.cause.m_21023_(MobEffects.f_19607_)) {
            return;
        }
        BlockPos blockPos = this.m_20183_();
        BlockState blockState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockPos);
        if (this.m_9236_().m_8055_(blockPos).m_60795_() && blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) {
            this.m_9236_().m_46597_(blockPos, blockState);
            ++this.blocksSetOnFire;
        }
        for (int i = 0; i < extraIgnitions; ++i) {
            BlockPos blockPos2 = blockPos.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
            blockState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockPos2);
            if (!this.m_9236_().m_8055_(blockPos2).m_60795_() || !blockState.m_60710_((LevelReader)this.m_9236_(), blockPos2)) continue;
            this.m_9236_().m_46597_(blockPos2, blockState);
            ++this.blocksSetOnFire;
        }
    }

    @NotNull
    public Stream<Entity> m_147160_() {
        return this.hitEntities.stream().filter(Entity::m_6084_);
    }

    public int m_147159_() {
        return this.blocksSetOnFire;
    }
}

