/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ToyBall
extends ToyBase {
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private static final EntityDataAccessor<Integer> COLOR_ID = SynchedEntityData.m_135353_(ToyBall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ToyBall(EntityType<ToyBall> type, Level level) {
        super(type, level, 15, SoundEvents.f_12384_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR_ID, (Object)DyeColor.WHITE.m_41060_());
    }

    public void m_7334_(Entity entity) {
        if (entity != null && !(entity instanceof ToyBase)) {
            this.pushBall(entity);
        }
    }

    private void pushBall(float yRot) {
        this.m_19915_(yRot, this.m_146909_());
        this.m_5997_(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.5f, 0.1, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.5f);
    }

    private void pushBall(Entity entity) {
        Vec3 offset = Util.directionVecTo(entity, this);
        double yawDiff = Mth.m_14136_((double)offset.f_82481_, (double)offset.f_82479_) * 57.2957763671875;
        this.pushBall(Util.yawToYRot(yawDiff));
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void pushEntities() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            int j;
            int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
            if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                j = 0;
                for (Entity entity : list) {
                    if (entity.m_20159_()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.m_6469_(this.m_269291_().m_269354_(), 6.0f);
                }
            }
            for (j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                this.doPush(entity);
            }
        }
    }

    protected void doPush(Entity entity) {
        entity.m_7334_((Entity)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (Math.abs(this.m_20184_().f_82479_) > 0.01 || Math.abs(this.m_20184_().f_82481_) > 0.01) {
            this.m_19915_(this.m_146908_(), this.m_146909_() + 14.0f);
        }
        this.aiStep();
    }

    private void aiStep() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double e = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double f = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double g = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)g / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d, e, f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (this.m_9236_().f_46443_) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.m_5997_(0.0, 0.1, 0.0);
        }
        if (this.f_19862_) {
            this.pushBall(this.m_146908_() + 180.0f);
        }
        Vec3 vec3 = this.m_20184_();
        double x = vec3.f_82479_;
        double y = vec3.f_82480_;
        double z = vec3.f_82481_;
        if (Math.abs(vec3.f_82479_) < 0.003) {
            x = 0.0;
        }
        if (Math.abs(vec3.f_82480_) < 0.003) {
            y = 0.0;
        }
        if (Math.abs(vec3.f_82481_) < 0.003) {
            z = 0.0;
        }
        this.m_20334_(x, y, z);
        this.travel();
        this.pushEntities();
    }

    private void travel() {
        if (!this.m_9236_().f_46443_ || this.m_6109_()) {
            boolean isFalling;
            double gravity = 0.08;
            boolean bl = isFalling = this.m_20184_().f_82480_ <= 0.0;
            if (this.m_20069_()) {
                double e = this.m_20186_();
                float friction = 0.8f;
                float g = 0.02f;
                this.m_19920_(g, Vec3.f_82478_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vec3 = this.m_20184_();
                this.m_20256_(vec3.m_82542_((double)friction, 0.8, (double)friction));
                double dy = isFalling && Math.abs(this.m_20184_().f_82480_ - 0.005) >= 0.003 && Math.abs(this.m_20184_().f_82480_ - gravity / 16.0) < 0.003 ? -0.003 : this.m_20184_().f_82480_ - gravity / 16.0;
                Vec3 fallingAdjusted = new Vec3(this.m_20184_().f_82479_, dy, this.m_20184_().f_82481_);
                this.m_20256_(fallingAdjusted);
                if (this.f_19862_ && this.m_20229_(fallingAdjusted.f_82479_, fallingAdjusted.f_82480_ + 0.6 - this.m_20186_() + e, fallingAdjusted.f_82481_)) {
                    this.m_20334_(fallingAdjusted.f_82479_, 0.3, fallingAdjusted.f_82481_);
                }
            } else {
                BlockPos blockPos = this.m_20099_();
                float blockFriction = this.m_9236_().m_8055_(blockPos).m_60734_().m_49958_();
                float friction = this.m_20096_() ? blockFriction * 0.91f : 0.91f;
                this.m_19920_(0.0f, Vec3.f_82478_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 vec36 = this.m_20184_();
                double q = vec36.f_82480_;
                if (this.m_9236_().f_46443_ && !this.m_9236_().m_46805_(blockPos)) {
                    q = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
                } else if (!this.m_20068_()) {
                    q -= gravity;
                }
                this.m_20334_(vec36.f_82479_ * (double)friction, q * 0.98, vec36.f_82481_ * (double)friction);
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.m_146926_(xRot < 0.0f ? 360.0f + xRot : xRot);
        this.lerpSteps = lerpSteps;
    }

    @Override
    protected boolean tickAI() {
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        if (entity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            this.m_7334_((Entity)prehistoric);
            this.m_8127_();
        } else {
            entity = source.m_7640_();
            if (entity instanceof AbstractArrow) {
                AbstractArrow javelin = (AbstractArrow)entity;
                this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
                this.m_7334_((Entity)javelin);
                return true;
            }
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.TOY_BALLS.get(this.getColor()).get());
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(COLOR_ID)));
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(COLOR_ID, (Object)color.m_41060_());
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("color", this.getColor().m_41060_());
    }

    public void m_7378_(CompoundTag compound) {
        this.setColor(DyeColor.m_41053_((int)compound.m_128451_("color")));
    }
}

