/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.NotNull;

public abstract class ToyBase
extends Entity {
    private static final Set<WoodType> VANILLA_WOOD_TYPES = Set.of(WoodType.f_61830_, WoodType.f_61831_, WoodType.f_61832_, WoodType.f_61833_, WoodType.f_61834_, WoodType.f_61835_, WoodType.f_61836_, WoodType.f_61837_, WoodType.f_223002_, WoodType.f_244200_, WoodType.f_271224_);
    public final int moodBonus;
    protected final SoundEvent attackNoise;

    protected ToyBase(EntityType<? extends ToyBase> type, Level level, int moodBonus, SoundEvent attackNoise) {
        super(type, level);
        this.moodBonus = moodBonus;
        this.attackNoise = attackNoise;
    }

    public static boolean isVanillaWood(WoodType woodType) {
        return VANILLA_WOOD_TYPES.contains(woodType);
    }

    protected boolean tickAI() {
        return false;
    }

    public void m_6075_() {
        if (this.tickAI()) {
            super.m_6075_();
        }
    }

    public void m_8119_() {
        if (this.tickAI()) {
            super.m_8119_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null) {
            Entity entity = source.m_7640_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    this.m_146870_();
                    return true;
                }
                if (!player.m_150110_().f_35938_) {
                    return false;
                }
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)this.m_142340_());
                this.m_146870_();
                this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
                return true;
            }
            entity = source.m_7639_();
            if (entity instanceof Prehistoric) {
                Prehistoric prehistoric = (Prehistoric)entity;
                prehistoric.moodSystem.useToy(this.moodBonus);
                this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
                return false;
            }
            if (source == this.m_269291_().m_269354_() || source.m_269533_(DamageTypeTags.f_268745_)) {
                Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)this.m_142340_());
                this.m_146870_();
            }
        }
        return source != this.m_269291_().m_269341_();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (Version.debugEnabled() && reason == Entity.RemovalReason.KILLED) {
            return;
        }
        super.m_142687_(reason);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public float getVoicePitch() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

