/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AbstractAnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class AnuMeleePhase
extends AbstractAnuPhaseInstance {
    private final MeleeAttackGoal attackGoal;
    private boolean attackGoalActive;

    public AnuMeleePhase(AnuBoss anuBoss) {
        super(anuBoss);
        this.attackGoal = new MeleeAttackGoal((PathfinderMob)this.anu, 1.2, false);
    }

    @Override
    public void doClientTick() {
        if (this.anu.isWeak()) {
            for (int i = 0; i < 2; ++i) {
                this.anu.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.anu.m_20208_(0.5), this.anu.m_20187_(), this.anu.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void doServerTick() {
        if (this.attackGoalActive && this.attackGoal.m_8045_()) {
            this.attackGoal.m_8037_();
        } else if (this.attackGoal.m_8036_()) {
            this.attackGoal.m_8056_();
            this.attackGoalActive = true;
        } else {
            this.attackGoal.m_8041_();
            this.attackGoalActive = false;
        }
        this.switchPhaseByHealth();
    }

    @Override
    protected void switchPhaseByHealth() {
        AnuPhase newPhase = AnuPhase.byFraction(this.anu.m_21223_() / this.anu.m_21233_());
        if (newPhase == AnuPhase.DEFENSE || this.anu.m_9236_().m_46467_() > this.endTime) {
            this.anu.phaseSystem.setPhase(newPhase, 100);
        }
    }

    @Override
    public AnuPhase getPhase() {
        return AnuPhase.MELEE;
    }

    @Override
    public void end() {
        if (this.attackGoalActive) {
            this.attackGoal.m_8041_();
            this.attackGoalActive = false;
        }
        this.anu.setWeak(false);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ANU_LAUGH.get();
    }

    @Override
    public boolean isFlying() {
        return false;
    }
}

