/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class NavUtil {
    static final float EPSILON = 1.0E-8f;

    public static boolean isNoCollisionOnPath(Vec3 pathVec, Vec3 minBounds, Vec3 maxBounds, PathComputationType type, Mob mob, NodeEvaluator nodeEvaluator) {
        float pathLength = (float)pathVec.m_82553_();
        if (pathLength < 1.0E-8f) {
            return true;
        }
        float[] trailingPositions = new float[3];
        int[] leadingEdges = new int[3];
        int[] trailingEdges = new int[3];
        int[] stepDirections = new int[3];
        float[] stepDelta = new float[3];
        float[] stepLength = new float[3];
        float[] normedAxis = new float[3];
        for (Direction.Axis axis : Direction.Axis.values()) {
            float axisLength = NavUtil.chooseLengthForAxis(axis, pathVec);
            boolean stepDirection = axisLength >= 0.0f;
            int idx = axis.ordinal();
            stepDirections[idx] = stepDirection ? 1 : -1;
            float lead = NavUtil.chooseLengthForAxis(axis, stepDirection ? maxBounds : minBounds);
            trailingPositions[idx] = NavUtil.chooseLengthForAxis(axis, stepDirection ? minBounds : maxBounds);
            leadingEdges[idx] = NavUtil.leadEdgesToInt(lead, stepDirections[idx]);
            trailingEdges[idx] = NavUtil.trailEdgeToInt(trailingPositions[idx], stepDirections[idx]);
            normedAxis[idx] = axisLength / pathLength;
            stepDelta[idx] = Mth.m_14154_((float)(pathLength / axisLength));
            float dist = stepDirection ? (float)(leadingEdges[idx] + 1) - lead : lead - (float)leadingEdges[idx];
            stepLength[idx] = stepDelta[idx] < Float.POSITIVE_INFINITY ? stepDelta[idx] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float previousStepLength = 0.0f;
        do {
            Direction.Axis axis = stepLength[0] < stepLength[1] ? (stepLength[0] < stepLength[2] ? Direction.Axis.X : Direction.Axis.Z) : (stepLength[1] < stepLength[2] ? Direction.Axis.Y : Direction.Axis.Z);
            int idx = axis.ordinal();
            float dt = stepLength[idx] - previousStepLength;
            previousStepLength = stepLength[idx];
            int n = idx;
            leadingEdges[n] = leadingEdges[n] + stepDirections[idx];
            int n2 = idx;
            stepLength[n2] = stepLength[n2] + stepDelta[idx];
            for (Direction.Axis axis2 : Direction.Axis.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trailingPositions[n3] = trailingPositions[n3] + dt * normedAxis[i];
                trailingEdges[i] = NavUtil.trailEdgeToInt(trailingPositions[i], stepDirections[i]);
            }
            int stepX = stepDirections[0];
            int minX = axis == Direction.Axis.X ? leadingEdges[0] : trailingEdges[0];
            int maxX = leadingEdges[0] + stepX;
            int stepY = stepDirections[1];
            int minY = axis == Direction.Axis.Y ? leadingEdges[1] : trailingEdges[1];
            int maxY = leadingEdges[1] + stepY;
            int stepZ = stepDirections[2];
            int minZ = axis == Direction.Axis.Z ? leadingEdges[2] : trailingEdges[2];
            int maxZ = leadingEdges[2] + stepZ;
            for (int x = minX; x != maxX; x += stepX) {
                for (int z = minZ; z != maxZ; z += stepZ) {
                    if (!NavUtil.isCollisionAtColumn(x, minY, z, maxY, stepY, type, mob, pos, nodeEvaluator)) continue;
                    return false;
                }
            }
        } while (previousStepLength <= pathLength);
        return true;
    }

    private static boolean isCollisionAtColumn(int x, int minY, int z, int maxY, int stepY, PathComputationType type, Mob mob, BlockPos.MutableBlockPos pos, NodeEvaluator nodeEvaluator) {
        BlockPathTypes in;
        float malus;
        if (type == PathComputationType.WATER) {
            BlockState block;
            int y;
            boolean anyWater = false;
            for (y = minY; y != maxY; y += stepY) {
                block = mob.m_9236_().m_8055_((BlockPos)pos.m_122178_(x, y, z));
                if (!block.m_60647_((BlockGetter)mob.m_9236_(), (BlockPos)pos, type)) continue;
                anyWater = true;
                break;
            }
            if (!anyWater) {
                return true;
            }
            for (y = minY; y != maxY; y += stepY) {
                block = mob.m_9236_().m_8055_((BlockPos)pos.m_122178_(x, y, z));
                if (block.m_60647_((BlockGetter)mob.m_9236_(), (BlockPos)pos, PathComputationType.WATER) || block.m_60647_((BlockGetter)mob.m_9236_(), (BlockPos)pos, PathComputationType.LAND)) continue;
                return true;
            }
        } else {
            for (int y = minY; y != maxY; y += stepY) {
                BlockState block = mob.m_9236_().m_8055_((BlockPos)pos.m_122178_(x, y, z));
                if (block.m_60647_((BlockGetter)mob.m_9236_(), (BlockPos)pos, type)) continue;
                return true;
            }
        }
        if ((malus = mob.m_21439_(in = nodeEvaluator.m_8086_((BlockGetter)mob.m_9236_(), x, minY, z))) < 0.0f || malus >= 8.0f) {
            return true;
        }
        if (type == PathComputationType.LAND) {
            BlockPathTypes below = nodeEvaluator.m_8086_((BlockGetter)mob.m_9236_(), x, minY - 1, z);
            if (below == BlockPathTypes.WATER || below == BlockPathTypes.LAVA || below == BlockPathTypes.OPEN) {
                return true;
            }
            return in == BlockPathTypes.DAMAGE_FIRE || in == BlockPathTypes.DANGER_FIRE || in == BlockPathTypes.DAMAGE_OTHER;
        }
        return false;
    }

    private static float chooseLengthForAxis(Direction.Axis axis, Vec3 vec) {
        return (float)axis.m_6150_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    private static int leadEdgesToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord - (float)step * 1.0E-8f));
    }

    private static int trailEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord + (float)step * 1.0E-8f));
    }

    public static boolean isAt(Entity mob, Path path, float threshold, float verticalThreshold) {
        Vec3 pathPos = path.m_77380_(mob);
        return Math.abs(mob.m_20185_() - pathPos.f_82479_) < (double)threshold && Math.abs(mob.m_20189_() - pathPos.f_82481_) < (double)threshold && Math.abs(mob.m_20186_() - pathPos.f_82480_) <= (double)verticalThreshold;
    }

    public static boolean atElevationChange(Entity mob, Path path) {
        int curr = path.m_77399_();
        int end = Math.min(path.m_77398_(), curr + Mth.m_14167_((float)(mob.m_20205_() * 0.5f)) + 1);
        int currY = path.m_77375_((int)curr).f_77272_;
        for (int i = curr + 1; i < end; ++i) {
            if (path.m_77375_((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }
}

