/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CordaitesTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        int treeHeight = context.m_225041_().m_188503_(8) + 10;
        int m = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        BlockState log = ((RotatedPillarBlock)ModBlocks.CORDAITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CORDAITES_LEAVES.get()).m_49966_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            level.m_7731_(pos.m_121945_(direction), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 19);
            this.placeLeaf(level, pos.m_121945_(direction).m_6630_(treeHeight), leaves);
        }
        this.placeLeaf(level, pos.m_6630_(treeHeight), leaves);
        this.placeLeaf(level, pos.m_6630_(treeHeight + 1), leaves);
        for (int i = 0; i < treeHeight; ++i) {
            level.m_7731_(pos.m_6630_(i), log, 19);
            if (!((double)i > (double)treeHeight * 0.6)) continue;
            int heightMinus = (int)((double)i - (double)treeHeight * 0.6);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!CordaitesTreeFeature.canPlaceBranch(level, pos.m_6630_(i - 1).m_121945_(direction))) continue;
                this.placeBranch(level, context.m_225041_(), pos.m_6630_(i), direction, Math.max(1, 2 + context.m_225041_().m_188503_(2) - heightMinus));
            }
        }
        return true;
    }

    private static boolean canPlaceBranch(WorldGenLevel level, BlockPos pos) {
        return level.m_46859_(pos) || level.m_8055_(pos).m_247087_() || level.m_8055_(pos).m_60734_() instanceof LeavesBlock;
    }

    private void placeBranch(WorldGenLevel level, RandomSource random, BlockPos pos, Direction direction, int length) {
        BlockState log = ((RotatedPillarBlock)ModBlocks.CORDAITES_LOG.get()).m_49966_();
        BlockState leaves = ((LeavesBlock)ModBlocks.CORDAITES_LEAVES.get()).m_49966_();
        int yOffset = 0;
        for (int i = 1; i <= length; ++i) {
            level.m_7731_(pos.m_5484_(direction, i).m_6630_(yOffset), (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 19);
            if (i == length) {
                this.placeLeaf(level, pos.m_5484_(direction, i + 1).m_6630_(yOffset), leaves);
                this.placeLeaf(level, pos.m_5484_(direction, i).m_6630_(yOffset).m_121945_(direction.m_122428_()), leaves);
                this.placeLeaf(level, pos.m_5484_(direction, i).m_6630_(yOffset).m_121945_(direction.m_122427_()), leaves);
                this.placeLeaf(level, pos.m_5484_(direction, i + 1).m_6630_(yOffset).m_121945_(direction.m_122428_()), leaves);
                this.placeLeaf(level, pos.m_5484_(direction, i + 1).m_6630_(yOffset).m_121945_(direction.m_122427_()), leaves);
                this.placeLeaf(level, pos.m_5484_(direction, i + 2).m_6630_(yOffset + 1), leaves);
            }
            if (i <= 2 || !random.m_188499_()) continue;
            ++yOffset;
        }
    }
}

