/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.internal;

import com.github.darkpred.morehitboxes.api.AttackBoxData;
import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.api.MultiPartEntity;
import com.github.darkpred.morehitboxes.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AttackBoxDataInternal<T extends Mob>
implements AttackBoxData {
    private final Map<String, HitboxData> attackBoxes = new Object2ObjectOpenHashMap();
    private final Map<HitboxData, Vec3> activeAttackBoxes = new Object2ObjectOpenHashMap();
    private long attackBoxEndTime;
    private final T entity;

    public AttackBoxDataInternal(T entity) {
        this.entity = entity;
    }

    @Override
    public void addAttackBox(String ref, HitboxData hitboxData) {
        this.attackBoxes.put(ref, hitboxData);
    }

    @Override
    public HitboxData getAttackBox(String ref) {
        return this.attackBoxes.get(ref);
    }

    @Override
    public void moveActiveAttackBox(HitboxData attackBox, Vec3 worldPos) {
        this.activeAttackBoxes.put(attackBox, worldPos);
    }

    @Override
    public boolean isAttackBoxActive(HitboxData attackBox) {
        return this.activeAttackBoxes.containsKey(attackBox);
    }

    @Override
    public void activateAttackBoxes(Level level, double attackDuration) {
        this.attackBoxes.values().forEach(hitbox -> this.activeAttackBoxes.put((HitboxData)hitbox, Vec3.f_82478_));
        this.attackBoxEndTime = (long)((double)level.m_46467_() + attackDuration);
    }

    @Override
    public void clientTick(Level level) {
        if (level.m_46467_() > this.attackBoxEndTime) {
            this.activeAttackBoxes.clear();
        }
        for (Map.Entry<HitboxData, Vec3> entry : this.activeAttackBoxes.entrySet()) {
            HitboxData hitbox = entry.getKey();
            EntityDimensions size = EntityDimensions.m_20395_((float)hitbox.width(), (float)hitbox.height()).m_20388_(this.entity.m_6134_());
            AABB aabb = size.m_20393_(entry.getValue());
            Player player = DistUtilFactory.DIST_UTIL.handleIntersect(aabb);
            if (player == null) continue;
            if (!((MultiPartEntity)this.entity).attackBoxHit(player)) break;
            this.activeAttackBoxes.clear();
            break;
        }
    }

    @Override
    public Map<HitboxData, Vec3> getActiveBoxes() {
        return this.activeAttackBoxes;
    }

    @Override
    public long attackBoxEndTime() {
        return this.attackBoxEndTime;
    }

    @ApiStatus.Internal
    public static interface DistUtilFactory {
        public static final DistUtilFactory DIST_UTIL = Services.load(DistUtilFactory.class);

        public Player handleIntersect(AABB var1);
    }
}

