/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DinopediaBioLoader
extends ResourceLoader<Map<String, Map<String, String>>> {
    public static final DinopediaBioLoader INSTANCE = new DinopediaBioLoader();
    private static final Logger LOGGER = LogUtils.getLogger();
    private ImmutableMap<String, String> englishFallback = ImmutableMap.of();
    private ImmutableMap<String, String> dinopediaTexts = ImmutableMap.of();

    public DinopediaBioLoader() {
        super(class_3264.field_14188, "dinopedia", ".txt");
    }

    @NotNull
    protected Map<String, Map<String, String>> prepare(class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder selectedLangBuilder = ImmutableMap.builder();
        ImmutableMap.Builder fallbackLangBuilder = ImmutableMap.builder();
        int i = this.directory.length() + 1;
        String selectedLang = class_310.method_1551().field_1690.field_1883;
        for (Map.Entry<class_2960, class_3298> entry : this.listResources(resourceManager).entrySet()) {
            String path = entry.getKey().method_12832();
            class_2960 locationWithLang = new class_2960(entry.getKey().method_12836(), path.substring(i, path.length() - this.suffix.length()));
            try {
                String[] dinoInfo = locationWithLang.method_12832().split("/");
                if (selectedLang.equals(dinoInfo[0])) {
                    String text = this.readFile(entry.getValue());
                    selectedLangBuilder.put((Object)dinoInfo[1], (Object)text);
                    if (!"en_us".equals(selectedLang)) continue;
                    fallbackLangBuilder.put((Object)dinoInfo[1], (Object)text);
                    continue;
                }
                if (!"en_us".equals(dinoInfo[0])) continue;
                fallbackLangBuilder.put((Object)dinoInfo[1], (Object)this.readFile(entry.getValue()));
            }
            catch (IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{locationWithLang, entry.getKey(), exception});
            }
        }
        mapBuilder.put((Object)selectedLang, (Object)selectedLangBuilder.build());
        if (!selectedLang.equals("en_us")) {
            mapBuilder.put((Object)"en_us", (Object)fallbackLangBuilder.build());
        }
        return mapBuilder.build();
    }

    private String readFile(class_3298 resource) throws IOException {
        try (BufferedReader reader = resource.method_43039();){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
    }

    protected void apply(Map<String, Map<String, String>> files, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder selectedBuilder = ImmutableMap.builder();
        ImmutableMap.Builder fallbackBuilder = ImmutableMap.builder();
        this.dinopediaTexts = selectedBuilder.putAll(files.get(class_310.method_1551().field_1690.field_1883)).build();
        this.englishFallback = fallbackBuilder.putAll(files.get("en_us")).build();
        FossilMod.LOGGER.info("Loaded {} dinopedia texts for {}", (Object)this.dinopediaTexts.size(), (Object)class_310.method_1551().field_1690.field_1883);
        FossilMod.LOGGER.info("Loaded {} fallback dinopedia texts for {}", (Object)this.englishFallback.size(), (Object)"en_us");
    }

    public boolean hasFallback(String entityName) {
        return this.englishFallback.containsKey((Object)entityName);
    }

    public String getDinopediaBio(String entityName) {
        if (this.dinopediaTexts.containsKey((Object)entityName)) {
            return (String)this.dinopediaTexts.get((Object)entityName);
        }
        if (this.englishFallback.containsKey((Object)entityName)) {
            return (String)this.englishFallback.get((Object)entityName);
        }
        return "No bio found. This should not have happened";
    }
}

