/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.StringUtils;

public abstract class Instruction {
    public final Type type;

    private Instruction(Type type) {
        this.type = type;
    }

    public static void encodeBuffer(List<Instruction> instructions, class_2540 buf) {
        for (Instruction instruction : instructions) {
            buf.method_10794(instruction.encodeTag());
        }
    }

    public class_2487 encodeTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("Type", this.type.name());
        return tag;
    }

    public static Instruction decodeFromTag(class_2487 tag) {
        try {
            Type type = Type.valueOf(tag.method_10558("Type"));
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.MOVE_TO -> MoveTo.decodeTag(tag);
                case Type.FLY_TO -> FlyTo.decodeTag(tag);
                case Type.FLY_LAND -> FlyLand.decodeTag(tag);
                case Type.TELEPORT_TO -> TeleportTo.decodeTag(tag);
                case Type.ATTACH_TO -> AttachTo.decodeTag(tag);
                case Type.LEAP_ATTACK -> LeapAttack.decodeTag(tag);
                case Type.LEAP_LAND -> LeapLand.decodeTag(tag);
                case Type.PLAY_ANIM -> PlayAnim.decodeTag(tag);
                case Type.IDLE -> Idle.decodeTag(tag);
                case Type.SLEEP -> Sleep.decodeTag(tag);
            };
        }
        catch (RuntimeException e) {
            FossilMod.LOGGER.error("Could not read Instruction enum from tag: ", (Throwable)e);
            return new Idle(0);
        }
    }

    public static List<Instruction> decodeBuffer(class_2540 buf) {
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        while (buf.isReadable()) {
            try {
                class_2487 tag = buf.method_10798();
                if (tag == null) continue;
                list.add(Instruction.decodeFromTag(tag));
            }
            catch (RuntimeException e) {
                FossilMod.LOGGER.error("Could not read Instruction enum from buffer: ", (Throwable)e);
                return List.of();
            }
        }
        return list;
    }

    public static enum Type {
        MOVE_TO,
        FLY_TO,
        FLY_LAND,
        PLAY_ANIM,
        IDLE,
        TELEPORT_TO,
        LEAP_ATTACK,
        LEAP_LAND,
        ATTACH_TO,
        SLEEP;

    }

    public static class MoveTo
    extends Instruction {
        public final class_2338 target;

        public MoveTo(class_2338 target) {
            super(Type.MOVE_TO);
            this.target = target;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new MoveTo(class_2512.method_10691((class_2487)tag.method_10562("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.method_10263() + " " + this.target.method_10264() + " " + this.target.method_10260();
        }
    }

    public static class FlyTo
    extends Instruction {
        public final class_2338 target;

        public FlyTo(class_2338 target) {
            super(Type.FLY_TO);
            this.target = target;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new FlyTo(class_2512.method_10691((class_2487)tag.method_10562("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.method_10263() + " " + this.target.method_10264() + " " + this.target.method_10260();
        }
    }

    public static class FlyLand
    extends Instruction {
        public final class_2338 target;

        public FlyLand(class_2338 target) {
            super(Type.FLY_LAND);
            this.target = target;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new FlyLand(class_2512.method_10691((class_2487)tag.method_10562("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.method_10263() + " " + this.target.method_10264() + " " + this.target.method_10260();
        }
    }

    public static class TeleportTo
    extends Instruction {
        public final class_2338 target;
        public final int rotation;

        public TeleportTo(class_2338 target, int rotation) {
            super(Type.TELEPORT_TO);
            this.target = target;
            this.rotation = rotation;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
            tag.method_10569("Rotation", this.rotation);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new TeleportTo(class_2512.method_10691((class_2487)tag.method_10562("Target")), tag.method_10550("Rotation"));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.method_10263() + " " + this.target.method_10264() + " " + this.target.method_10260();
        }
    }

    public static class AttachTo
    extends Instruction {
        public final class_2338 target;
        public final class_2350 direction;
        public final class_243 location;

        public AttachTo(class_2338 target, class_2350 direction, class_243 location) {
            super(Type.ATTACH_TO);
            this.target = target;
            this.direction = direction;
            this.location = location;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10566("Target", (class_2520)class_2512.method_10692((class_2338)this.target));
            tag.method_10569("Direction", this.direction.ordinal());
            tag.method_10549("LocationX", this.location.field_1352);
            tag.method_10549("LocationY", this.location.field_1351);
            tag.method_10549("LocationZ", this.location.field_1350);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new AttachTo(class_2512.method_10691((class_2487)tag.method_10562("Target")), class_2350.values()[tag.method_10550("Direction")], new class_243(tag.method_10574("LocationX"), tag.method_10574("LocationY"), tag.method_10574("LocationZ")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.method_10263() + " " + this.target.method_10264() + " " + this.target.method_10260() + " " + this.direction.name();
        }
    }

    public static class LeapAttack
    extends Instruction {
        public final int targetId;

        public LeapAttack(int targetId) {
            super(Type.LEAP_ATTACK);
            this.targetId = targetId;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10569("TargetId", this.targetId);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new LeapAttack(tag.method_10550("TargetId"));
        }

        public String toString() {
            return this.type.name() + ": " + this.targetId;
        }
    }

    public static class LeapLand
    extends Instruction {
        public final class_243 location;
        public final class_243 locationAbove;

        public LeapLand(class_243 location, class_243 locationAbove) {
            super(Type.LEAP_LAND);
            this.location = location;
            this.locationAbove = locationAbove;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10549("LocationX", this.location.field_1352);
            tag.method_10549("LocationY", this.location.field_1351);
            tag.method_10549("LocationZ", this.location.field_1350);
            tag.method_10549("LocationAboveX", this.locationAbove.field_1352);
            tag.method_10549("LocationAboveY", this.locationAbove.field_1351);
            tag.method_10549("LocationAboveZ", this.locationAbove.field_1350);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new LeapLand(new class_243(tag.method_10574("LocationX"), tag.method_10574("LocationY"), tag.method_10574("LocationZ")), new class_243(tag.method_10574("LocationAboveX"), tag.method_10574("LocationAboveY"), tag.method_10574("LocationAboveZ")));
        }

        public String toString() {
            return this.type.name() + ": " + this.location;
        }
    }

    public static class PlayAnim
    extends Instruction {
        public final String name;
        public final String controller;
        public final boolean timeBased;
        public final int count;
        private final String displayName;

        public PlayAnim(String name, String controller, boolean timeBased, int count) {
            super(Type.PLAY_ANIM);
            this.name = name;
            this.controller = controller;
            this.timeBased = timeBased;
            this.count = count;
            String[] split = name.split("\\.");
            this.displayName = split.length > 0 ? StringUtils.capitalize((String)split[split.length - 1]) : "";
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10582("Name", this.name);
            tag.method_10582("Controller", this.controller);
            tag.method_10556("TimeBased", this.timeBased);
            tag.method_10569("Count", this.count);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new PlayAnim(tag.method_10558("Name"), tag.method_10558("Controller"), tag.method_10577("TimeBased"), tag.method_10550("Count"));
        }

        public String toString() {
            return this.type.name() + ": " + this.displayName + " " + this.timeBased + " " + this.count;
        }
    }

    public static class Idle
    extends Instruction {
        public final int duration;

        public Idle(int duration) {
            super(Type.IDLE);
            this.duration = duration;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10569("Duration", this.duration);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new Idle(tag.method_10550("Duration"));
        }

        public String toString() {
            return this.type.name() + ": " + (float)this.duration / 20.0f;
        }
    }

    public static class Sleep
    extends Instruction {
        public final int duration;

        public Sleep(int duration) {
            super(Type.SLEEP);
            this.duration = duration;
        }

        @Override
        public class_2487 encodeTag() {
            class_2487 tag = super.encodeTag();
            tag.method_10569("Duration", this.duration);
            return tag;
        }

        protected static Instruction decodeTag(class_2487 tag) {
            return new Sleep(tag.method_10550("Duration"));
        }

        public String toString() {
            return this.type.name() + ": " + (float)this.duration / 20.0f;
        }
    }
}

