/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugMoveControl;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_14;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class PlayerPathNavigation {
    private static final int MAX_TIME_RECOMPUTE = 20;
    protected final class_1657 player;
    protected final class_1937 level;
    @Nullable
    protected PlayerPath path;
    protected double speedModifier = 1.0;
    protected int tick;
    protected int lastStuckCheck;
    protected class_243 lastStuckCheckPos = class_243.field_1353;
    protected class_2382 timeoutCachedNode = class_2382.field_11176;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 0.5f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected PlayerNodeEvaluator nodeEvaluator;
    @Nullable
    private class_2338 targetPos;
    private int reachRange;
    protected float maxVisitedNodesMultiplier = 1.0f;
    private final PlayerPathFinder pathFinder;
    private boolean isStuck;
    public boolean shouldRender;
    public String name;
    public class_243 wantedPos;
    public class_243 sweepStartPos;
    public class_243 sweepWantedPos;
    public DebugMoveControl moveControl;

    public PlayerPathNavigation(class_1657 p, class_1937 l, String name) {
        this.player = p;
        this.level = l;
        this.name = name;
        int i = class_3532.method_15375((float)256.0f);
        this.pathFinder = this.createPathFinder(i);
        this.moveControl = new DebugMoveControl(p);
    }

    @Nullable
    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    protected PlayerPathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new PlayerNodeEvaluator();
        return new PlayerPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    public void recomputePath() {
        if (this.level.method_8510() - this.timeLastRecompute > 20L) {
            if (this.targetPos != null) {
                this.path = null;
                this.path = this.createPath(this.targetPos, this.reachRange);
                this.timeLastRecompute = this.level.method_8510();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    @Nullable
    public PlayerPath createPath(class_2338 pos, int accuracy) {
        class_2338 blockPos;
        if (this.level.method_8320(pos).method_26215()) {
            blockPos = pos.method_10074();
            while (blockPos.method_10264() > this.level.method_31607() && this.level.method_8320(blockPos).method_26215()) {
                blockPos = blockPos.method_10074();
            }
            if (blockPos.method_10264() > this.level.method_31607()) {
                return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, accuracy);
            }
            while (blockPos.method_10264() < this.level.method_31600() && this.level.method_8320(blockPos).method_26215()) {
                blockPos = blockPos.method_10084();
            }
            pos = blockPos;
        }
        if (this.level.method_8320(pos).method_51367()) {
            blockPos = pos.method_10084();
            while (blockPos.method_10264() < this.level.method_31600() && this.level.method_8320(blockPos).method_51367()) {
                blockPos = blockPos.method_10084();
            }
            return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, accuracy);
        }
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    @Nullable
    public PlayerPath createPath(class_1297 entity, int accuracy) {
        return this.createPath(entity.method_24515(), accuracy);
    }

    @Nullable
    protected PlayerPath createPath(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy) {
        return this.createPath(targets, regionOffset, offsetUpward, accuracy, 32.0f);
    }

    @Nullable
    protected PlayerPath createPath(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
        int i;
        if (targets.isEmpty()) {
            return null;
        }
        if (this.player.method_23318() < (double)this.level.method_31607()) {
            return null;
        }
        if (!this.canUpdatePath()) {
            return null;
        }
        if (this.path != null && !this.path.isDone() && targets.contains(this.targetPos)) {
            return this.path;
        }
        class_2338 blockPos = offsetUpward ? this.player.method_24515().method_10084() : this.player.method_24515();
        class_1950 pathNavigationRegion = new class_1950(this.level, blockPos.method_10069(-(i = (int)(followRange + (float)regionOffset)), -i, -i), blockPos.method_10069(i, i, i));
        PlayerPath path = this.pathFinder.findPath(pathNavigationRegion, this.player, targets, followRange, accuracy, this.maxVisitedNodesMultiplier);
        if (path != null && path.getTarget() != null) {
            this.targetPos = path.getTarget();
            this.reachRange = accuracy;
            this.resetStuckTimeout();
        }
        return path;
    }

    public boolean moveTo(class_2338 targetPos) {
        PlayerPath path = this.createPath(targetPos, 1);
        return path != null && this.moveTo(path);
    }

    public boolean moveTo(@Nullable PlayerPath pathentity) {
        if (pathentity == null) {
            this.path = null;
            return false;
        }
        if (!pathentity.sameAs(this.path)) {
            this.path = pathentity;
        }
        if (this.isDone()) {
            return false;
        }
        this.trimPath();
        if (this.path.getNodeCount() <= 0) {
            return false;
        }
        this.lastStuckCheck = this.tick;
        this.lastStuckCheckPos = this.getTempMobPos();
        return true;
    }

    @Nullable
    public PlayerPath getPath() {
        return this.path;
    }

    public void tick() {
        class_243 vec3;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            vec3 = this.getTempMobPos();
            class_243 vec32 = this.path.getNextEntityPos((class_1297)this.player);
            if (vec3.field_1351 > vec32.field_1351 && !this.player.method_24828() && class_3532.method_15357((double)vec3.field_1352) == class_3532.method_15357((double)vec32.field_1352) && class_3532.method_15357((double)vec3.field_1350) == class_3532.method_15357((double)vec32.field_1350)) {
                this.path.advance();
            }
        }
        if (this.isDone()) {
            return;
        }
        vec3 = this.path.getNextEntityPos((class_1297)this.player);
        this.setNextWantedPosition(vec3.field_1352, this.getGroundY(vec3), vec3.field_1350);
        vec3 = this.path.getSweepEntityPos((class_1297)this.player);
        this.setSweepWantedPosition(vec3.field_1352, this.getGroundY(vec3), vec3.field_1350);
        this.moveControl.tick();
    }

    public void setNextWantedPosition(double x, double y, double z) {
        this.wantedPos = new class_243(x, y, z);
        this.moveControl.setWantedPosition(x, y, z, this.speedModifier);
    }

    public void setSweepWantedPosition(double x, double y, double z) {
        this.sweepWantedPos = new class_243(x, y, z);
    }

    public void setSweepStartPos(class_243 vec) {
        this.sweepStartPos = vec;
    }

    protected double getGroundY(class_243 vec) {
        class_2338 blockPos = class_2338.method_49638((class_2374)vec);
        return this.level.method_8320(blockPos.method_10074()).method_26215() ? vec.field_1351 : class_14.method_60((class_1922)this.level, (class_2338)blockPos);
    }

    protected void followThePath() {
        boolean bl;
        class_243 vec3 = this.getTempMobPos();
        this.maxDistanceToWaypoint = PathingRenderer.getBbWidth() > 0.75f ? PathingRenderer.getBbWidth() / 2.0f : 0.75f - PathingRenderer.getBbWidth() / 2.0f;
        class_2338 vec3i = this.path.getNextNodePos();
        double d = Math.abs(this.player.method_23317() - ((double)vec3i.method_10263() + 0.5));
        double e = Math.abs(this.player.method_23318() - (double)vec3i.method_10264());
        double f = Math.abs(this.player.method_23321() - ((double)vec3i.method_10260() + 0.5));
        boolean bl2 = bl = d < (double)this.maxDistanceToWaypoint && f < (double)this.maxDistanceToWaypoint && e < 1.0;
        if (bl || this.canCutCorner(this.path.getNextNode().field_41) && this.shouldTargetNextNodeInDirection(vec3)) {
            this.path.advance();
        }
    }

    public boolean canCutCorner(class_7 pathType) {
        return pathType != class_7.field_9 && pathType != class_7.field_5 && pathType != class_7.field_26446;
    }

    private boolean shouldTargetNextNodeInDirection(class_243 vec) {
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        class_243 vec3 = class_243.method_24955((class_2382)this.path.getNextNodePos());
        if (!vec.method_24802((class_2374)vec3, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(vec, this.path.getNextEntityPos((class_1297)this.player))) {
            return true;
        }
        class_243 vec32 = class_243.method_24955((class_2382)this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        class_243 vec33 = vec32.method_1020(vec3);
        return vec33.method_1026(vec.method_1020(vec3)) > 0.0;
    }

    protected void doStuckDetection(class_243 positionVec3) {
        if (this.tick - this.lastStuckCheck > 100) {
            if (positionVec3.method_1025(this.lastStuckCheckPos) < 2.25) {
                this.isStuck = true;
                this.stop();
            } else {
                this.isStuck = false;
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = positionVec3;
        }
        if (this.path != null && !this.path.isDone()) {
            class_2338 vec3i = this.path.getNextNodePos();
            if (vec3i.equals((Object)this.timeoutCachedNode)) {
                this.timeoutTimer += class_156.method_658() - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = vec3i;
                double d = positionVec3.method_1022(class_243.method_24955((class_2382)this.timeoutCachedNode));
                double d2 = this.timeoutLimit = this.player.method_6029() > 0.0f ? d / (double)this.player.method_6029() * 1000.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutPath();
            }
            this.lastTimeoutCheck = class_156.method_658();
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = class_2382.field_11176;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return this.path == null || this.path.isDone();
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.path = null;
    }

    protected class_243 getTempMobPos() {
        return new class_243(this.player.method_23317(), (double)this.getSurfaceY(), this.player.method_23321());
    }

    private int getSurfaceY() {
        if (!this.player.method_5799() || !this.canFloat()) {
            return class_3532.method_15357((double)(this.player.method_23318() + 0.5));
        }
        int i = this.player.method_31478();
        class_2680 blockState = this.level.method_8320(class_2338.method_49637((double)this.player.method_23317(), (double)i, (double)this.player.method_23321()));
        int j = 0;
        while (blockState.method_27852(class_2246.field_10382)) {
            blockState = this.level.method_8320(class_2338.method_49637((double)this.player.method_23317(), (double)(++i), (double)this.player.method_23321()));
            if (++j <= 16) continue;
            return this.player.method_31478();
        }
        return i;
    }

    protected boolean canUpdatePath() {
        return this.player.method_24828() || this.player.method_31549().field_7479 || this.isInLiquid() || this.player.method_5765();
    }

    protected boolean isInLiquid() {
        return this.player.method_5816() || this.player.method_5771();
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            class_9 node = this.path.getNode(i);
            class_9 node2 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            class_2680 blockState = this.level.method_8320(new class_2338(node.field_40, node.field_39, node.field_38));
            if (!blockState.method_26164(class_3481.field_26985)) continue;
            this.path.replaceNode(i, node.method_26(node.field_40, node.field_39 + 1, node.field_38));
            if (node2 == null || node.field_39 < node2.field_39) continue;
            this.path.replaceNode(i + 1, node.method_26(node2.field_40, node.field_39 + 1, node2.field_38));
        }
    }

    protected boolean canMoveDirectly(class_243 posVec31, class_243 posVec32) {
        return false;
    }

    public boolean canFloat() {
        return this.nodeEvaluator.canFloat();
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

