/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.rei;

import com.github.teamfossilsarcheology.fossil.compat.rei.MultiOutputDisplay;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputCategory
implements DisplayCategory<MultiOutputDisplay> {
    public int getDisplayHeight() {
        return 106;
    }

    public List<Widget> setupDisplay(MultiOutputDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getMinX(), bounds.getMinY());
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.getCenterX() - 8, startPoint.y + 5)).entries((Collection)display.getInputEntries().get(0)).markInput());
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2 + 4, bounds.y + 23, bounds.width - 8, bounds.height - 28);
        widgets.add(Widgets.createSlotBase((Rectangle)rectangle));
        widgets.add(new ScrollableSlotsWidget(rectangle, display.outputs));
        return widgets;
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private static final float DEFAULT_SPACE = 25.0f;
        private static final DecimalFormat FORMAT = new DecimalFormat("#.#'%'");
        private final Rectangle boundsRect;
        private final Map<Slot, Double> probabilities;
        private final List<Slot> widgets;
        private final ScrollingContainer scrolling = new ScrollingContainer(){
            private boolean draggingScrollBar;

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                double numPerRow = Math.floor((float)boundsRect.width / 25.0f);
                return class_3532.method_15384((double)((double)widgets.size() / numPerRow)) * 24 + 4;
            }

            public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy, boolean snapToRows, double rowSize) {
                if (button == 0 && this.draggingScrollBar) {
                    float height = this.getMaxScrollHeight();
                    Rectangle bounds = this.getBounds();
                    int actualHeight = bounds.height;
                    if (mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
                        double maxScroll = Math.max(1, this.getMaxScroll());
                        double int3 = class_3532.method_15350((double)((double)(actualHeight * actualHeight) / (double)height), (double)32.0, (double)(actualHeight - 8));
                        double double6 = Math.max(1.0, maxScroll / ((double)actualHeight - int3));
                        float to = class_3532.method_15363((float)((float)(this.scrollAmount() + dy * double6)), (float)0.0f, (float)this.getMaxScroll());
                        if (snapToRows) {
                            double nearestRow = (double)Math.round((double)to / rowSize) * rowSize;
                            this.scrollTo(nearestRow, false);
                        } else {
                            this.scrollTo(to, false);
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean updateDraggingState(double mouseX, double mouseY, int button) {
                double scrollbarPositionMinX;
                if (!this.hasScrollBar()) {
                    return false;
                }
                int height = this.getMaxScroll() + boundsRect.height;
                Rectangle bounds = this.getBounds();
                int actualHeight = bounds.height;
                if (height > actualHeight && mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY() && mouseX >= (scrollbarPositionMinX = (double)this.getScrollBarX(bounds.getMaxX())) - 1.0 && mouseX <= scrollbarPositionMinX + 8.0) {
                    this.draggingScrollBar = true;
                    return true;
                }
                this.draggingScrollBar = false;
                return false;
            }
        };

        public ScrollableSlotsWidget(Rectangle bounds, List<MultiOutputDisplay.WeightedItem> outputs) {
            this.boundsRect = Objects.requireNonNull(bounds);
            this.probabilities = new Object2DoubleOpenHashMap();
            this.widgets = new ArrayList<Slot>();
            for (MultiOutputDisplay.WeightedItem weightedItem : outputs) {
                Slot slot = Widgets.createSlot((Point)new Point(0, 0)).disableBackground().entries((Collection)weightedItem.item()).markOutput();
                this.widgets.add(slot);
                this.probabilities.put(slot, weightedItem.probability());
            }
        }

        public boolean method_25401(double mouseX, double mouseY, double delta) {
            if (this.containsMouse(mouseX, mouseY)) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -delta, true);
                return true;
            }
            return false;
        }

        public Rectangle getBounds() {
            return this.boundsRect;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        private double calcActualSpace(Rectangle innerBounds, double numPerRow) {
            if ((double)this.widgets.size() <= numPerRow) {
                return 25.0;
            }
            return Math.floor((double)innerBounds.width / numPerRow);
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            try (CloseableScissors ignored = ScrollableSlotsWidget.scissor((class_332)guiGraphics, (Rectangle)innerBounds);){
                double numPerRow = Math.floor((float)innerBounds.width / 25.0f);
                double actualSpace = this.calcActualSpace(innerBounds, numPerRow);
                double xOffset = (actualSpace - 18.0) / 2.0;
                int y = 0;
                while ((double)y < Math.ceil((double)this.widgets.size() / numPerRow)) {
                    int x = 0;
                    while ((double)x < numPerRow) {
                        int index = (int)((double)y * numPerRow + (double)x);
                        if (this.widgets.size() <= index) break;
                        Slot widget = this.widgets.get(index);
                        widget.getBounds().setLocation((double)this.boundsRect.x + xOffset + (double)x * actualSpace, (double)((float)(this.boundsRect.y + 1) + (float)y * 25.0f - (float)this.scrolling.scrollAmountInt()));
                        widget.method_25394(guiGraphics, mouseX, mouseY, delta);
                        this.renderProbability(guiGraphics, class_310.method_1551().field_1772, this.probabilities.get(widget), widget.getBounds().x, widget.getBounds().y);
                        ++x;
                    }
                    ++y;
                }
            }
            ignored = ScrollableSlotsWidget.scissor((class_332)guiGraphics, (Rectangle)this.scrolling.getBounds());
            try {
                this.renderFixedScrollbar(-16777216, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        private void renderProbability(class_332 guiGraphics, class_327 fr, double stack, int xPosition, int yPosition) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22904(0.0, 0.0, 300.0);
            String string = FORMAT.format(stack);
            class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            float xOffset = Math.min(11.0f, (float)fr.method_1727(string) / 2.0f);
            fr.method_27521(string, (float)(xPosition + 8) - xOffset, (float)(yPosition + 16 + 1), 0xFFFFFF, true, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            bufferSource.method_22993();
            guiGraphics.method_51448().method_22909();
        }

        private void renderFixedScrollbar(int background, float alpha, float scrollBarAlphaOffset) {
            Rectangle bounds = this.scrolling.getBounds();
            int maxScroll = this.scrolling.getMaxScroll() == 0 ? 1 : this.scrolling.getMaxScroll();
            int height = bounds.height * bounds.height / this.scrolling.getMaxScrollHeight();
            height = class_3532.method_15340((int)height, (int)32, (int)bounds.height);
            height = (int)((double)height - Math.min(this.scrolling.scrollAmount() < 0.0 ? (double)((int)(-this.scrolling.scrollAmount())) : (double)(this.scrolling.scrollAmount() > (double)maxScroll ? (int)this.scrolling.scrollAmount() - maxScroll : 0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrolling.scrollAmount() * (bounds.height - height) / maxScroll + bounds.y, bounds.y), bounds.getMaxY() - height);
            int scrollbarPositionMinX = this.scrolling.getScrollBarX(bounds.getMaxX());
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * scrollBarAlphaOffset;
            float topC = (hovered ? 0.87f : 0.67f) * scrollBarAlphaOffset;
            RenderSystem.setShader(class_757::method_34540);
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            float a = (float)(background >> 24 & 0xFF) / 255.0f;
            float r = (float)(background >> 16 & 0xFF) / 255.0f;
            float g = (float)(background >> 8 & 0xFF) / 255.0f;
            float b = (float)(background & 0xFF) / 255.0f;
            buffer.method_22912((double)scrollbarPositionMinX, (double)bounds.getMaxY(), 10.0).method_22915(r, g, b, a).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)bounds.getMaxY(), 10.0).method_22915(r, g, b, a).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)bounds.y, 10.0).method_22915(r, g, b, a).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)bounds.y, 10.0).method_22915(r, g, b, a).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 10.0).method_22915(bottomC, bottomC, bottomC, alpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 10.0).method_22915(bottomC, bottomC, bottomC, alpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 10.0).method_22915(bottomC, bottomC, bottomC, alpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 10.0).method_22915(bottomC, bottomC, bottomC, alpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 10.0).method_22915(topC, topC, topC, alpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 10.0).method_22915(topC, topC, topC, alpha).method_1344();
            buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 10.0).method_22915(topC, topC, topC, alpha).method_1344();
            buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 10.0).method_22915(topC, topC, topC, alpha).method_1344();
            tesselator.method_1350();
            RenderSystem.disableBlend();
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }
    }
}

