/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Trilobite;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import java.util.EnumSet;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HuntingTargetGoal
extends class_1405 {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    private final int randomInterval = HuntingTargetGoal.method_38848((int)10);
    private final Prehistoric dino;
    private final class_4051 huntTargetConditions = class_4051.method_36625().method_18418(this.method_6326()).method_18420(this::canTarget);
    @Nullable
    private class_1309 target;

    public HuntingTargetGoal(Prehistoric prehistoric) {
        super((class_1308)prehistoric, true, true);
        this.dino = prehistoric;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public void method_6269() {
        this.field_6660.method_5980(this.target);
        this.dino.moodSystem.setToyTarget(null);
        super.method_6269();
    }

    public void method_6270() {
        super.method_6270();
        this.target = null;
    }

    public boolean method_6264() {
        if (this.randomInterval > 0 && this.field_6660.method_6051().method_43048(this.randomInterval) != 0 || this.dino.method_6062()) {
            return false;
        }
        if (this.dino.isHungry() && !this.dino.method_6109()) {
            this.target = this.findHuntingTarget();
            return this.target != null;
        }
        return false;
    }

    private boolean canTargetHumanoid(class_1309 entity) {
        if (this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.HAPPY || this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.CONTENT) {
            return false;
        }
        if (this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.ANGRY || this.dino.moodSystem.getMoodFace() == PrehistoricMoodType.SAD) {
            return true;
        }
        return FoodMappings.getMobFoodPoints(entity, this.dino.data().diet()) > 0 && this.dino.method_17681() * this.dino.getTargetScale() >= entity.method_17681();
    }

    private boolean canTargetPlayer(class_1657 player) {
        if (player.method_7337()) {
            return false;
        }
        return this.canTargetHumanoid((class_1309)player);
    }

    public boolean method_6266() {
        if (!super.method_6266()) {
            return false;
        }
        class_1309 class_13092 = this.target;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return !player.method_7337() && this.canTargetPlayer(player);
        }
        return true;
    }

    private boolean canTarget(class_1309 target) {
        if (this.dino.aiResponseType() == PrehistoricEntityInfoAI.Response.SCARED) {
            return false;
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            return this.canTargetPlayer(player);
        }
        if (target instanceof class_1646) {
            return this.canTargetHumanoid(target);
        }
        if (this.dino instanceof Trilobite && target instanceof Trilobite) {
            return false;
        }
        boolean canTarget = true;
        Prehistoric prehistoric = this.dino;
        if (prehistoric instanceof PrehistoricSwimming) {
            PrehistoricSwimming swimming = (PrehistoricSwimming)prehistoric;
            if (!target.method_5799() && !swimming.canHuntMobsOnLand()) {
                canTarget = false;
            }
        }
        if (target.method_5799() && this.dino.aiMovingType() != PrehistoricEntityInfoAI.Moving.AQUATIC && this.dino.aiMovingType() != PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
            class_2338 pos = class_2338.method_49637((double)target.method_23317(), (double)target.method_5829().field_1325, (double)target.method_23321());
            if (!this.dino.method_37908().method_8316(pos).method_15769() && !this.dino.method_37908().method_8316(pos.method_10084()).method_15769()) {
                canTarget = false;
            }
        }
        boolean isFood = FoodMappings.getMobFoodPoints(target, this.dino.data().diet()) > 0;
        boolean smallEnough = this.dino.method_5829().method_995() * (double)this.dino.getTargetScale() >= target.method_5829().method_995();
        return canTarget && isFood && smallEnough && !target.getClass().equals(this.dino.getClass());
    }

    private class_1309 findHuntingTarget() {
        return this.field_6660.method_37908().method_21726(class_1309.class, this.huntTargetConditions, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321(), this.getTargetSearchArea(this.method_6326()));
    }

    @NotNull
    private class_238 getTargetSearchArea(double targetDistance) {
        double yDist = 4.0;
        if (this.dino instanceof PrehistoricFlying || this.dino instanceof PrehistoricSwimming) {
            yDist = targetDistance;
        }
        return this.field_6660.method_5829().method_1009(targetDistance, yDist, targetDistance);
    }
}

