/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ToyBall;
import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;

public class WaterPlayGoal<T extends Prehistoric>
extends PlayGoal {
    private static final int ATTACK = 0;
    private static final int GRAB = 1;
    private static final int GRAB_DURATION = 55;
    private final T swimming;
    private int attackType = -1;
    private long grabStartTick = -1L;

    public WaterPlayGoal(T dino, double speedModifier) {
        super((Prehistoric)dino, speedModifier);
        this.swimming = dino;
    }

    @Override
    public boolean method_6266() {
        if (this.attackType == 1 && !((SwimmingAnimal)this.swimming).isDoingGrabAttack()) {
            return false;
        }
        return super.method_6266();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.attackType = -1;
        this.grabStartTick = -1L;
    }

    @Override
    protected ToyBase findPlayTarget() {
        if (this.dino.method_5799()) {
            return Util.getNearestEntity(ToyBall.class, (class_1308)this.dino, this.getTargetSearchArea(this.getFollowDistance()), class_1297::method_5799);
        }
        return Util.getNearestEntity(ToyBase.class, (class_1308)this.dino, this.getTargetSearchArea(this.getFollowDistance()), toyBase -> true);
    }

    @Override
    public void method_6268() {
        if (this.attackType != 1) {
            this.dino.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
            if (this.dino.method_5942().method_6357() && !Util.canReachPrey(this.dino, this.target)) {
                this.dino.method_5942().method_6335((class_1297)this.target, this.speedModifier);
            }
        }
        this.checkAndPerformAttack(this.target);
    }

    @Override
    protected void checkAndPerformAttack(ToyBase target) {
        long currentTime = this.dino.method_37908().method_8510();
        if (this.attackType == 1) {
            for (class_1297 passenger : this.swimming.method_5685()) {
                if (!(passenger instanceof ToyBase)) continue;
                ToyBase toy = (ToyBase)passenger;
                if (currentTime != this.grabStartTick + 55L) continue;
                ((SwimmingAnimal)this.swimming).stopGrabAttack(passenger);
                ((Prehistoric)this.swimming).moodSystem.setToyTarget(null);
                ((Prehistoric)this.swimming).moodSystem.useToy(toy.moodBonus);
            }
        } else if (this.attackType == 0) {
            if (this.attackDamageTick > 0L && currentTime >= this.attackDamageTick) {
                target.method_5643(this.dino.method_48923().method_48812((class_1309)this.dino), 0.0f);
                this.attackDamageTick = -1L;
                this.attackType = -1;
            }
        } else if (currentTime > this.attackEndTick + 20L && Util.canReachPrey(this.dino, target)) {
            boolean tooBig = Util.isEntityLargerThan(target, 2.0f * ((Prehistoric)this.swimming).method_17825() / ((Prehistoric)this.swimming).data().maxScale());
            if (((Prehistoric)this.swimming).aiAttackType() != PrehistoricEntityInfoAI.Attacking.GRAB || tooBig || this.swimming.method_6051().method_43048(5) > 0) {
                this.attackType = 0;
                ServerAnimationInfo animationInfo = this.dino.startAttack();
                this.attackDamageTick = (long)((double)currentTime + animationInfo.actionDelay);
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
            } else {
                this.attackType = 1;
                ((SwimmingAnimal)this.swimming).startGrabAttack(target);
                this.attackEndTick = 1L;
                this.grabStartTick = currentTime;
            }
        }
    }
}

