/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.util.Version;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4459;
import net.minecraft.class_5;
import net.minecraft.class_5949;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrehistoricPathFinder
extends class_13 {
    private static final float FUDGING = 1.5f;
    private static final boolean DEBUG = Version.debugEnabled();
    private final class_9[] neighbors = new class_9[32];
    private final int maxVisitedNodes;
    private final class_8 nodeEvaluator;
    private final class_5 openSet = new class_5();
    protected final List<class_9> closedSet = new ArrayList<class_9>();
    protected final class_1308 mob;

    public PrehistoricPathFinder(class_8 nodeEvaluator, int maxVisitedNodes, class_1308 mob) {
        super(nodeEvaluator, maxVisitedNodes);
        this.nodeEvaluator = nodeEvaluator;
        this.maxVisitedNodes = maxVisitedNodes;
        this.mob = mob;
    }

    @Nullable
    public class_11 method_52(class_1950 region, class_1308 mob, Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.method_5();
        this.closedSet.clear();
        this.nodeEvaluator.method_12(region, mob);
        class_9 node = this.nodeEvaluator.method_21();
        Map<class_4459, class_2338> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.method_16((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), Function.identity()));
        PatchedPath path = this.findPatchedPath(region.method_37233(), node, map, maxRange, accuracy, searchDepthMultiplier);
        if (DEBUG && path != null) {
            path.method_35500(this.openSet.method_35493(), (class_9[])this.closedSet.toArray(class_9[]::new), map.keySet());
        }
        this.nodeEvaluator.method_19();
        return path;
    }

    protected PatchedPath findPatchedPath(class_3695 profiler, class_9 start, Map<class_4459, class_2338> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        profiler.method_15396("find_path");
        profiler.method_37167(class_5949.field_33876);
        Set<class_4459> set = targetPos.keySet();
        start.field_36 = 0.0f;
        start.field_47 = start.field_34 = this.getBestH(start, set, false);
        this.openSet.method_5();
        this.openSet.method_2(start);
        int i = 1;
        int maxNodes = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.method_8() && i < maxNodes) {
            class_9 node = this.openSet.method_6();
            this.closedSet.add(node);
            node.field_42 = true;
            for (class_4459 target2 : set) {
                if (node.method_21653((class_9)target2) > (float)accuracy) continue;
                target2.method_21665();
                return this.reconstructPath(target2, targetPos.get(target2), true);
            }
            if (node.method_31(start) >= maxRange) continue;
            int neighborCount = this.nodeEvaluator.method_18(this.neighbors, node);
            for (int l = 0; l < neighborCount; ++l) {
                class_9 neighbor = this.neighbors[l];
                float f = node.method_31(neighbor);
                neighbor.field_46 = node.field_46 + f;
                float g = node.field_36 + f + neighbor.field_43;
                if (neighbor.field_46 >= maxRange || neighbor.method_27() && g >= neighbor.field_36) continue;
                neighbor.field_35 = node;
                neighbor.field_36 = g;
                neighbor.field_34 = this.getBestH(neighbor, set, true);
                if (neighbor.method_27()) {
                    this.openSet.method_3(neighbor, neighbor.field_36 + neighbor.field_34);
                    continue;
                }
                neighbor.field_47 = neighbor.field_36 + neighbor.field_34;
                this.openSet.method_2(neighbor);
            }
            ++i;
        }
        Optional<PatchedPath> path = set.stream().map(target -> this.reconstructPath((class_4459)target, (class_2338)targetPos.get(target), false)).min(Comparator.comparingDouble(class_11::method_21656).thenComparingInt(class_11::method_38));
        profiler.method_15407();
        return path.orElse(null);
    }

    protected float getBestH(class_9 node, Set<class_4459> targets, boolean fudge) {
        float f = Float.MAX_VALUE;
        for (class_4459 target : targets) {
            float g = node.method_31((class_9)target);
            target.method_21662(g, node);
            f = Math.min(g, f);
        }
        return f * (fudge ? 1.5f : 1.0f);
    }

    private PatchedPath reconstructPath(class_4459 target, class_2338 targetPos, boolean reachesTarget) {
        class_9 end = target.method_21664();
        ArrayList list = Lists.newArrayList();
        class_9 node = end;
        list.add(0, node);
        while (node.field_35 != null) {
            node = node.field_35;
            list.add(0, node);
        }
        if (this.mob.method_17681() < 1.0f && reachesTarget) {
            list.add(target);
        }
        return new PatchedPath(list, targetPos, reachesTarget);
    }

    public static class PatchedPath
    extends class_11 {
        public PatchedPath(List<class_9> list, class_2338 blockPos, boolean bl) {
            super(list, blockPos, bl);
        }

        @NotNull
        public class_243 method_47(class_1297 entity, int index) {
            class_9 point = this.method_40(index);
            double d0 = (double)point.field_40 + (double)class_3532.method_15375((float)(entity.method_17681() + 1.0f)) * 0.5;
            double d1 = point.field_39;
            double d2 = (double)point.field_38 + (double)class_3532.method_15375((float)(entity.method_17681() + 1.0f)) * 0.5;
            return new class_243(d0, d1, d2);
        }
    }
}

