/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_5819;

public class MeganeuraAttachSystem
extends AISystem {
    private static final int MAX_TRY_TICKS = 300;
    private static final int MAX_ATTACH_TICKS = 1200;
    private final Meganeura mob;
    private final class_2945 entityData;
    private class_2338 targetBlockPos;
    private class_243 targetLocation;
    private class_2350 targetFace;
    private int attachCooldown = 150;
    private int attachTicks = 0;
    private int tryTicks = 0;

    public MeganeuraAttachSystem(Meganeura mob) {
        super(mob);
        this.mob = mob;
        this.entityData = mob.method_5841();
    }

    @Override
    public void serverTick() {
        double dist;
        if (this.tryTicks > 0) {
            ++this.tryTicks;
        }
        if (this.mob.method_6109()) {
            this.attachCooldown = 150;
            return;
        }
        if (this.attachCooldown > 0) {
            --this.attachCooldown;
        }
        if (!this.isAttached() && this.targetLocation != null && (dist = this.targetLocation.method_1022(this.mob.method_19538())) < 1.0) {
            this.mob.method_5962().method_6239(this.targetLocation.field_1352, this.targetLocation.field_1351, this.targetLocation.field_1350, 0.9);
            this.mob.method_5942().method_6340();
            if (!this.attachStarted()) {
                this.approachAttachPos();
            }
            if (dist < 0.2) {
                this.startAttaching();
            }
        }
        if (this.isAttached()) {
            ++this.attachTicks;
            this.mob.method_18799(class_243.field_1353);
        }
        if (this.attachStarted() && this.targetBlockPos != null) {
            this.mob.method_36456(0.0f);
            this.mob.method_36457(0.0f);
            this.mob.field_6283 = 0.0f;
            this.mob.field_6241 = 0.0f;
            if (!this.mob.method_37908().method_8320(this.targetBlockPos).method_26206((class_1922)this.mob.method_37908(), this.targetBlockPos, this.getAttachmentFace())) {
                this.stopAttaching();
            }
            if (this.isAttached()) {
                if (!this.mob.method_6113() && this.mob.getCurrentOrder() != OrderType.STAY && (this.attachTicks > 1200 && this.mob.method_6051().method_43048(123) == 0 || this.mob.method_5968() != null)) {
                    this.stopAttaching(1000 + this.mob.method_6051().method_43048(1500));
                }
                if (this.mob.getCurrentOrder() == OrderType.FOLLOW) {
                    this.stopAttaching();
                }
            }
        }
        if (this.tryTicks > 300) {
            this.stopAttaching();
        }
    }

    @Override
    public void clientTick() {
        if (this.attachStarted()) {
            this.mob.method_36456(0.0f);
            this.mob.method_36457(0.0f);
            this.mob.field_6283 = 0.0f;
            this.mob.field_6241 = 0.0f;
        }
    }

    public void approachAttachPos() {
        this.attachCooldown = 150;
        this.tryTicks = 260;
        this.setAttachmentPos(this.targetLocation);
        this.setAttachmentFace(this.targetFace);
    }

    public void setAttachTarget(class_2338 attachBlockPos, class_2350 attachFace) {
        double rad = this.mob.method_17681() / 2.0f;
        class_243 pos = class_243.method_24953((class_2382)attachBlockPos).method_1031((0.5 + rad) * (double)attachFace.method_10148(), 0.0, (0.5 + rad) * (double)attachFace.method_10165());
        class_5819 random = this.mob.method_6051();
        double randomOffset = (random.method_43058() * 2.0 - 1.0) * (0.5 - rad - (double)1.0E-5f);
        pos = pos.method_1031((double)attachFace.method_10170().method_10148() * randomOffset, (double)((random.method_43057() * 2.0f - 1.0f) * 0.3f), (double)attachFace.method_10170().method_10165() * randomOffset);
        this.setAttachTarget(attachBlockPos, attachFace, pos);
    }

    public void setAttachTarget(class_2338 attachBlockPos, class_2350 attachFace, class_243 attachLocation) {
        this.targetBlockPos = attachBlockPos;
        this.targetFace = attachFace;
        this.targetLocation = attachLocation;
        this.tryTicks = 0;
    }

    public void startAttaching() {
        this.attachCooldown = 150;
        this.attachTicks = 0;
        this.tryTicks = 0;
        this.setAttached(true);
        this.mob.method_5814(this.targetLocation.field_1352, this.mob.method_23318(), this.targetLocation.field_1350);
        this.mob.method_18799(class_243.field_1353);
    }

    public void stopAttaching(int attachCooldown) {
        this.targetBlockPos = null;
        this.targetFace = null;
        this.targetLocation = null;
        this.tryTicks = 0;
        this.attachCooldown = attachCooldown;
        this.setAttached(false);
        this.setAttachmentPos(class_243.field_1353);
        this.setAttachmentFace(class_2350.field_11036);
    }

    public void stopAttaching() {
        this.stopAttaching(150);
    }

    public boolean isAttached() {
        return (Boolean)this.entityData.method_12789(Meganeura.ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.entityData.method_12778(Meganeura.ATTACHED, (Object)attached);
    }

    public int getAttachCooldown() {
        return this.attachCooldown;
    }

    public void setAttachCooldown(int attachCooldown) {
        this.attachCooldown = attachCooldown;
    }

    public boolean attachStarted() {
        return this.getAttachmentFace() != class_2350.field_11036;
    }

    public class_243 getAttachmentPos() {
        return new class_243((double)((Float)this.entityData.method_12789(Meganeura.ATTACHED_X)).floatValue(), (double)((Float)this.entityData.method_12789(Meganeura.ATTACHED_Y)).floatValue(), (double)((Float)this.entityData.method_12789(Meganeura.ATTACHED_Z)).floatValue());
    }

    private void setAttachmentPos(class_243 location) {
        this.entityData.method_12778(Meganeura.ATTACHED_X, (Object)Float.valueOf((float)location.field_1352));
        this.entityData.method_12778(Meganeura.ATTACHED_Y, (Object)Float.valueOf((float)location.field_1351));
        this.entityData.method_12778(Meganeura.ATTACHED_Z, (Object)Float.valueOf((float)location.field_1350));
    }

    public class_2350 getAttachmentFace() {
        return (class_2350)this.entityData.method_12789(Meganeura.ATTACHED_FACE);
    }

    private void setAttachmentFace(class_2350 direction) {
        this.entityData.method_12778(Meganeura.ATTACHED_FACE, (Object)direction);
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        tag.method_10569("AttachTicks", this.attachTicks);
        tag.method_10569("AttachCooldown", this.attachCooldown);
        tag.method_10569("AttachFace", this.getAttachmentFace().method_10146());
        tag.method_10556("Attached", this.isAttached());
        class_243 attachPos = this.getAttachmentPos();
        tag.method_10549("AttachX", attachPos.field_1352);
        tag.method_10549("AttachY", attachPos.field_1351);
        tag.method_10549("AttachZ", attachPos.field_1350);
        if (this.targetBlockPos != null) {
            tag.method_10566("AttachPos", (class_2520)class_2512.method_10692((class_2338)this.targetBlockPos));
        }
    }

    @Override
    public void load(class_2487 tag) {
        this.attachTicks = tag.method_10550("AttachTicks");
        this.attachCooldown = tag.method_10550("AttachCooldown");
        this.setAttachmentFace(class_2350.method_10143((int)tag.method_10550("AttachFace")));
        this.setAttached(tag.method_10577("Attached"));
        this.setAttachmentPos(new class_243(tag.method_10574("AttachX"), tag.method_10574("AttachY"), tag.method_10574("AttachZ")));
        if (tag.method_10545("AttachPos")) {
            this.targetBlockPos = class_2512.method_10691((class_2487)tag.method_10562("AttachPos"));
        }
    }
}

