/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.fabric;

import com.github.teamfossilsarcheology.fossil.util.Version;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FossilMixinPluginImpl
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!FossilMixinPluginImpl.isModLoaded("fossil") || mixinClassName.contains("Debug") && !Version.debugEnabled()) {
            return false;
        }
        if (FossilMixinPluginImpl.isModLoaded("midnightlib") && mixinClassName.contains("MidnightConfig")) {
            int compare = FossilMixinPluginImpl.compareSemanticVersions(FossilMixinPluginImpl.getModVersion("midnightlib"), "1.9.0");
            if (mixinClassName.contains("Modern")) {
                return compare >= 0;
            }
            return compare < 0;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static int compareSemanticVersions(String version1, String version2) {
        List<Integer> version1Components = Arrays.stream(version1.split("\\.")).map(Integer::parseInt).toList();
        List<Integer> version2Components = Arrays.stream(version2.split("\\.")).map(Integer::parseInt).toList();
        int maxLength = Math.max(version1Components.size(), version2Components.size());
        for (int i = 0; i < maxLength; ++i) {
            int v2Component;
            int v1Component = i < version1Components.size() ? version1Components.get(i) : 0;
            int n = v2Component = i < version2Components.size() ? version2Components.get(i) : 0;
            if (v1Component > v2Component) {
                return 1;
            }
            if (v1Component >= v2Component) continue;
            return -1;
        }
        return 0;
    }

    public static boolean isModLoaded(String mod) {
        return FabricLoader.getInstance().getModContainer(mod).isPresent();
    }

    private static String getModVersion(String mod) {
        Optional modContainer = FabricLoader.getInstance().getModContainer(mod);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString();
        }
        return "";
    }
}

