/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;

public abstract class MultiOutputAndSlotsRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    protected final class_1856 input;
    private final NavigableMap<Double, class_1799> weightedOutputs;

    protected MultiOutputAndSlotsRecipe(class_2960 resourceLocation, class_1856 input, NavigableMap<Double, class_1799> weightedOutputs) {
        this.id = resourceLocation;
        this.input = input;
        this.weightedOutputs = weightedOutputs;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        class_2371 nonNullList = class_2371.method_10211();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public NavigableMap<Double, class_1799> getWeightedOutputs() {
        return this.weightedOutputs;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        for (int i = 0; i < container.method_5439(); ++i) {
            if (!this.matches(container, i)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(class_1263 container, int slot) {
        class_1799 itemStack = container.method_5438(slot);
        if (itemStack.method_7960()) {
            return false;
        }
        return this.input.method_8093(itemStack);
    }

    @NotNull
    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        if (container instanceof class_2586) {
            class_2586 blockEntity = (class_2586)container;
            return this.weightedOutputs.higherEntry(blockEntity.method_10997().field_9229.method_43058() * (Double)this.weightedOutputs.lastKey()).getValue().method_7972();
        }
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @NotNull
    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8118() {
        return true;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    public static class Serializer<T extends MultiOutputAndSlotsRecipe>
    implements class_1865<T> {
        protected final Constructor<T> constructor;

        protected Serializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        private static NavigableMap<Double, class_1799> weightedItemsFromJson(JsonArray outputsArray) {
            TreeMap<Double, class_1799> items = new TreeMap<Double, class_1799>();
            double total = 0.0;
            for (int i = 0; i < outputsArray.size(); ++i) {
                JsonObject object = outputsArray.get(i).getAsJsonObject();
                class_1799 item = class_1869.method_35228((JsonObject)object);
                if (item.method_7960()) continue;
                items.put(total += class_3518.method_34927((JsonObject)object, (String)"weight"), item);
            }
            return items;
        }

        @NotNull
        public T fromJson(class_2960 recipeId, JsonObject json) {
            JsonArray jsonelement = class_3518.method_15264((JsonObject)json, (String)"input") ? class_3518.method_15261((JsonObject)json, (String)"input") : class_3518.method_15296((JsonObject)json, (String)"input");
            class_1856 input = class_1856.method_52177((JsonElement)jsonelement);
            NavigableMap<Double, class_1799> outputs = Serializer.weightedItemsFromJson(class_3518.method_15261((JsonObject)json, (String)"outputs"));
            return (T)((MultiOutputAndSlotsRecipe)this.constructor.construct(recipeId, input, outputs));
        }

        @NotNull
        public T fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            TreeMap<Double, class_1799> outputs = new TreeMap<Double, class_1799>();
            int outputSize = buffer.method_10816();
            for (int i = 0; i < outputSize; ++i) {
                outputs.put(buffer.readDouble(), buffer.method_10819());
            }
            return (T)((MultiOutputAndSlotsRecipe)this.constructor.construct(recipeId, input, outputs));
        }

        public void toNetwork(class_2540 buffer, MultiOutputAndSlotsRecipe recipe) {
            recipe.input.method_8088(buffer);
            buffer.method_10804(recipe.weightedOutputs.size());
            for (Map.Entry output : recipe.weightedOutputs.entrySet()) {
                buffer.writeDouble(((Double)output.getKey()).doubleValue());
                buffer.method_10793((class_1799)output.getValue());
            }
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(class_2960 var1, class_1856 var2, NavigableMap<Double, class_1799> var3);
        }
    }
}

