/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FernsBlock
extends BushBlock
implements BonemealableBlock {
    public static final int LOWER_MAX_AGE = 4;
    public static final int UPPER_MAX_AGE = 6;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)6);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)};

    public FernsBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static boolean isUnderTree(BlockGetter level, BlockPos pos) {
        for (int i = 0; i <= 32; ++i) {
            if (!level.m_8055_(pos.m_6630_(i)).m_204336_(BlockTags.f_13035_)) continue;
            return true;
        }
        return false;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return super.m_6266_(state, level, pos) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_) && FernsBlock.isUnderTree(level, pos);
    }

    public boolean isUpper(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > 4;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isUpper(state)) {
            BlockState blockState = level.m_8055_(pos.m_7495_());
            return blockState.m_60713_((Block)this) && !this.isUpper(blockState);
        }
        return super.m_6266_(level.m_8055_(pos.m_7495_()), (BlockGetter)level, pos.m_7495_()) && FernsBlock.isUnderTree((BlockGetter)level, pos.m_7494_());
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        this.tryAgeUp(state, level, pos, random);
    }

    private void tryAgeUp(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (!this.isUpper(state) && random.m_188503_(FossilConfig.getInt("fernTickRate")) == 0) {
            int newAge = Math.min(age + 1, 4);
            if (age == 3) {
                if (!level.m_46859_(pos.m_7494_())) {
                    --newAge;
                } else {
                    level.m_46597_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(5)));
                }
            } else if (age == 4) {
                BlockState upperState = level.m_8055_(pos.m_7494_());
                if (upperState.m_60713_((Block)this)) {
                    level.m_46597_(pos.m_7494_(), (BlockState)upperState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(6)));
                } else {
                    newAge = 3;
                }
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)));
            this.spread(state, level, pos, newAge);
        }
    }

    private void spread(BlockState state, ServerLevel level, BlockPos pos, int age) {
        if (age >= 4) {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0 || !this.m_6266_(level.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, x, y - 1, z)), (BlockGetter)level, (BlockPos)mutable)) continue;
                        level.m_46597_((BlockPos)mutable.m_122173_(Direction.UP), (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
                    }
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.tryAgeUp(state, level, pos, random);
    }
}

