/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CultureVatBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.EnergyContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.inventory.CultureVatMenu;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CultureVatBlockEntity
extends EnergyContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return CultureVatBlockEntity.this.litTime;
                }
                case 1: {
                    return CultureVatBlockEntity.this.litDuration;
                }
                case 2: {
                    return CultureVatBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return CultureVatBlockEntity.this.energyStorage.getEnergy();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CultureVatBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CultureVatBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    CultureVatBlockEntity.this.cookingProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private ItemStack fuel = ItemStack.f_41583_;

    public CultureVatBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CULTURE_VAT.get(), blockPos, blockState);
    }

    public static int getItemFuelTime(ItemStack stack) {
        return ModRecipes.getCultureVatFuelValue((ItemLike)stack.m_41720_());
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag listTag = tag.m_128437_("FuelItem", 10);
        if (!listTag.isEmpty()) {
            this.fuel = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(0));
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag listTag = new ListTag();
        listTag.add((Object)this.fuel.m_41739_(new CompoundTag()));
        tag.m_128365_("FuelItem", (Tag)listTag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CultureVatBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= 0) {
            if (this.cookingProgress > 0) {
                this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)CultureVatMenu.CULTIVATION_DURATION);
            }
            return;
        }
        int prevCookingProgress = this.cookingProgress;
        boolean wasFueled = this.litTime > 0;
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.litTime > 0) {
            --this.litTime;
        }
        if (this.canProcess() && (this.litTime == 0 || this.litTime > 0 && !this.canProcess(this.fuel))) {
            ItemStack fuelStack = (ItemStack)this.items.get(1);
            this.litDuration = this.litTime = CultureVatBlockEntity.getItemFuelTime(fuelStack);
            this.fuel = fuelStack.m_41777_();
            if (this.litTime > 0) {
                dirty = true;
                fuelStack.m_41774_(1);
                if (fuelStack.m_41619_() && fuelStack.m_41720_().m_41470_()) {
                    this.items.set(1, (Object)new ItemStack((ItemLike)fuelStack.m_41720_().m_41469_()));
                }
            }
        }
        if (this.litTime > 0 && this.canProcess(this.fuel)) {
            ++this.cookingProgress;
            if (this.cookingProgress >= CultureVatMenu.CULTIVATION_DURATION) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
        }
        if (prevCookingProgress != this.cookingProgress && FossilConfig.isEnabled("machinesRequireEnergy")) {
            this.energyStorage.extractEnergy(FossilConfig.getInt("machineEnergyUsage"));
        }
        if (this.litTime == 0 && this.cookingProgress > 0 || this.litTime > 0 && this.cookingProgress > 0 && !this.canProcess(this.fuel)) {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)CultureVatMenu.CULTIVATION_DURATION);
        }
        if (wasFueled != this.litTime > 0) {
            dirty = true;
            state = (BlockState)state.m_61124_((Property)CultureVatBlock.ACTIVE, (Comparable)Boolean.valueOf(this.litTime > 0));
            level.m_7731_(pos, state, 3);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (BlockState)state.m_61124_(CultureVatBlock.EMBRYO, (Comparable)((Object)this.getDNAType()));
            level.m_7731_(pos, state, 3);
        }
        if (dirty) {
            CultureVatBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (this.cookingProgress == 3001 && level.m_213780_().m_188503_(100) < FossilConfig.getInt("cultureVatFailChance")) {
            ((CultureVatBlock)((Object)ModBlocks.CULTURE_VAT.get())).onFailedCultivation(level, pos);
        }
    }

    public CultureVatBlock.EmbryoType getDNAType() {
        ItemStack input = (ItemStack)this.items.get(0);
        if (input.m_41619_()) {
            return CultureVatBlock.EmbryoType.NONE;
        }
        if (input.m_204117_(ModItemTags.FOSSIL_SAPLINGS)) {
            return CultureVatBlock.EmbryoType.TREE;
        }
        if (input.m_204117_(ModItemTags.DNA_PLANTS)) {
            return CultureVatBlock.EmbryoType.PLANT;
        }
        if (input.m_204117_(ModItemTags.DNA_LIMBLESS)) {
            return CultureVatBlock.EmbryoType.LIMBLESS;
        }
        if (input.m_204117_(ModItemTags.DNA_INSECTS)) {
            return CultureVatBlock.EmbryoType.INSECT;
        }
        return CultureVatBlock.EmbryoType.GENERIC;
    }

    private boolean isValidInput(ItemStack inputStack, ItemStack fuelStack) {
        CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(inputStack, fuelStack), this.f_58857_);
        if (recipe != null) {
            ItemStack output = (ItemStack)this.items.get(2);
            return output.m_41619_() || output.m_41656_(recipe.m_8043_(this.f_58857_.m_9598_()));
        }
        return false;
    }

    protected boolean canProcess(ItemStack fuelStack) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= FossilConfig.getInt("machineEnergyUsage")) {
            return false;
        }
        ItemStack inputStack = (ItemStack)this.items.get(0);
        if (!inputStack.m_41619_() && !fuelStack.m_41619_()) {
            return this.isValidInput(inputStack, fuelStack);
        }
        return false;
    }

    @Override
    protected boolean canProcess() {
        return this.canProcess((ItemStack)this.items.get(1));
    }

    @Override
    protected void createItem() {
        if (this.canProcess(this.fuel)) {
            ItemStack inputStack = (ItemStack)this.items.get(0);
            CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(inputStack, this.fuel), this.f_58857_);
            ItemStack result = recipe.m_8043_(this.f_58857_.m_9598_());
            ItemStack output = (ItemStack)this.items.get(2);
            if (output.m_41619_()) {
                this.items.set(2, (Object)result);
            } else if (output.m_41656_(result)) {
                output.m_41769_(result.m_41613_());
            }
            ((ItemStack)this.items.get(0)).m_41774_(1);
        }
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.fossil.culture_vat");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new CultureVatMenu(containerId, inventory, this, this.dataAccess);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack current = (ItemStack)this.items.get(slot);
        boolean sameItems = !stack.m_41619_() && stack.m_41656_(current) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)current);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !sameItems) {
            this.cookingProgress = 0;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CultureVatBlock.EMBRYO, (Comparable)((Object)this.getDNAType())), 3);
            this.m_6596_();
        }
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index == 1) {
            return ModRecipes.isCultureVatFuel((ItemLike)stack.m_41720_());
        }
        return ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(true, stack), this.f_58857_) != null;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : (side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction != Direction.UP && index == 2;
    }
}

