/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class EggTab
extends DebugTab<DinosaurEgg> {
    private int hatchingTime;
    private double scaleOverride;

    protected EggTab(DebugScreen debugScreen, DinosaurEgg entity) {
        super(debugScreen, entity);
        this.hatchingTime = entity.getHatchingTime();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yPos = 0;
        final EntityDataLoader.Data data = EntityDataLoader.INSTANCE.getData(((DinosaurEgg)this.entity).getPrehistoricEntityInfo().resourceName);
        DebugSlider hatchingTimeSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Hatching time in ticks: "), (Component)Component.m_237113_((String)""), 0.0, ((DinosaurEgg)this.entity).getTotalHatchingTime(), ((DinosaurEgg)this.entity).getHatchingTime(), 5.0, 0, true){

            @Override
            protected void m_5697_() {
                EggTab.this.hatchingTime = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        DebugSlider scaleSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Scale: "), (Component)Component.m_237113_((String)""), 0.05, Math.max(2.0f, data.eggScale()), data.eggScale(), 0.05, 2, true){

            @Override
            protected void m_5697_() {
                EggTab.this.scaleOverride = this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize);
                ((DinosaurEgg)EggTab.this.entity).setScaleOverride((float)EggTab.this.scaleOverride);
            }

            public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_86412_(poseStack, mouseX, mouseY, partialTick);
                int j = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
                String currentEggScale = String.valueOf(data.eggScale());
                int currentScaleX = (int)(((double)data.eggScale() - this.minValue) / (this.maxValue - this.minValue) * (double)(this.f_93618_ - EggTab.this.minecraft.f_91062_.m_92895_(currentEggScale)));
                2.m_93236_((PoseStack)poseStack, (Font)EggTab.this.minecraft.f_91062_, (String)currentEggScale, (int)(this.m_252754_() + currentScaleX), (int)(this.m_252907_() - 8), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
            }
        };
        this.addWidget(hatchingTimeSlider);
        this.addWidget(scaleSlider);
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Set Info"), button -> {
            ((DinosaurEgg)this.entity).setScaleOverride(-1.0f);
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((DinosaurEgg)this.entity).m_19879_(), "", this.hatchingTime, 0, 0, 0, 0, 0));
        }).m_252987_(20, yPos += 30, 150, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Set the info above on the server"))).m_253136_());
    }
}

