/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.C2STameMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Arrays;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class InfoTab
extends DebugTab<Prehistoric> {
    private final int maxAgeInTicks;
    private Gender gender;
    private int ageInTicks;
    private double scaleOverride;
    private int matingCooldown;
    private int playingCooldown;
    private int climbingCooldown;
    private int hunger;
    private int mood;
    private DebugSlider ageSlider;
    private DebugSlider scaleSlider;
    private DebugSlider matingSlider;
    private DebugSlider playingSlider;
    private DebugSlider climbingSlider;
    private DebugSlider hungerSlider;
    private DebugSlider moodSlider;

    protected InfoTab(DebugScreen debugScreen, Prehistoric prehistoric) {
        super(debugScreen, prehistoric);
        this.maxAgeInTicks = prehistoric.data().adultAgeInTicks();
        this.gender = prehistoric.getGender();
        this.ageInTicks = prehistoric.m_146764_();
        this.matingCooldown = prehistoric.getMatingCooldown();
        this.playingCooldown = prehistoric.moodSystem.getPlayingCooldown();
        this.climbingCooldown = prehistoric.getClimbingCooldown();
        this.hunger = prehistoric.getHunger();
        this.mood = prehistoric.moodSystem.getMood();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yPos = 0;
        this.ageSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Age in ticks: "), (Component)Component.m_237113_((String)""), 0.0, this.maxAgeInTicks, this.ageInTicks, 12000.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.ageInTicks = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }

            public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_86412_(poseStack, mouseX, mouseY, partialTick);
                int j = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
                EntityDataLoader.Data data = ((Prehistoric)InfoTab.this.entity).data();
                DecimalFormat format = new DecimalFormat("0.00");
                float step = (data.maxScale() - data.minScale()) / (float)(data.adultAgeInTicks() + 1);
                String min = format.format((double)data.minScale() + (double)step * this.minValue);
                String max = format.format((double)data.minScale() + (double)step * this.maxValue);
                1.m_93236_((PoseStack)poseStack, (Font)InfoTab.this.minecraft.f_91062_, (String)min, (int)this.m_252754_(), (int)(this.m_252907_() - 8), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
                1.m_93236_((PoseStack)poseStack, (Font)InfoTab.this.minecraft.f_91062_, (String)max, (int)(this.m_252754_() + this.f_93618_ - InfoTab.this.minecraft.f_91062_.m_92895_(max)), (int)(this.m_252907_() - 8), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
            }
        };
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Scale 1"), button -> {
            EntityDataLoader.Data data = ((Prehistoric)this.entity).data();
            this.ageInTicks = (int)((1.0f - data.minScale()) * (float)(data.adultAgeInTicks() + 1) / (data.maxScale() - data.minScale()));
            this.ageSlider.setValue(this.ageInTicks);
        }).m_252987_(275, 30, 150, 20).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Tame"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2STameMessage(((Prehistoric)this.entity).m_19879_()))).m_252987_(275, 55, 50, 20).m_253136_());
        this.scaleSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Scale: "), (Component)Component.m_237113_((String)""), 0.1, Math.max(2.5, (double)((Prehistoric)this.entity).data().maxScale()), ((Prehistoric)this.entity).m_6134_(), 0.05, 2, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.scaleOverride = this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize);
                ((Prehistoric)InfoTab.this.entity).setScaleOverride((float)InfoTab.this.scaleOverride);
            }

            public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_86412_(poseStack, mouseX, mouseY, partialTick);
                int j = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
                EntityDataLoader.Data data = ((Prehistoric)InfoTab.this.entity).data();
                String min = String.valueOf(0);
                int minX = (int)(((double)data.minScale() - this.minValue) / (this.maxValue - this.minValue) * (double)this.f_93618_);
                String max = String.valueOf(((Prehistoric)InfoTab.this.entity).data().adultAgeDays());
                int maxX = (int)(((double)data.maxScale() - this.minValue) / (this.maxValue - this.minValue) * (double)(this.f_93618_ - InfoTab.this.minecraft.f_91062_.m_92895_(max)));
                2.m_93236_((PoseStack)poseStack, (Font)InfoTab.this.minecraft.f_91062_, (String)min, (int)(this.m_252754_() + minX), (int)(this.m_252907_() - 8), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
                2.m_93236_((PoseStack)poseStack, (Font)InfoTab.this.minecraft.f_91062_, (String)max, (int)(this.m_252754_() + maxX), (int)(this.m_252907_() - 8), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
            }
        };
        this.matingSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Seconds till mating: "), (Component)Component.m_237113_((String)""), 0.0, 900.0, (float)this.matingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.matingCooldown = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.playingSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Seconds till playing: "), (Component)Component.m_237113_((String)""), 0.0, 120.0, (float)this.playingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.playingCooldown = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.climbingSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Seconds till climbing: "), (Component)Component.m_237113_((String)""), 0.0, 120.0, (float)this.climbingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.climbingCooldown = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.hungerSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Hunger: "), (Component)Component.m_237113_((String)""), 0.0, ((Prehistoric)this.entity).getMaxHunger(), this.hunger, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.hunger = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.moodSlider = new DebugSlider(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Mood: "), (Component)Component.m_237113_((String)""), -100.0, 100.0, this.mood, 1.0, 0, true){

            @Override
            protected void m_5697_() {
                InfoTab.this.mood = (int)(this.stepSize * (double)Math.round(Mth.m_14139_((double)this.f_93577_, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.addWidget(this.ageSlider);
        this.addWidget(this.scaleSlider);
        this.addWidget(this.matingSlider);
        this.addWidget(this.playingSlider);
        this.addWidget(this.climbingSlider);
        this.addWidget(this.hungerSlider);
        this.addWidget(this.moodSlider);
        this.addWidget(CycleButton.m_168894_(Gender::getName).m_232502_(Arrays.stream(Gender.values()).toList()).m_168948_((Object)this.gender).m_168936_(20, yPos += 30, 150, 20, (Component)Component.m_237113_((String)"Gender"), (cycleButton, gender) -> {
            this.gender = gender;
        }));
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"Set Info"), button -> {
            ((Prehistoric)this.entity).setGender(this.gender);
            ((Prehistoric)this.entity).setScaleOverride(-1.0f);
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((Prehistoric)this.entity).m_19879_(), this.gender.name(), this.ageInTicks, this.matingCooldown, this.playingCooldown, this.climbingCooldown, this.hunger, this.mood));
        }).m_252987_(20, yPos += 30, 150, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Set the info above on the server"))).m_253136_());
    }

    @Override
    protected void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        int yPos = 5;
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Age: " + ((Prehistoric)this.entity).m_146764_())), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Scale: " + ((Prehistoric)this.entity).m_6134_())), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Mate: " + ((Prehistoric)this.entity).getMatingCooldown() / 20)), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Play: " + ((Prehistoric)this.entity).moodSystem.getPlayingCooldown() / 20)), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Climb: " + ((Prehistoric)this.entity).getClimbingCooldown() / 20)), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Hunger: " + ((Prehistoric)this.entity).getHunger())), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Mood: " + ((Prehistoric)this.entity).moodSystem.getMood())), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.m_93243_((PoseStack)poseStack, (Font)this.minecraft.f_91062_, (Component)Component.m_237113_((String)("Gender: " + ((Prehistoric)this.entity).getGender().name())), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
    }
}

