/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.filters;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FilterTab {
    private static final ResourceLocation FILTER_TEXTURE = FossilMod.location("textures/gui/filters.png");
    private final List<FilterButton> buttons = new ArrayList<FilterButton>();

    public FilterTab(Screen screen, List<Filter> filters) {
        int leftPos = (screen.f_96543_ - 195) / 2;
        int rightPos = leftPos + 191;
        int topPos = (screen.f_96544_ - 136) / 2;
        int x = leftPos - 28;
        int y = topPos + 6;
        for (int i = 0; i < filters.size(); ++i) {
            this.buttons.add(new FilterButton(screen, x, y, i <= 3, filters.get(i), button -> this.enableButton((FilterButton)button)));
            y += 30;
            if (i != 3) continue;
            x = rightPos;
            y = topPos + 6;
        }
    }

    public static FilterTab build(Screen screen, List<Filter> filters, ScreenAccess access) {
        FilterTab tab = new FilterTab(screen, filters);
        tab.buttons.forEach(arg_0 -> ((ScreenAccess)access).addWidget(arg_0));
        return tab;
    }

    public List<Item> getItems() {
        Optional optional;
        List<Item> list = new ArrayList<Item>();
        Optional<FilterButton> enabledButton = this.buttons.stream().filter(button -> button.filter.enabled).findFirst();
        if (enabledButton.isPresent() && (optional = BuiltInRegistries.f_257033_.m_203431_(enabledButton.get().filter.tag)).isPresent()) {
            list = ((HolderSet.Named)optional.get()).m_203614_().map(Holder::m_203334_).toList();
        }
        return list;
    }

    public Optional<TagKey<Item>> getTag() {
        Optional<FilterButton> enabledButton = this.buttons.stream().filter(button -> button.filter.enabled).findFirst();
        return enabledButton.map(filterButton -> filterButton.filter.tag);
    }

    public void renderButtons(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.m_86412_(poseStack, mouseX, mouseY, partialTicks));
    }

    private void enableButton(FilterButton button) {
        if (button.filter.enabled) {
            button.filter.enabled = false;
        } else {
            for (FilterButton filterButton : this.buttons) {
                filterButton.filter.enabled = false;
            }
            button.filter.enabled = true;
        }
    }

    public void enableButtons() {
        this.buttons.forEach(FilterButton::setActive);
    }

    public void disableButtons() {
        this.buttons.forEach(FilterButton::setInActive);
    }

    public static class FilterButton
    extends Button {
        private final Screen screen;
        private final Filter filter;
        private final boolean left;

        public FilterButton(Screen screen, int i, int j, boolean left, Filter filter, Button.OnPress onPress) {
            super(i, j, 32, 28, (Component)Component.m_237119_(), onPress, f_252438_);
            this.screen = screen;
            this.left = left;
            this.filter = filter;
            this.f_93623_ = false;
        }

        protected void setInActive() {
            this.f_93623_ = false;
        }

        protected void setActive() {
            this.f_93623_ = true;
        }

        public void m_87963_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)FILTER_TEXTURE);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            float j = this.left ? 0.0f : 64.0f;
            j = this.filter.enabled ? j + 32.0f : j;
            GuiComponent.m_93143_((PoseStack)poseStack, (int)this.m_252754_(), (int)this.m_252907_(), (int)0, (float)j, (float)0.0f, (int)32, (int)28, (int)128, (int)128);
            itemRenderer.m_274369_(poseStack, this.filter.icon, this.m_252754_() + 8, this.m_252907_() + 6);
            if (mouseX > this.m_252754_() && mouseY > this.m_252907_() && mouseX < this.m_252754_() + 32 && mouseY < this.m_252907_() + 28) {
                this.screen.m_96602_(poseStack, this.filter.tooltip, mouseX, mouseY);
            }
        }
    }

    public static class Filter {
        public final TagKey<Item> tag;
        private final ItemStack icon;
        private final Component tooltip;
        private boolean enabled;

        public Filter(TagKey<Item> tag, ItemStack icon) {
            this.tag = tag;
            this.icon = icon;
            this.tooltip = Component.m_237115_((String)("filter.fossil." + tag.f_203868_().m_135815_()));
        }
    }
}

