/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model.block;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record PlantBlockModel(List<PlantBlockElement> elements, HashMap<String, Material> materials) {
    public static final ResourceLocation LOADER = FossilMod.location("plant_loader");

    public record PlantBlockFaceUV(float[] uvs, int rotation) {
        public float getU(int index) {
            if (this.uvs == null) {
                throw new NullPointerException("uvs");
            }
            int i = this.getShiftedIndex(index);
            return this.uvs[i == 0 || i == 1 ? 0 : 2];
        }

        public float getV(int index) {
            if (this.uvs == null) {
                throw new NullPointerException("uvs");
            }
            int i = this.getShiftedIndex(index);
            return this.uvs[i == 0 || i == 3 ? 1 : 3];
        }

        private int getShiftedIndex(int index) {
            return (index + this.rotation / 90) % 4;
        }

        public static class Deserializer
        implements JsonDeserializer<PlantBlockFaceUV> {
            public PlantBlockFaceUV deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                return new PlantBlockFaceUV(this.getUVs(jsonObject), this.getRotation(jsonObject));
            }

            protected int getRotation(JsonObject json) {
                return GsonHelper.m_13824_((JsonObject)json, (String)"rotation", (int)0);
            }

            private float @Nullable [] getUVs(JsonObject json) {
                if (!json.has("uv")) {
                    return null;
                }
                JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"uv");
                if (jsonArray.size() != 4) {
                    throw new JsonParseException("Expected 4 uv values, found: " + jsonArray.size());
                }
                float[] fs = new float[4];
                for (int i = 0; i < fs.length; ++i) {
                    fs[i] = GsonHelper.m_13888_((JsonElement)jsonArray.get(i), (String)("uv[" + i + "]"));
                }
                return fs;
            }
        }
    }

    public record PlantBlockElementFace(String texture, PlantBlockFaceUV uv) {

        public static class Deserializer
        implements JsonDeserializer<PlantBlockElementFace> {
            public PlantBlockElementFace deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                String texture = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"texture");
                PlantBlockFaceUV blockFaceUV = (PlantBlockFaceUV)context.deserialize((JsonElement)jsonObject, PlantBlockFaceUV.class);
                return new PlantBlockElementFace(texture, blockFaceUV);
            }
        }
    }

    public record PlantBlockElement(Vector3f from, Vector3f to, Vector3f origin, Vector3f rotations, Map<Direction, PlantBlockElementFace> faces, String name) {

        public static class Deserializer
        implements JsonDeserializer<PlantBlockElement> {
            public PlantBlockElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = json.getAsJsonObject();
                Vector3f from = this.getVector3f(jsonObject, "from");
                Vector3f to = this.getVector3f(jsonObject, "to");
                Vector3f origin = jsonObject.has("origin") ? this.getVector3f(jsonObject, "origin") : new Vector3f(0.0f, 0.0f, 0.0f);
                origin.mul(0.0625f);
                Vector3f rotations = jsonObject.has("rotation") ? this.getVector3f(jsonObject, "rotation") : new Vector3f(0.0f, 0.0f, 0.0f);
                Map<Direction, PlantBlockElementFace> map = this.getFaces(context, jsonObject);
                return new PlantBlockElement(from, to, origin, rotations, map, jsonObject.has("name") ? jsonObject.get("name").getAsString() : "");
            }

            private Map<Direction, PlantBlockElementFace> getFaces(JsonDeserializationContext context, JsonObject json) {
                EnumMap map = Maps.newEnumMap(Direction.class);
                JsonObject jsonObject = GsonHelper.m_13930_((JsonObject)json, (String)"faces");
                for (Map.Entry entry : jsonObject.entrySet()) {
                    Direction direction = this.getFacing((String)entry.getKey());
                    map.put(direction, (PlantBlockElementFace)context.deserialize((JsonElement)entry.getValue(), PlantBlockElementFace.class));
                }
                if (map.isEmpty()) {
                    throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
                }
                return map;
            }

            private Direction getFacing(String name) {
                Direction direction = Direction.m_122402_((String)name);
                if (direction == null) {
                    throw new JsonParseException("Unknown facing: " + name);
                }
                return direction;
            }

            private Vector3f getVector3f(JsonObject json, String name) {
                JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)name);
                if (jsonArray.size() != 3) {
                    throw new JsonParseException("Expected 3 " + name + " values, found: " + jsonArray.size());
                }
                float[] fs = new float[3];
                for (int i = 0; i < fs.length; ++i) {
                    fs[i] = GsonHelper.m_13888_((JsonElement)jsonArray.get(i), (String)(name + "[" + i + "]"));
                }
                return new Vector3f(fs[0], fs[1], fs[2]);
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<PlantBlockModel> {
        public PlantBlockModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            ArrayList<PlantBlockElement> list = new ArrayList<PlantBlockElement>();
            if (jsonObject.has("parts")) {
                for (JsonElement jsonElement : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"parts")) {
                    list.add((PlantBlockElement)context.deserialize(jsonElement, PlantBlockElement.class));
                }
            }
            HashMap materials = Maps.newHashMap();
            if (jsonObject.has("textures")) {
                JsonObject textureSet = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"textures");
                for (Map.Entry entry : textureSet.entrySet()) {
                    materials.put((String)entry.getKey(), new Material(TextureAtlas.f_118259_, ResourceLocation.m_135820_((String)((JsonElement)entry.getValue()).getAsString())));
                }
            }
            return new PlantBlockModel(list, materials);
        }
    }
}

