/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.entity.StoneTablet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StoneTabletRenderer
extends EntityRenderer<StoneTablet>
implements RendererFabricFix {
    private static final ResourceLocation TEXTURE = FossilMod.location("textures/entity/stone_tablet.png");

    public StoneTabletRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    private static int getLightColor(StoneTablet entity, float centerX, float centerY) {
        int x = entity.m_146903_();
        int y = Mth.m_14107_((double)(entity.m_20186_() + (double)(centerY / 16.0f)));
        int z = entity.m_146907_();
        Direction direction = entity.m_6350_();
        if (direction == Direction.NORTH) {
            x = Mth.m_14107_((double)(entity.m_20185_() + (double)(centerX / 16.0f)));
        }
        if (direction == Direction.WEST) {
            z = Mth.m_14107_((double)(entity.m_20189_() - (double)(centerX / 16.0f)));
        }
        if (direction == Direction.SOUTH) {
            x = Mth.m_14107_((double)(entity.m_20185_() - (double)(centerX / 16.0f)));
        }
        if (direction == Direction.EAST) {
            z = Mth.m_14107_((double)(entity.m_20189_() + (double)(centerX / 16.0f)));
        }
        return LevelRenderer.m_109541_((BlockAndTintGetter)entity.f_19853_, (BlockPos)new BlockPos(x, y, z));
    }

    public void render(StoneTablet entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        StoneTablet.Variant variant = entity.variant;
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entity)));
        this.renderTablet(poseStack, vertexConsumer, entity, variant.sizeX, variant.sizeY, variant.offsetX, variant.offsetY);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    private void renderTablet(PoseStack poseStack, VertexConsumer vertexConsumer, StoneTablet entity, int width, int height, int texU, int texV) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        float offsetX = (float)(-width) / 2.0f;
        float offsetY = (float)(-height) / 2.0f;
        for (int blockX = 0; blockX < width / 16; ++blockX) {
            for (int blockZ = 0; blockZ < height / 16; ++blockZ) {
                float minX = offsetX + (float)(blockX * 16);
                float maxX = offsetX + (float)((blockX + 1) * 16);
                float minY = offsetY + (float)(blockZ * 16);
                float maxY = offsetY + (float)((blockZ + 1) * 16);
                int light = StoneTabletRenderer.getLightColor(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float minTexX = (float)(texU + width - blockX * 16) / 256.0f;
                float maxTexX = (float)(texU + width - (blockX + 1) * 16) / 256.0f;
                float minTexY = (float)(texV + height - blockZ * 16) / 256.0f;
                float maxTexY = (float)(texV + height - (blockZ + 1) * 16) / 256.0f;
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, minY, maxTexX, minTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, minY, minTexX, minTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, 0.4f, 0, 0, -1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, 0.4f, 0, 0, -1, light);
                minTexY = (float)(texV + (height + 128) - blockZ * 16) / 256.0f;
                maxTexY = (float)(texV + (height + 128) - (blockZ + 1) * 16) / 256.0f;
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, maxY, maxTexX, maxTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, maxY, minTexX, maxTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, minX, minY, minTexX, minTexY, 0.5f, 0, 0, 1, light);
                this.vertex(matrix4f, matrix3f, vertexConsumer, maxX, minY, maxTexX, minTexY, 0.5f, 0, 0, 1, light);
            }
        }
    }

    private void vertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float x, float y, float u, float v, float z, int k, int l, int m, int n) {
        vertexConsumer.m_252986_(matrix4f, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(n).m_252939_(matrix3f, (float)k, (float)l, (float)m).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(StoneTablet entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation _getTextureLocation(Entity entity) {
        return this.getTextureLocation((StoneTablet)entity);
    }
}

