/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;

public class EatBlockGoal
extends MoveToFoodGoal {
    private boolean done;

    public EatBlockGoal(Prehistoric entity) {
        super(entity, 1.0, 32);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.done = false;
    }

    @Override
    public boolean m_8036_() {
        if (!FossilConfig.isEnabled("dinosEatBlocks")) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.isReachedTarget() && !this.done) {
            int foodAmount = FoodMappings.getFoodAmount((ItemLike)this.entity.f_19853_.m_8055_(this.targetPos).m_60734_(), this.entity.data().diet());
            this.entity.feed(foodAmount);
            this.entity.m_5634_((float)foodAmount / 10.0f);
            this.entity.f_19853_.m_46961_(this.targetPos, false);
            AnimationInfo animationInfo = this.entity.nextEatingAnimation();
            this.entity.getAnimationLogic().triggerAnimation("Movement/Idle", animationInfo, AnimationCategory.EAT);
            this.animEndTick = (long)((double)this.entity.f_19853_.m_46467_() + animationInfo.animation.length());
            this.done = true;
        }
    }

    @Override
    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        if (!super.isValidTarget(level, pos)) {
            return false;
        }
        return FoodMappings.getFoodAmount((ItemLike)level.m_8055_(pos).m_60734_(), this.entity.data().diet()) > 0 && Util.canSeeFood(this.entity, pos);
    }
}

