/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.block.entity.FeederBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FlyingLandNearFoodGoal
extends MoveToFoodGoal {
    protected final PrehistoricFlying dino;
    private final int chunkRadius;
    private Vec3 targetPos;

    public FlyingLandNearFoodGoal(PrehistoricFlying dino) {
        super(dino, 1.0, 32);
        this.dino = dino;
        this.chunkRadius = 2;
    }

    @Override
    public boolean m_8036_() {
        if (!this.dino.m_29443_()) {
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public boolean m_8045_() {
        if (!this.dino.m_29443_()) {
            return false;
        }
        return super.m_8045_();
    }

    @Override
    protected boolean createPath() {
        return this.targetPos != null;
    }

    @Override
    protected void moveMobToBlock() {
        this.dino.moveTo(this.targetPos, true, true);
    }

    @Override
    public void m_8037_() {
    }

    @Override
    protected boolean findNearestBlock() {
        BlockPos mobPos = this.dino.m_20183_();
        Optional<BlockPos> target = ChunkPos.m_45596_((ChunkPos)new ChunkPos(mobPos), (int)this.chunkRadius).flatMap(chunkPos -> this.dino.f_19853_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_).m_62954_().entrySet().stream()).filter(this::isValidTarget).map(Map.Entry::getKey).min(Comparator.comparingInt(pos -> pos.m_123333_((Vec3i)mobPos)));
        if (target.isPresent()) {
            this.targetPos = Vec3.m_82512_((Vec3i)((Vec3i)target.get())).m_82520_(0.0, 1.0, 0.0);
            return true;
        }
        return false;
    }

    private boolean isValidTarget(Map.Entry<BlockPos, BlockEntity> entry) {
        FeederBlockEntity feeder;
        BlockEntity blockEntity = entry.getValue();
        return blockEntity instanceof FeederBlockEntity && !(feeder = (FeederBlockEntity)blockEntity).isEmpty(this.dino.data().diet()) && Util.canSeeFood(this.dino, entry.getKey());
    }
}

