/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AbstractAnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.entity.monster.SentryPiglin;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.AnuDefenseHut;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AnuDefensePhase
extends AbstractAnuPhaseInstance {
    private static final Component ANU_COMBAT_BRUTES = Component.m_237115_((String)"entity.fossil.anu.brutes");
    private static final Component ANU_COMBAT_ARCHERS = Component.m_237115_((String)"entity.fossil.anu.archers");
    private static final Component ANU_COMBAT_BLAZES = Component.m_237115_((String)"entity.fossil.anu.blazes");

    public AnuDefensePhase(AnuBoss anuBoss) {
        super(anuBoss);
    }

    @Override
    public void doClientTick() {
        if (this.anu.f_20919_ <= 0) {
            for (int i = 0; i < 2; ++i) {
                this.anu.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123800_, this.anu.m_20208_(0.5), this.anu.m_20187_(), this.anu.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void doServerTick() {
        Player player;
        if (this.anu.f_19797_ % 20 == 0) {
            this.anu.m_5634_(2.0f);
        }
        if ((player = this.anu.f_19853_.m_5788_(this.anu.m_20185_(), this.anu.m_20186_(), this.anu.m_20189_(), 50.0, player1 -> this.arenaBounds.m_82393_(player1.m_20185_(), player1.m_20186_(), player1.m_20189_()))) != null) {
            this.moveAwayFromPlayer(player);
            this.spawnStructures();
        }
        this.switchPhaseByHealth();
    }

    private void moveAwayFromPlayer(Player player) {
        if (this.anu.m_21573_().m_26571_()) {
            Path path;
            Vec3 away = DefaultRandomPos.m_148407_((PathfinderMob)this.anu, (int)16, (int)7, (Vec3)player.m_20182_());
            if (away == null || away.m_82546_(this.anu.getSpawnPos()).m_165924_() > (double)Mth.m_144944_((int)25)) {
                float t;
                float r;
                for (int i = 0; !(i >= 5 || this.anu.f_19853_.m_46859_(BlockPos.m_274446_((Position)(away = new Vec3(this.anu.getSpawnPos().f_82479_ + (double)((r = (float)(25.0 * Math.sqrt(this.anu.m_217043_().m_188501_()))) * Mth.m_14089_((float)(t = this.anu.m_217043_().m_188501_() * 2.0f * (float)Math.PI))), this.anu.m_20186_(), this.anu.getSpawnPos().f_82481_ + (double)(r * Mth.m_14031_((float)t)))))) && away.m_82546_(player.m_20182_()).m_165924_() > 5.0); ++i) {
                }
            }
            if ((path = this.anu.m_21573_().m_26524_(away.f_82479_, away.f_82480_, away.f_82481_, 2)) == null) {
                this.anu.m_21566_().m_6849_(away.f_82479_, away.f_82480_, away.f_82481_, 1.0);
            } else {
                this.anu.m_21573_().m_26536_(path, 1.33);
            }
        }
    }

    private void spawnStructures() {
        boolean summonBlaze;
        Level level = this.anu.f_19853_;
        RandomSource random = this.anu.m_217043_();
        List players = level.m_45955_(TargetingConditions.f_26872_, (LivingEntity)this.anu, this.arenaBounds);
        boolean summonSpikes = random.m_188503_(250) == 0;
        boolean summonDefenses = random.m_188503_(600) == 0 && this.anu.getSpawnPos().m_82554_(this.anu.m_20182_()) > 5.0;
        boolean summonPiglin = random.m_188503_(350) == 0;
        boolean summonWitherSkeleton = random.m_188503_(400) == 0;
        boolean bl = summonBlaze = random.m_188503_(400) == 0;
        if (FossilConfig.isEnabled("anuBlockPlacing")) {
            if (summonSpikes) {
                this.anu.m_5496_(SoundEvents.f_12446_, 1.0f, 1.0f);
                BlockPos.MutableBlockPos blockPos = this.anu.m_20183_().m_122032_();
                BlockState blockState = level.m_8055_((BlockPos)blockPos);
                while ((blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13035_)) && blockPos.m_123342_() > 0) {
                    blockPos.m_122173_(Direction.DOWN);
                }
                for (int i = 0; i < 4; ++i) {
                    blockPos.m_122184_(random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
                    if (!level.m_46859_((BlockPos)blockPos) || !((Block)ModBlocks.OBSIDIAN_SPIKES.get()).m_7898_(level.m_8055_(blockPos.m_7495_()), (LevelReader)level, (BlockPos)blockPos)) continue;
                    level.m_7731_((BlockPos)blockPos, ((Block)ModBlocks.OBSIDIAN_SPIKES.get()).m_49966_(), 2);
                }
            } else if (summonDefenses) {
                this.anu.m_5496_(SoundEvents.f_12446_, 1.0f, 1.0f);
                Vec3 pos = this.anu.m_20182_();
                AnuDefenseHut.generateDefenseHutP2(level, BlockPos.m_274446_((Position)pos));
                AnuDefenseHut.generateDefenseHutP2(level, BlockPos.m_274446_((Position)pos.m_82520_(0.0, 1.0, 0.0)));
                AnuDefenseHut.generateDefenseHutP2(level, BlockPos.m_274446_((Position)pos.m_82520_(0.0, 2.0, 0.0)));
                AnuDefenseHut.generateDefenseHutP1(level, BlockPos.m_274446_((Position)pos.m_82520_(0.0, 4.0, 0.0)));
            }
        }
        if (summonPiglin) {
            SentryPiglin sentryPiglin = (SentryPiglin)((EntityType)ModEntities.SENTRY_PIGLIN.get()).m_20615_(level);
            sentryPiglin.m_7678_(this.anu.m_20185_() + (double)random.m_188503_(4), this.anu.m_20186_(), this.anu.m_20189_() + (double)random.m_188503_(4), this.anu.m_146908_(), this.anu.m_146909_());
            level.m_7967_((Entity)sentryPiglin);
            players.forEach(player -> player.m_5661_(ANU_COMBAT_BRUTES, false));
        } else if (summonWitherSkeleton) {
            WitherSkeleton witherSkeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_(level);
            witherSkeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            witherSkeleton.m_7678_(this.anu.m_20185_() + (double)random.m_188503_(4), this.anu.m_20186_(), this.anu.m_20189_() + (double)random.m_188503_(4), this.anu.m_146908_(), this.anu.m_146909_());
            level.m_7967_((Entity)witherSkeleton);
            players.forEach(player -> player.m_5661_(ANU_COMBAT_ARCHERS, false));
        } else if (summonBlaze) {
            Blaze blaze = (Blaze)EntityType.f_20551_.m_20615_(level);
            blaze.m_7678_(this.anu.m_20185_() + (double)random.m_188503_(4), this.anu.m_20186_(), this.anu.m_20189_() + (double)random.m_188503_(4), this.anu.m_146908_(), this.anu.m_146909_());
            level.m_7967_((Entity)blaze);
            players.forEach(player -> player.m_5661_(ANU_COMBAT_BLAZES, false));
        }
    }

    @Override
    public AnuPhase getPhase() {
        return AnuPhase.DEFENSE;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ANU_COUGH.get();
    }

    @Override
    public boolean isFlying() {
        return false;
    }
}

