/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AbstractAnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.phys.Vec3;

public class AnuFlightPhase
extends AbstractAnuPhaseInstance {
    private Vec3 targetLocation;
    private int seeTime;
    private int attackTime;
    private int fireballReturnedCount;
    private static final int MAX_ATTACK_TIME = 40;
    private static final int MIN_ATTACK_TIME = 20;

    public AnuFlightPhase(AnuBoss anuBoss) {
        super(anuBoss);
    }

    @Override
    public void doClientTick() {
        for (int i = 0; i < 2; ++i) {
            this.anu.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.anu.m_20208_(0.5), this.anu.m_20187_(), this.anu.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void doServerTick() {
        if (this.fireballReturnedCount == 3) {
            this.anu.phaseSystem.setPhase(AnuPhase.LANDING);
            return;
        }
        if (this.anu.f_19797_ % 20 == 0) {
            this.anu.m_5634_(2.0f);
        }
        if (!this.anu.m_20096_() && this.anu.m_20184_().f_82480_ < 0.0) {
            this.anu.m_20256_(this.anu.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.targetLocation == null || !this.anu.m_21566_().m_24995_()) {
            if (this.findRandomPosAwayFromPlayer()) {
                this.anu.m_21573_().m_26573_();
                this.anu.m_21566_().m_6849_(this.targetLocation.f_82479_, this.targetLocation.f_82480_, this.targetLocation.f_82481_, 1.0);
            }
        } else {
            Player player = this.getPlayer();
            if (player != null) {
                if (this.targetLocation.m_82546_(player.m_20182_()).m_165924_() < 5.0 && this.findRandomPosAwayFromPlayer()) {
                    this.anu.m_21566_().m_6849_(this.targetLocation.f_82479_, this.targetLocation.f_82480_, this.targetLocation.f_82481_, 1.0);
                }
                this.throwFireballs(player);
            }
        }
        this.switchPhaseByHealth();
    }

    @Override
    protected void switchPhaseByHealth() {
        AnuPhase newPhase = AnuPhase.byFraction(this.anu.m_21223_() / this.anu.m_21233_());
        if (newPhase == AnuPhase.DEFENSE || this.anu.f_19853_.m_46467_() > this.endTime) {
            this.anu.phaseSystem.setPhase(newPhase, 100);
        }
    }

    private void throwFireballs(Player targetPlayer) {
        double dist = this.anu.m_20280_((Entity)targetPlayer);
        boolean hasLineOfSight = this.anu.m_21574_().m_148306_((Entity)targetPlayer);
        this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
        --this.attackTime;
        if (this.attackTime == 0) {
            if (!hasLineOfSight) {
                return;
            }
            this.anu.m_6504_((LivingEntity)targetPlayer, 0.0f);
            float distanceFactor = (float)(Math.sqrt(dist) / 25.0);
            this.attackTime = (int)Mth.m_14179_((float)distanceFactor, (float)20.0f, (float)40.0f);
        } else if (this.attackTime < 0) {
            float distanceFactor = (float)(Math.sqrt(dist) / 25.0);
            this.attackTime = (int)Mth.m_14179_((float)distanceFactor, (float)20.0f, (float)40.0f);
        }
    }

    private Player getPlayer() {
        if (Version.debugEnabled() && this.anu.f_19853_.m_45930_((Entity)this.anu, 200.0) != null) {
            return this.anu.f_19853_.m_45930_((Entity)this.anu, 200.0);
        }
        LivingEntity livingEntity = this.anu.m_5448_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    private boolean findRandomPosAwayFromPlayer() {
        Player player = this.getPlayer();
        for (int i = 0; i < 3; ++i) {
            float r = (float)(25.0 * Math.sqrt(this.anu.m_217043_().m_188501_()));
            float t = this.anu.m_217043_().m_188501_() * 2.0f * (float)Math.PI;
            float targetY = Mth.m_216283_((RandomSource)this.anu.m_217043_(), (float)0.0f, (float)4.0f);
            this.targetLocation = this.anu.getSpawnPos().m_82520_((double)(r * Mth.m_14089_((float)t)), (double)targetY, (double)(r * Mth.m_14031_((float)t)));
            if (!this.anu.f_19853_.m_46859_(BlockPos.m_274446_((Position)this.targetLocation))) continue;
            if (player != null) {
                return this.targetLocation.m_82546_(player.m_20182_()).m_165924_() > 5.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public AnuPhase getPhase() {
        return AnuPhase.FLIGHT;
    }

    @Override
    public void onHurt(DamageSource source, float amount) {
        if (source.m_7640_() instanceof LargeFireball && source.m_7639_() instanceof Player) {
            ++this.fireballReturnedCount;
        }
    }

    @Override
    public void end() {
        this.fireballReturnedCount = 0;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ANU_COUGH.get();
    }

    @Override
    public boolean isFlying() {
        return true;
    }
}

