/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.monster;

import com.github.teamfossilsarcheology.fossil.item.ModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Anubite
extends PathfinderMob {
    private int targetChangedTick;

    public Anubite(EntityType<Anubite> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Anubite.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.34).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TeleportMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    private boolean shouldAttackPlayer(LivingEntity player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
        return !stack.m_150930_((Item)ModItems.ANCIENT_HELMET.get());
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        this.targetChangedTick = target == null ? 0 : this.f_19797_;
    }

    protected void m_8024_() {
        float f;
        if (this.f_19797_ >= this.targetChangedTick + 600 && (double)(f = this.m_213856_()) > 0.5 && (double)(this.f_19796_.m_188501_() * 30.0f) < ((double)f - 0.4) * 2.0) {
            this.teleportRandomly();
        }
        super.m_8024_();
    }

    private boolean teleportRandomly() {
        if (this.f_19853_.m_5776_() || !this.m_6084_()) {
            return false;
        }
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(x, y, z);
    }

    private boolean teleportTowards(Entity target) {
        Vec3 vecToTarget = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_());
        vecToTarget = vecToTarget.m_82541_();
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vecToTarget.f_82479_ * 16.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vecToTarget.f_82480_ * 16.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vecToTarget.f_82481_ * 16.0;
        return this.teleport(x, y, z);
    }

    private boolean teleport(double x, double y, double z) {
        boolean canTeleport = this.m_20984_(x, y, z, true);
        if (canTeleport && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return canTeleport;
    }

    public boolean m_7327_(Entity target) {
        if (this.f_19796_.m_188503_(5) == 0) {
            this.teleportRandomly();
        }
        return super.m_7327_(target);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) && !source.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        if (source.m_269014_()) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (source.m_269533_(DamageTypeTags.f_276146_) && this.f_19796_.m_188503_(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12018_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    static class TeleportMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Anubite anubite;
        private int teleportTime;

        public TeleportMeleeAttackGoal(Anubite anubite, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)anubite, speedModifier, followingTargetEvenIfNotSeen);
            this.anubite = anubite;
        }

        public void m_8056_() {
            super.m_8056_();
            this.teleportTime = 0;
        }

        public void m_8037_() {
            LivingEntity target = this.anubite.m_5448_();
            if (target != null) {
                if (this.anubite.shouldAttackPlayer(target)) {
                    if (target.m_20280_((Entity)this.anubite) > 45.0 && this.anubite.f_19796_.m_188503_(55) == 0) {
                        this.anubite.teleportTowards((Entity)target);
                    }
                    this.teleportTime = 0;
                } else if (target.m_20280_((Entity)this.anubite) > 256.0 && this.teleportTime++ >= 30 && this.anubite.teleportTowards((Entity)target)) {
                    this.teleportTime = 0;
                }
            }
            super.m_8037_();
        }
    }
}

