/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.monster;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Failuresaurus
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Failuresaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(Failuresaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");

    public Failuresaurus(EntityType<Failuresaurus> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 4;
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Failuresaurus.m_33035_().m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)Variant.DODO.name());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        for (int i = 0; i < 4; ++i) {
            int x = Mth.m_14107_((double)(this.m_20182_().f_82479_ + (double)(i % 2 * 2 - 1) * 0.025));
            int y = Mth.m_14107_((double)this.m_20182_().f_82480_);
            int z = Mth.m_14107_((double)(this.m_20182_().f_82481_ + (double)((i >> 1) * 2 - 1) * 0.25));
            BlockPos blockPos = new BlockPos(x, y, z);
            BlockState slime = ((Block)ModBlocks.SLIME_TRAIL.get()).m_49966_();
            if (!this.f_19853_.m_8055_(blockPos).m_60795_() || !slime.m_60710_((LevelReader)this.f_19853_, blockPos)) continue;
            this.f_19853_.m_46597_(blockPos, slime);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return (Byte)this.f_19804_.m_135370_(CLIMBING) == 1;
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)((byte)(climbing ? 1 : 0)));
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public String getVariant() {
        return (String)this.f_19804_.m_135370_(VARIANT);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        String variant = compound.m_128461_("Variant");
        if (variant.isBlank()) {
            variant = Variant.DODO.name();
        }
        this.setVariant(variant);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)this.f_19796_))).name());
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected int m_21304_() {
        return 18;
    }

    protected void m_6135_() {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    @NotNull
    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new PausableAnimationController<Failuresaurus>(this, "Movement/Idle", 0, state -> {
            if (this.f_20911_) {
                if (this.f_20913_ == 0) {
                    state.getController().forceAnimationReset();
                }
                state.getController().setAnimation(ATTACK);
            } else if (state.isMoving()) {
                state.getController().setAnimation(WALK);
            } else {
                state.getController().setAnimation(IDLE);
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum Variant {
        DODO,
        FISH,
        FLYING,
        SAUROPOD,
        THEROPOD;

    }
}

