/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Parasaurolophus
extends Prehistoric {
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(Parasaurolophus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ParaAnimationLogic animationLogic = new ParaAnimationLogic(this);
    private static final String STAND = "animation.parasaurolophus.stand";
    private static final String STAND_UP = "animation.parasaurolophus.stand_up";

    public Parasaurolophus(EntityType<Parasaurolophus> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
        this.f_21345_.m_25352_(19, (Goal)new ParaStandGoal());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STANDING, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (!this.f_19853_.f_46443_ && (SLEEPING.equals(key) || SITTING.equals(key))) {
            this.setStanding(false);
        }
        super.m_7350_(key);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Standing", this.isStanding());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setStanding(compound.m_128471_("Standing"));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.PARASAUROLOPHUS;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42398_;
    }

    @Override
    public double m_6048_() {
        return super.m_6048_() + 0.4;
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(STANDING, (Object)standing);
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.15f : super.getGenderedScale();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PARASAUROLOPHUS_DEATH.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<Parasaurolophus> controller = new PausableAnimationController<Parasaurolophus>(this, "Movement/Idle", 5, this.animationLogic::paraPredicate);
        this.registerEatingListeners(controller);
        controllerRegistrar.add(new AnimationController[]{controller});
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new PausableAnimationController<Parasaurolophus>(this, "Attack", 0, this.getAnimationLogic()::attackPredicate);
        controllerRegistrar.add(animationControllerArray);
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    static class ParaAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public ParaAnimationLogic(Parasaurolophus entity) {
            super(entity);
        }

        public PlayState paraPredicate(AnimationState<Parasaurolophus> state) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = state.getController();
            if (this.tryNextAnimation(state, controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            if (((Parasaurolophus)state.getAnimatable()).isStanding()) {
                controller.setAnimation(RawAnimation.begin().thenPlay(Parasaurolophus.STAND_UP).thenLoop(Parasaurolophus.STAND));
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((Prehistoric)this.entity).m_5803_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (((Parasaurolophus)state.getAnimatable()).sitSystem.isSitting()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (((Prehistoric)this.entity).m_20069_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
            } else if (state.isMoving()) {
                animationSpeed = this.addMovementAnimation(state, true);
            } else {
                this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            ParaAnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.setTransitionLength(newAnimation.get().transitionLength());
                controller.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName(), newAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        }
    }

    class ParaStandGoal
    extends Goal {
        private int cooldown;

        public ParaStandGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > Parasaurolophus.this.f_19797_ || Parasaurolophus.this.m_20069_() || Parasaurolophus.this.m_6107_()) {
                return false;
            }
            return Parasaurolophus.this.f_19796_.m_188503_(100) == 0;
        }

        public boolean m_8045_() {
            return !Parasaurolophus.this.m_20160_() && !Parasaurolophus.this.m_20069_() && !Parasaurolophus.this.m_6107_() && Parasaurolophus.this.f_19796_.m_188503_(ParaStandGoal.m_186073_((int)2000)) != 0;
        }

        public void m_8056_() {
            this.cooldown = 0;
            Parasaurolophus.this.setStanding(true);
        }

        public void m_8041_() {
            this.cooldown = Parasaurolophus.this.f_19797_ + (Parasaurolophus.this.f_19796_.m_188503_(120) + 10) * 20;
            Parasaurolophus.this.setStanding(false);
        }
    }
}

