/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.darkpred.morehitboxes.api.EntityHitboxData;
import com.github.darkpred.morehitboxes.api.EntityHitboxDataFactory;
import com.github.darkpred.morehitboxes.api.GeckoLibMultiPartEntity;
import com.github.darkpred.morehitboxes.api.MultiPart;
import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.client.OptionalTextureLoader;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoStayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatBlockGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PassiveFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WhipSteering;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricWallClimberNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.data.AI;
import com.github.teamfossilsarcheology.fossil.entity.data.Attribute;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MoodSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SitSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import com.github.teamfossilsarcheology.fossil.entity.util.InstructionSystem;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.entity.variant.ConfigCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.DateCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.EntityVariantLoader;
import com.github.teamfossilsarcheology.fossil.entity.variant.NameTagCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.NbtCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.Variant;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantRegistry;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.network.C2SHitPlayerMessage;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.SyncedEntityDataHelper;
import com.github.teamfossilsarcheology.fossil.network.debug.C2SDisableAIMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import it.unimi.dsi.fastutil.Pair;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class Prehistoric
extends TamableAnimal
implements GeckoLibMultiPartEntity<Prehistoric>,
PlayerRideableJumping,
EntitySpawnExtension,
PrehistoricAnimatable<Prehistoric>,
PrehistoricDebug {
    private static final EntityDataAccessor<CompoundTag> DEBUG = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> MOOD = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE_TICK = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> CLIMBING_DIR = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Boolean> AGING_DISABLED = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<CompoundTag> DIMENSION_VER = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> GENDER = SynchedEntityData.m_135353_(Prehistoric.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int GROW_UP_INTERVAL = 120;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<AISystem> aiSystems = new ArrayList<AISystem>();
    public final MoodSystem moodSystem = this.registerSystem(new MoodSystem(this));
    public final SleepSystem sleepSystem = this.registerSystem(this.createSleepSystem());
    public final SitSystem sitSystem = this.registerSystem(new SitSystem(this));
    protected final WhipSteering steering = new WhipSteering(this);
    private final AnimationLogic<Prehistoric> animationLogic = new AnimationLogic<Prehistoric>(this);
    private final InstructionSystem instructionSystem = this.registerSystem(new InstructionSystem(this));
    public final ResourceLocation animationLocation;
    private OrderType currentOrder = OrderType.WANDER;
    public ResourceLocation textureLocation;
    public int climbTick;
    public int prevClimbTick;
    public Direction prevClimbDirection = Direction.UP;
    protected DinoMatingGoal matingGoal;
    protected float playerJumpPendingScale;
    private int fleeTicks = 0;
    private int matingCooldown = this.f_19796_.m_188503_(6000) + 6000;
    private int ticksClimbing = 0;
    private int climbingCooldown = 0;
    private Vec3 eatPos;
    private final EntityHitboxData<Prehistoric> hitboxData = EntityHitboxDataFactory.create((Mob)this);
    protected double swimSpeed;
    private boolean useLowerFluidJumpThreshold;
    private final Map<VariantRegistry.RegistryObject<?>, VariantCondition.WithVariant<?>> allVariants = new HashMap();
    private long synTime = -1L;
    private float scaleOverride = -1.0f;
    public static final byte TOTEM_PARTICLES = 35;
    public static final byte WHEAT_SEEDS_PARTICLES = 62;
    public static final byte BREAD_PARTICLES = 63;
    public static final byte BEEF_PARTICLES = 64;
    public static final byte HAPPY_VILLAGER_PARTICLES = 65;
    public static final byte GROW_UP_PARTICLES = 66;

    protected Prehistoric(EntityType<? extends Prehistoric> entityType, Level level, ResourceLocation animationLocation) {
        super(entityType, level);
        this.animationLocation = animationLocation;
        this.f_21342_ = new SmoothTurningMoveControl(this);
        this.f_21365_ = new PrehistoricLookControl(this);
        this.m_6210_();
        if (this.m_6336_() == MobType.f_21644_) {
            this.m_21441_(BlockPathTypes.WATER, -1.0f);
            this.m_21573_().m_26575_().m_77358_(true);
        }
        this.m_21530_();
    }

    protected Prehistoric(EntityType<? extends Prehistoric> entityType, Level level) {
        this(entityType, level, FossilMod.location("animations/entity/" + EntityType.m_20613_(entityType).m_135815_() + ".animation.json"));
    }

    public EntityHitboxData<Prehistoric> getEntityHitboxData() {
        return this.hitboxData;
    }

    public boolean partHurt(MultiPart<Prehistoric> multiPart, @NotNull DamageSource damageSource, float v) {
        return this.m_6469_(damageSource, v);
    }

    public void setAnchorPos(String boneName, Vec3 localPos) {
        if ("eat_pos".equals(boneName)) {
            this.eatPos = this.m_20182_().m_82549_(localPos);
        }
    }

    public boolean canSetAnchorPos(String boneName) {
        return "eat_pos".equals(boneName);
    }

    public boolean attackBoxHit(Player player) {
        MessageHandler.SYNC_CHANNEL.sendToServer((Object)new C2SHitPlayerMessage((Entity)this, (Entity)player));
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, (double)0.4f);
    }

    protected void m_8099_() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.f_21345_.m_25352_(0, (Goal)new DinoStayGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DinoPanicGoal(this, this.attributes().sprintMod()));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE && this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.JUMP) {
            this.f_21345_.m_25352_(6, new DelayedAttackGoal<Prehistoric>(this, this.attributes().sprintMod(), false));
        }
        this.f_21345_.m_25352_(12, (Goal)this.matingGoal);
        if (this.data().diet() != Diet.PASSIVE) {
            this.f_21345_.m_25352_(15, (Goal)new EatFromFeederGoal(this));
            this.f_21345_.m_25352_(16, (Goal)new EatItemEntityGoal(this));
            this.f_21345_.m_25352_(17, (Goal)new EatBlockGoal(this));
        } else {
            this.f_21345_.m_25352_(15, (Goal)new PassiveFoodGoal(this));
        }
        this.f_21345_.m_25352_(18, (Goal)new PlayGoal(this, this.attributes().sprintMod() - 0.15));
        this.f_21345_.m_25352_(20, (Goal)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.f_21345_.m_25352_(21, (Goal)new DinoWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(25, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(26, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DinoOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinoOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinoHurtByTargetGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new HuntingTargetGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LaserPointEntity.class, true));
    }

    protected void m_8022_() {
        boolean enabled = !this.m_5803_() && !this.isWeak();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, enabled && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.JUMP, enabled && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, enabled);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(MOOD, (Object)0);
        this.f_19804_.m_135372_(AGE_TICK, (Object)(this.data().adultAgeInTicks() - 1));
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(FLEEING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(CLIMBING_DIR, (Object)Direction.UP);
        this.f_19804_.m_135372_(AGING_DISABLED, (Object)false);
        this.f_19804_.m_135372_(DIMENSION_VER, (Object)new CompoundTag());
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)"");
        this.f_19804_.m_135372_(GENDER, (Object)(this.f_19796_.m_188499_() ? (byte)1 : 0));
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("disableGoalAI", false);
        tag.m_128379_("disableMoveAI", false);
        tag.m_128379_("disableLookAI", false);
        this.f_19804_.m_135372_(DEBUG, (Object)tag);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        block9: {
            block7: {
                CompoundTag tag;
                block10: {
                    block8: {
                        if (!this.f_19853_.f_46443_) break block7;
                        if (!DATA_VARIANT.equals(key) && !SLEEPING.equals(key) && !AGE_TICK.equals(key) && !GENDER.equals(key)) break block8;
                        this.refreshTexturePath();
                        break block9;
                    }
                    if (!CLIMBING_DIR.equals(key)) break block10;
                    if (this.f_19804_.m_135370_(CLIMBING_DIR) != Direction.UP) {
                        this.prevClimbDirection = (Direction)this.f_19804_.m_135370_(CLIMBING_DIR);
                    }
                    break block9;
                }
                if (!DIMENSION_VER.equals(key) || !(tag = (CompoundTag)this.f_19804_.m_135370_(DIMENSION_VER)).m_128425_("Width", 5) || !tag.m_128425_("Height", 5)) break block9;
                this.f_19815_ = EntityDimensions.m_20398_((float)tag.m_128457_("Width"), (float)tag.m_128457_("Height"));
                this.f_19816_ = this.m_6380_(this.m_20089_(), this.f_19815_);
                break block9;
            }
            if (AGE_TICK.equals(key)) {
                this.updateAbilities();
            } else if (f_19833_.equals(key)) {
                for (VariantCondition.WithVariant<NameTagCondition> pair : this.variantsByCondition(NameTagCondition.class)) {
                    if (pair.condition().test((Entity)this)) {
                        this.setVariant(VariantRegistry.NAME_TAG, pair);
                        break;
                    }
                    if (!this.allVariants.containsKey(VariantRegistry.NAME_TAG) || !Objects.equals(this.allVariants.get(VariantRegistry.NAME_TAG).condition(), pair.condition())) continue;
                    this.clearVariant(VariantRegistry.NAME_TAG);
                }
            }
        }
        if (AGE_TICK.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.writeBoolean(this.getGender() == Gender.MALE);
        buf.writeInt(this.m_146764_());
        buf.writeFloat(this.m_146909_());
        buf.m_130070_(this.getVariantId());
        this.instructionSystem.saveAdditionalSpawnData(buf);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.setGender(Gender.MALE);
        } else {
            this.setGender(Gender.FEMALE);
        }
        this.setAgeInTicks(buf.readInt());
        this.m_146926_(buf.readFloat());
        this.setVariantId(buf.m_130277_());
        this.refreshTexturePath();
        this.instructionSystem.loadAdditionalSpawnData(buf);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.aiSystems.forEach(system -> system.saveAdditional(compound));
        compound.m_128405_("MatingCooldown", this.getMatingCooldown());
        compound.m_128405_("Hunger", this.getHunger());
        compound.m_128379_("Fleeing", this.isFleeing());
        compound.m_128379_("Climbing", this.isClimbing());
        compound.m_128405_("TicksClimbing", this.ticksClimbing);
        compound.m_128405_("ClimbingCooldown", this.climbingCooldown);
        compound.m_128344_("CurrentOrder", (byte)this.currentOrder.ordinal());
        compound.m_128350_("YBodyRot", this.f_20883_);
        compound.m_128350_("YHeadRot", this.f_20885_);
        compound.m_128379_("AgingDisabled", this.isAgingDisabled());
        compound.m_128344_("Gender", (byte)this.getGender().ordinal());
        compound.m_128359_("VariantId", this.getVariantId());
        ListTag saved = new ListTag();
        for (Map.Entry<VariantRegistry.RegistryObject<?>, VariantCondition.WithVariant<?>> entry : this.allVariants.entrySet()) {
            saved.add((Object)entry.getKey().save(new CompoundTag(), entry.getValue()));
        }
        compound.m_128365_("Variants", (Tag)saved);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.aiSystems.forEach(system -> system.load(compound));
        int savedAge = compound.m_128451_("Age");
        this.setAgeInTicks(savedAge - savedAge % 120);
        this.setMatingCooldown(compound.m_128451_("MatingCooldown"));
        this.setHunger(compound.m_128451_("Hunger"));
        this.setFleeing(compound.m_128471_("Fleeing"));
        this.setClimbing(compound.m_128471_("Climbing"));
        this.ticksClimbing = compound.m_128451_("TicksClimbing");
        this.climbingCooldown = compound.m_128451_("ClimbingCooldown");
        if (compound.m_128425_("CurrentOrder", 1)) {
            this.setCurrentOrder(OrderType.values()[compound.m_128445_("CurrentOrder")]);
        }
        this.f_20883_ = compound.m_128451_("YBodyRot");
        this.f_20885_ = compound.m_128451_("YHeadRot");
        this.setAgingDisabled(compound.m_128471_("AgingDisabled"));
        if (compound.m_128425_("Gender", 8)) {
            if ("female".equalsIgnoreCase(compound.m_128461_("Gender"))) {
                this.setGender(Gender.FEMALE);
            } else {
                this.setGender(Gender.MALE);
            }
        } else {
            this.setGender(Gender.values()[compound.m_128445_("Gender")]);
        }
        if (compound.m_128425_("VariantId", 8)) {
            this.setVariantId(compound.m_128461_("VariantId"));
        }
        ListTag saved = compound.m_128437_("Variants", 10);
        this.allVariants.clear();
        for (Tag savedTag : saved) {
            VariantRegistry.RegistryObject<VariantCondition> type = VariantRegistry.RegistryObject.parse((CompoundTag)savedTag);
            this.allVariants.put(type, VariantCondition.WithVariant.of(type.serializer().load((CompoundTag)savedTag), this.variants().get(compound.m_128461_("VariantId"))));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        for (VariantCondition.WithVariant<ConfigCondition> pair : this.variantsByCondition(ConfigCondition.class)) {
            if (pair.condition().test()) {
                this.setVariant(VariantRegistry.CONFIG, pair);
                break;
            }
            if (!this.allVariants.containsKey(VariantRegistry.CONFIG) || !Objects.equals(this.allVariants.get(VariantRegistry.CONFIG).condition(), pair.condition())) continue;
            this.clearVariant(VariantRegistry.CONFIG);
        }
    }

    public void m_6210_() {
        EntityDimensions newDimensions;
        EntityDimensions oldDimensions = this.f_19815_;
        Pose pose = this.m_20089_();
        this.f_19815_ = newDimensions = this.m_6972_(pose);
        this.f_19816_ = this.m_6380_(pose, newDimensions);
        this.m_20090_();
        if (!(this.f_19853_.f_46443_ || this.f_19803_ || this.f_19794_ || !(newDimensions.f_20377_ > oldDimensions.f_20377_) && !(newDimensions.f_20378_ > oldDimensions.f_20378_))) {
            double hDiff;
            double wDiff;
            Vec3 vec3 = this.m_20182_().m_82520_(0.0, (double)oldDimensions.f_20378_ / 2.0, 0.0);
            VoxelShape voxelShape = Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)vec3, (double)(wDiff = Math.max(0.0, (double)(newDimensions.f_20377_ - oldDimensions.f_20377_)) + 1.0E-6), (double)(hDiff = Math.max(0.0, (double)(newDimensions.f_20378_ - oldDimensions.f_20378_)) + 1.0E-6), (double)wDiff));
            Optional opt = this.f_19853_.m_151418_((Entity)this, voxelShape, vec3, (double)newDimensions.f_20377_, (double)newDimensions.f_20378_, (double)newDimensions.f_20377_);
            if (opt.isPresent()) {
                this.m_146884_(((Vec3)opt.get()).m_82520_(0.0, (double)(-newDimensions.f_20378_) / 2.0, 0.0));
            } else {
                this.f_19815_ = oldDimensions;
                this.f_19816_ = this.m_6380_(pose, oldDimensions);
                CompoundTag tag = new CompoundTag();
                tag.m_128350_("Width", this.f_19815_.f_20377_);
                tag.m_128350_("Height", this.f_19815_.f_20378_);
                this.f_19804_.m_135381_(DIMENSION_VER, (Object)tag);
                this.m_20090_();
            }
        }
        for (MultiPart part : this.getEntityHitboxData().getCustomParts()) {
            part.getEntity().m_6210_();
        }
    }

    @NotNull
    public EntityDimensions m_6972_(Pose poseIn) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    protected Pose getTargetPose() {
        return this.m_5803_() ? Pose.SLEEPING : Pose.STANDING;
    }

    public void updatePose() {
        this.m_20124_(this.getTargetPose());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188583_() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        if (spawnDataIn instanceof PrehistoricGroupData) {
            PrehistoricGroupData prehistoricGroupData = (PrehistoricGroupData)spawnDataIn;
            this.setAgeInDays(prehistoricGroupData.ageInDays());
        } else if (spawnDataIn == null) {
            spawnDataIn = new PrehistoricGroupData(this.data().adultAgeDays());
            this.setAgeInDays(((PrehistoricGroupData)spawnDataIn).ageInDays);
        }
        this.updateAbilities();
        this.setHunger(this.getMaxHunger() / 2);
        this.m_6210_();
        this.moodSystem.setPlayingCooldown(0);
        this.setMatingCooldown(24000);
        this.m_5634_(this.m_21233_());
        this.setCurrentOrder(OrderType.WANDER);
        this.m_21557_(false);
        for (VariantCondition.WithVariant<ConfigCondition> withVariant : this.variantsByCondition(ConfigCondition.class)) {
            if (withVariant.condition().test()) {
                this.setVariant(VariantRegistry.CONFIG, withVariant);
                break;
            }
            if (!this.allVariants.containsKey(VariantRegistry.CONFIG) || !Objects.equals(this.allVariants.get(VariantRegistry.CONFIG).condition(), withVariant.condition())) continue;
            this.clearVariant(VariantRegistry.CONFIG);
        }
        for (VariantCondition.WithVariant<VariantCondition> withVariant : this.variantsByCondition(DateCondition.class)) {
            if (!((DateCondition)withVariant.condition()).test(this.f_19796_, ZonedDateTime.now())) continue;
            this.setVariant(VariantRegistry.DATE, withVariant);
            break;
        }
        if (dataTag != null) {
            for (VariantCondition.WithVariant<VariantCondition> withVariant : this.variantsByCondition(NbtCondition.class)) {
                if (!((NbtCondition)withVariant.condition()).test(dataTag)) continue;
                this.setVariant(VariantRegistry.NBT, withVariant);
                break;
            }
        }
        return spawnDataIn;
    }

    public OrderType getCurrentOrder() {
        return this.currentOrder;
    }

    public void setCurrentOrder(OrderType newOrder) {
        this.currentOrder = newOrder;
    }

    public boolean m_6107_() {
        return super.m_6107_() || this.isWeak() || this.m_5803_() || this.sitSystem.isSitting();
    }

    public void m_5997_(double x, double y, double z) {
        EntityDimensions dimensions = this.m_6972_(Pose.STANDING);
        float max = Math.max(dimensions.f_20377_, dimensions.f_20378_);
        if (max < 3.0f) {
            float mult = Mth.m_14179_((float)((Math.max(max, 1.0f) - 1.0f) / 2.0f), (float)1.0f, (float)0.0f);
            super.m_5997_(x * (double)mult, y, z * (double)mult);
        }
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.m_20160_();
    }

    public boolean hasTarget() {
        return this.m_5448_() != null || this.moodSystem.getToyTarget() != null;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player) && this.m_21830_((LivingEntity)player);
    }

    @Nullable
    public Player getRidingPlayer() {
        Player player;
        LivingEntity livingEntity = this.m_6688_();
        return livingEntity instanceof Player ? (player = (Player)livingEntity) : null;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.85;
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (this.canBeControlledByRider() && passenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)passenger;
            this.f_20883_ = livingEntity.f_20885_;
        }
        this.getEntityHitboxData().getAnchorData().getAnchorPos("rider_pos").ifPresentOrElse(pos -> {
            if (passenger instanceof Player) {
                passenger.m_6034_(pos.f_82479_, pos.f_82480_ + passenger.m_6049_() - 0.2, pos.f_82481_);
            } else {
                passenger.m_6034_(pos.f_82479_, pos.f_82480_ + passenger.m_6049_(), pos.f_82481_);
            }
        }, () -> passenger.m_6034_(this.m_20185_(), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_()));
    }

    public double getJumpStrength() {
        return 0.3;
    }

    private void doJump(double upwardMovement, double forwardMovement) {
        this.f_19812_ = true;
        if (forwardMovement > 0.0) {
            float h = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float i = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * h * this.playerJumpPendingScale), upwardMovement, (double)(0.4f * i * this.playerJumpPendingScale)));
        } else {
            this.m_20334_(this.m_20184_().f_82479_, upwardMovement, this.m_20184_().f_82481_);
        }
    }

    public boolean m_7132_() {
        return this.m_20160_();
    }

    public void m_7199_(int i) {
        this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
    }

    public void m_8012_() {
    }

    public void m_7888_(int jumpPower) {
        this.playerJumpPendingScale = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
    }

    public boolean canBeControlledByRider() {
        return this.data().canBeRidden() && this.m_21830_(this.m_6688_());
    }

    public void m_7023_(Vec3 travelVector) {
        boolean fastInWater;
        if (this.m_6107_() && !this.m_20160_()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (rider == null || !this.canBeControlledByRider() || !this.steering.trySteering(rider)) {
            super.m_7023_(travelVector);
            return;
        }
        this.m_146922_(rider.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        float newStrafeMovement = rider.f_20900_ * 0.5f;
        float newForwardMovement = rider.f_20902_;
        boolean bl = fastInWater = this.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
        if (this.playerJumpPendingScale > 0.0f) {
            double newYMovement = this.getJumpStrength() * (double)this.playerJumpPendingScale * (double)this.m_20098_() + this.m_182332_();
            if (this.m_20069_()) {
                if (fastInWater) {
                    this.doJump(newYMovement, newForwardMovement);
                } else {
                    this.doJump(newYMovement / 2.0, newForwardMovement / 2.0f);
                }
            } else if (this.m_20096_()) {
                this.doJump(newYMovement, newForwardMovement);
            }
            this.playerJumpPendingScale = 0.0f;
        }
        if (this.m_6109_()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            Vec3 newMovement = new Vec3((double)newStrafeMovement, travelVector.f_82480_, (double)newForwardMovement).m_82490_(0.5);
            if (this.m_20069_()) {
                this.steering.slowWaterTravel(newMovement);
            } else {
                super.m_7023_(newMovement);
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
            this.m_267651_(this instanceof FlyingAnimal);
        }
        if (this.m_20096_()) {
            this.playerJumpPendingScale = 0.0f;
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !this.m_21830_((LivingEntity)(player = (Player)passenger)) || this.m_5448_() == passenger) continue;
            return player;
        }
        return null;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.WALK_AND_GLIDE || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.FLIGHT) {
            return false;
        }
        return super.m_142535_(distance, damageMultiplier, source);
    }

    public double m_20204_() {
        if (this.useLowerFluidJumpThreshold) {
            return super.m_20204_();
        }
        return 0.7 * (double)this.m_20206_();
    }

    private void setUseLowerFluidJumpThreshold(boolean b) {
        this.useLowerFluidJumpThreshold = b;
    }

    public void m_6858_(boolean sprinting) {
        super.m_6858_(sprinting);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22111_(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D")) != null) {
            attributeInstance.m_22120_(UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D"));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20069_() && this.f_19862_) {
            this.setUseLowerFluidJumpThreshold(true);
        }
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        if (this.getRidingPlayer() != null) {
            this.m_274367_(1.0f);
        } else {
            this.m_274367_(0.6f);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.synTime > 0L && this.synTime >= this.f_19853_.m_46467_()) {
                this.synTime = -1L;
                ((SyncedEntityDataHelper)this.m_20088_()).fossilsArcheologyRevival$markNonDefaultAsDirty();
            }
            this.m_6858_(this.m_20184_().m_165924_() > 0.1 && this.m_21566_().m_24999_() >= this.attributes().sprintMod());
            if (this.getHunger() > this.getMaxHunger()) {
                this.setHunger(this.getMaxHunger());
            }
            if (this.getMatingCooldown() > 0) {
                this.setMatingCooldown(this.getMatingCooldown() - 1);
            }
            if (FossilConfig.isEnabled("healingDinos") && this.f_19796_.m_188503_(500) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (Version.debugEnabled()) {
                MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((ServerLevel)this.f_19853_).m_8795_(serverPlayer -> serverPlayer.m_20270_((Entity)this) < 16.0f), (Object)new SyncDebugInfoMessage(this.m_19879_(), this.getGender().name(), this.m_146764_(), this.matingCooldown, this.moodSystem.getPlayingCooldown(), this.climbingCooldown, this.getHunger(), this.moodSystem.getMood()));
            }
            this.aiSystems.forEach(AISystem::serverTick);
            if (this.f_19862_ && this.data().breaksBlocks() && this.moodSystem.getMood() < 0) {
                this.breakBlock((float)FossilConfig.getDouble("blockBreakHardness"));
            }
            if (this.isFleeing()) {
                ++this.fleeTicks;
                if (this.fleeTicks > this.getFleeingCooldown()) {
                    this.setFleeing(false);
                    this.fleeTicks = 0;
                }
            }
        } else {
            this.aiSystems.forEach(AISystem::clientTick);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.prevClimbTick = this.climbTick;
            this.climbTick = this.isClimbing() ? Math.min(5, this.climbTick + 1) : Math.max(0, this.climbTick - 1);
        } else {
            if (!this.isAgingDisabled() && this.canAgeUpNaturally()) {
                this.setAgeInTicks(this.m_146764_() + 1);
            }
            if (this.f_19797_ % 1200 == 0 && this.getHunger() > 0 && FossilConfig.isEnabled("enableHunger")) {
                if (!this.m_21525_()) {
                    this.setHunger(this.getHunger() - 1);
                } else {
                    this.setHunger(this.getMaxHunger());
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.f_19797_ % 40 == 0 && this.getHunger() == 0) {
                float f = this.m_21223_();
                float f2 = FossilConfig.isEnabled("enableStarvation") ? 0.0f : this.m_21233_() / 2.0f;
                if (f > f2) {
                    this.m_6469_(this.f_19853_.m_269111_().m_269064_(), 1.0f);
                }
            }
            if (this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD) {
                if (this.isClimbing()) {
                    boolean onCooldown;
                    ++this.ticksClimbing;
                    boolean bl = onCooldown = this.ticksClimbing >= 100 || this.f_19853_.m_8055_(this.m_20183_().m_7494_()).m_60767_().m_76333_();
                    if (!this.f_19862_ || onCooldown) {
                        this.stopClimbing();
                        this.ticksClimbing = 0;
                        if (onCooldown) {
                            this.climbingCooldown = 900;
                        }
                    } else {
                        Pair<Direction, Double> dir = Util.getClosestSide(this.m_20191_(), this.m_20183_());
                        this.f_19804_.m_135381_(CLIMBING_DIR, (Object)((Direction)dir.key()));
                        if (this.m_20184_().m_165924_() < (double)1.0E-5f) {
                            this.m_146922_(((Direction)dir.key()).m_122435_());
                        }
                    }
                } else {
                    --this.climbingCooldown;
                    if (this.canClimb()) {
                        this.ticksClimbing = 0;
                        this.setClimbing(true);
                    }
                }
            }
        }
    }

    protected boolean canClimb() {
        return this.climbingCooldown <= 0 && this.f_19862_ && !this.sleepSystem.wantsToSleep() && !this.m_5803_();
    }

    public void setScaleOverride(float scaleOverride) {
        this.scaleOverride = scaleOverride;
    }

    public float m_6134_() {
        if (this.scaleOverride > 0.0f) {
            return this.scaleOverride;
        }
        if (this.isAdult()) {
            return this.data().maxScale() * this.getGenderedScale();
        }
        float step = (this.data().maxScale() - this.data().minScale()) / (float)(this.data().adultAgeInTicks() + 1);
        return (this.data().minScale() + step * (float)this.m_146764_()) * this.getGenderedScale();
    }

    public float getGenderedScale() {
        return 1.0f;
    }

    public int m_213860_() {
        float base = 6.0f * this.m_20205_() * (float)(this.data().diet() == Diet.HERBIVORE ? 1 : 2) * (float)(this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM ? 2 : 1) * (this.aiAttackType() == PrehistoricEntityInfoAI.Attacking.BASIC ? 1.0f : 1.25f);
        return Mth.m_14143_((float)((float)Math.min(this.data().adultAgeDays(), this.getAgeInDays()) * base));
    }

    public void updateAbilities() {
        float scale = this.data().minScale() + (this.data().maxScale() - this.data().minScale()) / (float)this.data().adultAgeInTicks() * (float)this.m_146764_();
        scale = Math.min(scale, this.data().maxScale());
        double percent = Math.min((double)this.m_146764_() / (double)this.data().adultAgeInTicks(), 1.0);
        this.m_21051_(Attributes.f_22278_).m_22100_(Mth.m_14139_((double)percent, (double)this.attributes().baseKnockBackResistance(), (double)this.attributes().maxKnockBackResistance()));
        double speed = Util.calculateSpeed(this.data(), scale, false);
        double healthDifference = this.m_21133_(Attributes.f_22276_);
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Math.round(Mth.m_14139_((double)percent, (double)this.attributes().baseHealth(), (double)this.attributes().maxHealth())));
        healthDifference = this.m_21133_(Attributes.f_22276_) - healthDifference;
        if (healthDifference > 0.0) {
            this.m_5634_((float)healthDifference);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Math.round(Mth.m_14139_((double)percent, (double)this.attributes().baseDamage(), (double)this.attributes().maxDamage())));
        this.m_21051_(Attributes.f_22279_).m_22100_(speed);
        this.swimSpeed = Util.calculateSpeed(this.data(), scale, true);
        this.m_21051_(Attributes.f_22284_).m_22100_(Mth.m_14139_((double)percent, (double)this.attributes().baseArmor(), (double)this.attributes().maxArmor()));
    }

    public void breakBlock(float maxHardness) {
        if (!FossilConfig.isEnabled("dinosBreakBlocks") || !this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        if (!this.isAdult() || !this.isHungry()) {
            return;
        }
        AABB aabb = this.m_20191_().m_82377_(0.1, 0.0, 0.1);
        boolean waterMob = this instanceof PrehistoricSwimming;
        int lowest = Mth.m_14107_((double)aabb.f_82289_) + (waterMob ? 0 : 1);
        for (BlockPos targetPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)lowest, (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14165_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            if (!Util.canBreak(this.f_19853_, targetPos, maxHardness)) continue;
            this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            this.f_19853_.m_46953_(targetPos, this.f_19796_.m_188503_(10) == 0, (Entity)this);
            if (!waterMob || targetPos.m_123342_() != lowest || !this.m_20069_()) continue;
            this.f_19853_.m_7731_(targetPos, Blocks.f_49990_.m_49966_(), 3);
        }
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void m_5802_(BlockPos pos) {
    }

    public void m_5796_() {
    }

    public boolean m_6147_() {
        return this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD && this.isClimbing();
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.f_19804_.m_135381_(CLIMBING, (Object)climbing);
    }

    public void stopClimbing() {
        this.setClimbing(false);
        this.f_19804_.m_135381_(CLIMBING_DIR, (Object)Direction.UP);
    }

    public Direction getClimbingDirection() {
        return (Direction)this.f_19804_.m_135370_(CLIMBING_DIR);
    }

    public boolean isFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public void setFleeing(boolean fleeing) {
        this.f_19804_.m_135381_(FLEEING, (Object)fleeing);
    }

    protected int getFleeingCooldown() {
        if (this.m_21188_() != null) {
            int i = (int)(Math.max(this.m_21188_().m_20205_() / 2.0f, 1.0f) * 95.0f);
            int j = (int)(Math.min((double)(this.m_20205_() / 2.0f), 0.5) * 50.0);
            return i - j;
        }
        return 100;
    }

    public boolean isAdult() {
        return this.getAgeInDays() >= this.data().adultAgeDays();
    }

    public boolean isTeen() {
        return this.getAgeInDays() >= this.data().teenAgeDays() && this.getAgeInDays() < this.data().adultAgeDays();
    }

    public boolean m_6162_() {
        return this.getAgeInDays() < this.data().teenAgeDays();
    }

    public int getAgeInDays() {
        return this.m_146764_() / 24000;
    }

    public void setAgeInDays(int days) {
        this.setAgeInTicks(days * 24000);
    }

    public int m_146764_() {
        return this.f_19853_.f_46443_ ? (Integer)this.f_19804_.m_135370_(AGE_TICK) : this.f_146733_;
    }

    public void m_146762_(int age) {
    }

    public void setAgeInTicks(int age) {
        if (this.isAgingDisabled()) {
            return;
        }
        if (this.f_19797_ % 120 == 0 || age > this.f_146733_ + 120 || age < this.f_146733_ - 120) {
            this.f_146733_ = age;
            this.f_19804_.m_135381_(AGE_TICK, (Object)age);
        } else {
            this.f_146733_ = age;
        }
    }

    public void grow(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.updateAbilities();
        this.f_19853_.m_7605_((Entity)this, (byte)66);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.f_19804_.m_135370_(AGING_DISABLED);
    }

    protected boolean canAgeUpNaturally() {
        return true;
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.f_19804_.m_135381_(AGING_DISABLED, (Object)isAgingDisabled);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this || otherAnimal.getClass() != this.getClass() || this.moodSystem.getMood() <= 50 || !this.isAdult() || this.getMatingCooldown() > 0) {
            return false;
        }
        Prehistoric other = (Prehistoric)otherAnimal;
        return other.getGender() != this.getGender() && other.isAdult() && other.getMatingCooldown() <= 0 && other.moodSystem.getMood() > 50 && (this.matingGoal.getPartner() == null || this.matingGoal.getPartner() == otherAnimal);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        Entity baby;
        if (otherParent instanceof Prehistoric && (baby = this.info().entityType().m_20615_(this.f_19853_)) instanceof Prehistoric) {
            Prehistoric prehistoricBaby = (Prehistoric)baby;
            prehistoricBaby.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.BREEDING, new PrehistoricGroupData(0), null);
            prehistoricBaby.grow(0);
            return prehistoricBaby;
        }
        return null;
    }

    public void procreate(Prehistoric other) {
        if (this.getGender() == Gender.MALE) {
            this.m_6710_(null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (this.f_19796_.m_188503_(100) == 0 || calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
            this.m_5496_((SoundEvent)ModSounds.MUSIC_MATING.get(), 1.0f, 1.0f);
        }
        if (!this.f_19853_.f_46443_) {
            Entity hatchling;
            if (this.info().mobType == PrehistoricMobType.MAMMAL) {
                hatchling = this.m_6095_().m_20615_(this.f_19853_);
            } else if (this.info().birdEggItem != null) {
                hatchling = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.info().birdEggItem));
            } else if (FossilConfig.isEnabled("eggsLikeChickens") || this.info().isViviparousAquatic()) {
                hatchling = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.info().eggItem));
            } else {
                hatchling = ((EntityType)ModEntities.DINOSAUR_EGG.get()).m_20615_(this.f_19853_);
                ((DinosaurEgg)hatchling).setPrehistoricEntityInfo(this.info());
                LivingEntity livingEntity = this.m_269323_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    Advancement adv = ((ServerLevel)this.f_19853_).m_7654_().m_129889_().m_136041_(DinosaurEgg.GOLDEN_EGG_ADV);
                    if (adv != null && player.m_8960_().m_135996_(adv).m_8193_()) {
                        ((DinosaurEgg)hatchling).setGoldenEgg((double)this.f_19796_.m_188501_() < 0.05);
                    }
                }
            }
            this.m_6710_(null);
            hatchling.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_20883_, 0.0f);
            if (hatchling instanceof Prehistoric) {
                Prehistoric prehistoricHatchling = (Prehistoric)hatchling;
                prehistoricHatchling.m_6518_((ServerLevelAccessor)this.f_19853_, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.BREEDING, new PrehistoricGroupData(0), null);
                prehistoricHatchling.grow(0);
            }
            this.f_19853_.m_7967_(hatchling);
        }
    }

    public int getMatingCooldown() {
        return this.matingCooldown;
    }

    public void setMatingCooldown(int cooldown) {
        this.matingCooldown = cooldown;
    }

    public Gender getGender() {
        return Gender.values()[(Byte)this.f_19804_.m_135370_(GENDER)];
    }

    public void setGender(@NotNull Gender gender) {
        this.f_19804_.m_135381_(GENDER, (Object)((byte)gender.ordinal()));
    }

    public String getVariantId() {
        return (String)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    private void setVariantId(@NotNull String variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant);
    }

    private void clearVariant(VariantRegistry.RegistryObject<?> type) {
        if (this.allVariants.containsKey(type)) {
            String removedVariant = this.allVariants.get(type).variant().getVariantId();
            if (((String)this.f_19804_.m_135370_(DATA_VARIANT)).equals(removedVariant)) {
                this.f_19804_.m_135381_(DATA_VARIANT, (Object)"");
            }
        }
        this.allVariants.remove(type);
        VariantRegistry.getHighestPriority(this.allVariants).ifPresent(variant -> this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getVariantId()));
    }

    private <T extends VariantCondition> void setVariant(VariantRegistry.RegistryObject<?> type, @NotNull VariantCondition.WithVariant<T> pair) {
        this.allVariants.put(type, pair);
        VariantRegistry.getHighestPriority(this.allVariants).ifPresent(variant -> this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getVariantId()));
    }

    public int getClimbingCooldown() {
        return this.climbingCooldown;
    }

    public void setClimbingCooldown(int cooldown) {
        this.climbingCooldown = cooldown;
    }

    public boolean isWeak() {
        return (this.aiTameType() == PrehistoricEntityInfoAI.Taming.AQUATIC_GEM || this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM) && this.m_21223_() < 8.0f && this.isAdult() && !this.m_21824_();
    }

    public int getMaxHunger() {
        return this.data().maxHunger();
    }

    public boolean isHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.75f;
    }

    public boolean isDeadlyHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.25f;
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)Math.min(hunger, this.getMaxHunger()));
    }

    public boolean eatItem(ItemStack stack) {
        if (stack != null && FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), this.data().diet()) != 0) {
            this.moodSystem.increaseMood(5);
            this.feed(FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), this.data().diet()));
            stack.m_41774_(1);
            this.animationLogic.triggerAnimation("Movement/Idle", this.getAnimation(AnimationCategory.EAT), AnimationCategory.EAT);
            return true;
        }
        return false;
    }

    public void feed(int foodAmount) {
        this.setHunger(this.getHunger() + foodAmount);
    }

    public boolean m_214076_(ServerLevel level, LivingEntity killedEntity) {
        if (super.m_214076_(level, killedEntity)) {
            if (this.data().diet() != Diet.HERBIVORE) {
                this.feed(FoodMappings.getMobFoodPoints(killedEntity, this.data().diet()));
                this.m_5634_((float)FoodMappings.getMobFoodPoints(killedEntity, this.data().diet()) / 10.0f);
                this.moodSystem.increaseMood(25);
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.f_19853_.m_269111_().m_269318_()) {
            return false;
        }
        boolean hurt = super.m_6469_(source, amount);
        if (hurt) {
            LivingEntity livingEntity = this.m_21188_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.m_269323_() == player && this.moodSystem.getMoodFace() == PrehistoricMoodType.SAD) {
                    this.m_21816_(null);
                    this.m_7105_(false);
                    this.moodSystem.increaseMood(-15);
                    player.m_5661_((Component)Component.m_237110_((String)"entity.fossil.situation.betrayed", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
            if (amount > 0.0f) {
                this.sleepSystem.setSleeping(false);
            }
            if (source.m_7639_() != null) {
                this.moodSystem.increaseMood(-5);
            }
        }
        return hurt;
    }

    protected void m_5849_() {
        if (!this.m_21824_()) {
            this.setCurrentOrder(OrderType.WANDER);
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (this.isWeak() && (this.aiTameType() == PrehistoricEntityInfoAI.Taming.GEM && stack.m_150930_((Item)ModItems.SCARAB_GEM.get()) || this.aiTameType() == PrehistoricEntityInfoAI.Taming.AQUATIC_GEM && stack.m_150930_((Item)ModItems.AQUATIC_SCARAB_GEM.get()))) {
            if (!this.f_19853_.f_46443_) {
                ModTriggers.SCARAB_TAME_TRIGGER.trigger((ServerPlayer)player);
                this.m_5634_(200.0f);
                this.moodSystem.setMood(100);
                this.feed(500);
                this.m_21573_().m_26573_();
                this.m_6710_(null);
                this.m_6703_(null);
                this.m_21828_(player);
                this.f_19853_.m_7605_((Entity)this, (byte)35);
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (stack.m_150930_((Item)ModItems.CHICKEN_ESSENCE.get()) && this.aiTameType() != PrehistoricEntityInfoAI.Taming.GEM && this.aiTameType() != PrehistoricEntityInfoAI.Taming.AQUATIC_GEM) {
            if (!this.f_19853_.f_46443_) {
                if (this.isAdult()) {
                    player.m_5661_((Component)Component.m_237115_((String)"prehistoric.essence_fail_adult"), true);
                    return InteractionResult.PASS;
                }
                if (this.isDeadlyHungry()) {
                    player.m_5661_((Component)Component.m_237115_((String)"prehistoric.essence_fail_hungry"), true);
                    return InteractionResult.PASS;
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    player.m_36356_(new ItemStack((ItemLike)Items.f_42590_, 1));
                }
                this.grow(1);
                this.setHunger(1 + this.f_19796_.m_188503_(this.getHunger()));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (stack.m_150930_((Item)ModItems.STUNTED_ESSENCE.get()) && !this.isAgingDisabled()) {
            if (!this.f_19853_.f_46443_) {
                this.setHunger(this.getHunger() + 20);
                this.m_5634_(this.m_21233_());
                this.setAgingDisabled(true);
                stack.m_41774_(1);
                this.m_5496_(SoundEvents.f_12644_, this.m_6121_(), this.m_6100_());
            } else {
                AABB aabb = this.eatPos == null ? this.m_6921_() : new AABB(this.eatPos, this.eatPos);
                Util.spawnItemParticles(this.f_19853_, stack.m_41720_(), 15, aabb);
                Util.spawnItemParticles(this.f_19853_, stack.m_41720_(), 15, aabb);
                Util.spawnItemParticles(this.f_19853_, Items.f_42675_, 15, aabb);
                Util.spawnItemParticles(this.f_19853_, Items.f_42675_, 15, aabb);
                Util.spawnItemParticles(this.f_19853_, Items.f_42521_, 15, aabb);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), this.data().diet()) > 0) {
            if (this.getHunger() < this.getMaxHunger() || this.m_21223_() < this.m_21233_() && FossilConfig.isEnabled("healingDinos") || !this.m_21824_() && this.aiTameType() == PrehistoricEntityInfoAI.Taming.FEEDING) {
                if (!this.f_19853_.f_46443_ && this.eatItem(stack)) {
                    if (FossilConfig.isEnabled("healingDinos")) {
                        this.m_5634_(3.0f);
                    }
                    if (this.getHunger() >= this.getMaxHunger() && this.m_21824_()) {
                        player.m_5661_((Component)Component.m_237110_((String)"entity.fossil.situation.full", (Object[])new Object[]{this.m_7755_()}), true);
                    }
                    if (this.aiTameType() == PrehistoricEntityInfoAI.Taming.FEEDING && !this.m_21824_() && this.f_19796_.m_188503_(10) == 1) {
                        this.m_21828_(player);
                        this.f_19853_.m_7605_((Entity)this, (byte)35);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        } else {
            if (stack.m_150930_((Item)ModItems.WHIP.get()) && this.aiTameType() != PrehistoricEntityInfoAI.Taming.NONE && this.isAdult()) {
                if (this.m_21830_((LivingEntity)player) && this.data().canBeRidden()) {
                    if (!this.f_19853_.f_46443_ && this.getRidingPlayer() == null) {
                        player.f_20883_ = this.f_20883_;
                        player.m_146926_(this.m_146909_());
                        player.m_20329_((Entity)this);
                        this.sitSystem.setSitting(false);
                        this.sleepSystem.setSleeping(false);
                        this.setCurrentOrder(OrderType.WANDER);
                    } else if (this.getRidingPlayer() == player) {
                        this.m_6858_(true);
                        this.moodSystem.increaseMood(-5);
                    }
                } else if (FossilConfig.isEnabled("whipToTameDino") && !this.m_21824_() && this.aiTameType() != PrehistoricEntityInfoAI.Taming.AQUATIC_GEM && this.aiTameType() != PrehistoricEntityInfoAI.Taming.GEM && !this.f_19853_.f_46443_) {
                    this.moodSystem.increaseMood(-5);
                    if (this.f_19796_.m_188503_(5) == 0) {
                        player.m_5661_((Component)Component.m_237110_((String)"entity.fossil.prehistoric.tamed", (Object[])new Object[]{this.info().displayName.get()}), true);
                        this.moodSystem.increaseMood(-25);
                        this.m_21828_(player);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (stack.m_150930_(this.getOrderItem()) && this.m_21830_((LivingEntity)player) && !player.m_20159_()) {
                if (!this.f_19853_.f_46443_) {
                    this.f_20899_ = false;
                    this.m_21573_().m_26573_();
                    this.setCurrentOrder(OrderType.values()[(this.currentOrder.ordinal() + 1) % 3]);
                    this.sendOrderMessage(this.currentOrder);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private void sendOrderMessage(OrderType orderType) {
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_5661_((Component)Component.m_237110_((String)("entity.fossil.order." + orderType.name().toLowerCase(Locale.ROOT)), (Object[])new Object[]{this.m_7755_()}), true);
        }
    }

    protected boolean hasTeenTexture() {
        return OptionalTextureLoader.INSTANCE.hasTeenTexture(this.info().resourceName);
    }

    public void refreshTexturePath() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        String name = this.m_6095_().arch$registryName().m_135815_();
        StringBuilder builder = new StringBuilder();
        builder.append("textures/entity/");
        builder.append(name);
        builder.append("/");
        builder.append(name);
        String variantId = this.getVariantId();
        if (!variantId.isBlank() && this.variants().containsKey(variantId)) {
            this.variants().get(variantId).appendTextureString(builder, this);
        } else {
            if (this.m_6162_()) {
                builder.append("_baby");
            }
            if (this.hasTeenTexture() && this.isTeen()) {
                builder.append("_teen");
            }
            if (!this.hasTeenTexture() && this.isTeen() || this.isAdult()) {
                if (this.getGender() == Gender.MALE) {
                    builder.append("_male");
                } else {
                    builder.append("_female");
                }
            }
        }
        if (this.m_5803_() || this.isWeak()) {
            builder.append("_sleeping");
        }
        builder.append(".png");
        this.textureLocation = FossilMod.location(builder.toString());
    }

    public boolean m_6779_(LivingEntity target) {
        TamableAnimal tamableAnimal;
        if (this.m_21830_(target) && this.moodSystem.getMoodFace() != PrehistoricMoodType.ANGRY) {
            return false;
        }
        if (target instanceof Player && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (this.m_21824_() && target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_269323_() == this.m_269323_()) {
            return false;
        }
        return target.m_142066_();
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        return !(target instanceof AbstractHorse) || !((AbstractHorse)target).m_30614_();
    }

    public float getTargetScale() {
        return 1.0f;
    }

    @NotNull
    protected PathNavigation m_6037_(Level levelIn) {
        return this.aiClimbType() == PrehistoricEntityInfoAI.Climbing.ARTHROPOD ? new PrehistoricWallClimberNavigation(this, levelIn) : new PrehistoricPathNavigation(this, levelIn);
    }

    @NotNull
    protected SleepSystem createSleepSystem() {
        return new SleepSystem(this);
    }

    protected <T extends AISystem> T registerSystem(T system) {
        this.aiSystems.add(system);
        return system;
    }

    public List<? extends Prehistoric> getNearbySpeciesMembers(int range) {
        return this.f_19853_.m_6443_(this.getClass(), this.m_20191_().m_82377_((double)range, 4.0, (double)range), prehistoric -> prehistoric != this);
    }

    public void m_8032_() {
        if (this.m_5803_() || this.f_19853_.f_46443_) {
            return;
        }
        if (this.m_5842_()) {
            SoundEvent soundEvent = this.m_7515_();
            if (soundEvent != null) {
                float volume = this.m_6121_();
                double radius = volume > 1.0f ? (double)(16.0f * volume) : 16.0;
                ClientboundSoundPacket packet = new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)soundEvent), this.m_5720_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), volume, this.m_6100_(), this.f_19853_.f_220348_.m_188505_());
                for (ServerPlayer player : ((ServerLevel)this.f_19853_).m_7654_().m_6846_().m_11314_()) {
                    double f;
                    double e;
                    double d;
                    if (!player.m_5842_() || player.f_19853_.m_46472_() != this.f_19853_.m_46472_() || !((d = this.m_20185_() - player.m_20185_()) * d + (e = this.m_20186_() - player.m_20186_()) * e + (f = this.m_20189_() - player.m_20189_()) * f < radius * radius)) continue;
                    player.f_8906_.m_9829_((Packet)packet);
                }
            }
        } else {
            super.m_8032_();
        }
    }

    public int m_8100_() {
        return 200;
    }

    protected float m_6121_() {
        return this.m_6162_() ? super.m_6121_() * 0.375f : 0.5f;
    }

    public ServerAnimationInfo startAttack() {
        ServerAnimationInfo attackAnim = (ServerAnimationInfo)this.nextAttackAnimation();
        this.getAnimationLogic().triggerAnimation("Attack", attackAnim, AnimationCategory.ATTACK);
        return attackAnim;
    }

    public boolean attackTarget(LivingEntity target) {
        if (this.m_20205_() > target.m_20205_()) {
            double resistance = 1.0 - target.m_21133_(Attributes.f_22278_);
            target.m_20256_(target.m_20184_().m_82520_(0.0, 0.4 * resistance + 0.1, 0.0));
        }
        return this.m_7327_((Entity)target);
    }

    public boolean m_7327_(Entity target) {
        boolean wasEffective = super.m_7327_(target);
        if (wasEffective && target instanceof Prehistoric) {
            Prehistoric other = (Prehistoric)target;
            if (other.m_21223_() <= other.m_21233_() / 2.0f) {
                other.setFleeing(other.m_21133_(Attributes.f_22281_) < this.m_21133_(Attributes.f_22281_) * 0.8);
            } else if (other.m_21133_(Attributes.f_22281_) < this.m_21133_(Attributes.f_22281_) * 0.5) {
                other.setFleeing(true);
            }
        }
        return wasEffective;
    }

    public void m_7822_(byte id) {
        float prev = this.f_267362_.m_267731_();
        if (id == 62) {
            Util.spawnItemParticles((Entity)this, Items.f_42404_, 3);
        } else if (id == 63) {
            Util.spawnItemParticles((Entity)this, Items.f_42406_, 3);
        } else if (id == 64) {
            Util.spawnItemParticles((Entity)this, Items.f_42406_, 3);
            Util.spawnItemParticles((Entity)this, Items.f_42579_, 3);
        } else if (id == 65) {
            Util.spawnParticles((Entity)this, (ParticleOptions)ParticleTypes.f_123748_, 6);
        } else if (id == 66) {
            Util.spawnParticles((Entity)this, (ParticleOptions)ParticleTypes.f_123748_, this.getAgeInDays());
        } else {
            super.m_7822_(id);
        }
        if (prev != this.f_267362_.m_267731_() && this.m_21133_(Attributes.f_22278_) >= 1.0) {
            this.f_267362_.m_267771_(0.0f);
        }
    }

    private void makeEatingSounds() {
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, this.m_5720_(), this.m_6121_(), this.m_6100_(), false);
    }

    public float getMaxTurnDistancePerTick() {
        return Mth.m_14036_((float)(90.0f - this.m_20205_() * 35.0f), (float)5.0f, (float)90.0f);
    }

    public float getProximityToNextPathSkip() {
        return this.m_20205_() > 0.75f ? this.m_20205_() / 2.0f : 0.75f - this.m_20205_() / 2.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        if (Platform.isFabric()) {
            this.synTime = this.f_19853_.m_46467_() + 20L;
        }
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public abstract PrehistoricEntityInfo info();

    public abstract Item getOrderItem();

    public Map<String, Variant> variants() {
        return EntityVariantLoader.INSTANCE.getVariants(this.info().resourceName);
    }

    public <T extends VariantCondition> List<VariantCondition.WithVariant<T>> variantsByCondition(Class<T> clazz) {
        return EntityVariantLoader.INSTANCE.getVariantsByCondition(clazz, this.info().resourceName);
    }

    public EntityDataLoader.Data data() {
        return this.info().data();
    }

    public Attribute attributes() {
        return this.data().attributes();
    }

    private AI ai() {
        return this.data().ai();
    }

    public PrehistoricEntityInfoAI.Activity aiActivityType() {
        return this.ai().activity();
    }

    public PrehistoricEntityInfoAI.Attacking aiAttackType() {
        return this.ai().attacking();
    }

    public PrehistoricEntityInfoAI.Climbing aiClimbType() {
        return this.ai().climbing();
    }

    public PrehistoricEntityInfoAI.Response aiResponseType() {
        if (this.m_6162_() || this.isFleeing()) {
            return PrehistoricEntityInfoAI.Response.SCARED;
        }
        return this.ai().response();
    }

    public PrehistoricEntityInfoAI.Taming aiTameType() {
        return this.ai().taming();
    }

    public PrehistoricEntityInfoAI.Moving aiMovingType() {
        return this.ai().moving();
    }

    @Override
    public Map<AnimationCategory, AnimationHolder> getAnimations() {
        if (this.f_19853_.f_46443_) {
            return AnimationCategoryLoader.CLIENT.getAnimations(this.animationLocation);
        }
        return AnimationCategoryLoader.SERVER.getAnimations(this.animationLocation);
    }

    @Override
    public Map<String, ? extends AnimationInfo> getAllAnimations() {
        if (this.f_19853_.f_46443_) {
            return ClientAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
        }
        return this.getServerAnimationInfos();
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        return this.getRandomAnimation(category);
    }

    @Override
    public Map<String, ServerAnimationInfo> getServerAnimationInfos() {
        return ServerAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
    }

    @NotNull
    public AnimationInfo nextAttackAnimation() {
        return this.getAnimation(AnimationCategory.ATTACK);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<Prehistoric> controller = new PausableAnimationController<Prehistoric>(this, "Movement/Idle", 5, this.animationLogic::landPredicate);
        this.registerEatingListeners(controller);
        this.registerControllerWithTriggers(controllerRegistrar, controller);
        PausableAnimationController<Prehistoric> attackController = new PausableAnimationController<Prehistoric>(this, "Attack", 5, this.animationLogic::attackPredicate);
        this.registerControllerWithTriggers(controllerRegistrar, attackController);
    }

    protected void registerControllerWithTriggers(AnimatableManager.ControllerRegistrar controllerRegistrar, AnimationController<? extends Prehistoric> controller) {
        AnimationCategory.CATEGORIES.forEach(category -> this.getAnimations().get(category).addTriggers(controller));
        controllerRegistrar.add(new AnimationController[]{controller});
    }

    protected void registerEatingListeners(AnimationController<? extends Prehistoric> controller, Consumer<String> additional) {
        controller.setParticleKeyframeHandler(event -> {
            if ("eat".equals(event.getKeyframeData().getEffect())) {
                AABB aabb = this.eatPos == null ? this.m_6921_() : new AABB(this.eatPos, this.eatPos);
                switch (this.data().diet()) {
                    case HERBIVORE: {
                        Util.spawnItemParticles(this.f_19853_, Items.f_42404_, 4, aabb);
                        break;
                    }
                    case OMNIVORE: {
                        Util.spawnItemParticles(this.f_19853_, Items.f_42780_, 4, aabb);
                        break;
                    }
                    case PISCIVORE: {
                        Util.spawnItemParticles(this.f_19853_, Items.f_42526_, 4, aabb);
                        break;
                    }
                    case PASSIVE: {
                        Util.spawnItemParticles(this.f_19853_, Items.f_42403_, 4, aabb);
                        break;
                    }
                    default: {
                        Util.spawnItemParticles(this.f_19853_, Items.f_42579_, 4, aabb);
                    }
                }
            }
            additional.accept(event.getKeyframeData().getEffect());
        });
        controller.setSoundKeyframeHandler(event -> {
            if ("eat".equals(event.getKeyframeData().getSound())) {
                this.makeEatingSounds();
            }
            if ("call".equals(event.getKeyframeData().getSound())) {
                this.m_8032_();
            }
        });
    }

    protected void registerEatingListeners(AnimationController<? extends Prehistoric> controller) {
        this.registerEatingListeners(controller, effect -> {});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    public InstructionSystem getInstructionSystem() {
        return this.instructionSystem;
    }

    @Override
    public CompoundTag getDebugTag() {
        return (CompoundTag)this.f_19804_.m_135370_(DEBUG);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        if (!Version.debugEnabled()) {
            return;
        }
        CompoundTag tag = ((CompoundTag)this.f_19804_.m_135370_(DEBUG)).m_6426_();
        switch (type) {
            case 0: {
                this.m_21557_(disableAI);
                break;
            }
            case 1: {
                tag.m_128379_("disableGoalAI", disableAI);
                break;
            }
            case 2: {
                tag.m_128379_("disableMoveAI", disableAI);
                break;
            }
            case 3: {
                tag.m_128379_("disableLookAI", disableAI);
            }
        }
        this.f_19804_.m_135381_(DEBUG, (Object)tag);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 5) {
                MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)serverLevel.m_8795_(serverPlayer -> serverPlayer.m_20270_((Entity)this) < 32.0f), (Object)new C2SDisableAIMessage(this.m_19879_(), disableAI, type));
            }
        }
    }

    public record PrehistoricGroupData(int ageInDays) implements SpawnGroupData
    {
    }
}

