/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricDebug;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class PrehistoricFish
extends AbstractFish
implements PrehistoricAnimatable<PrehistoricFish>,
PrehistoricDebug {
    public static final EntityDataAccessor<CompoundTag> DEBUG = SynchedEntityData.m_135353_(PrehistoricFish.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.m_135353_(PrehistoricFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ResourceLocation animationLocation;
    private final AnimationLogic<PrehistoricFish> animationLogic = new AnimationLogic<PrehistoricFish>(this);
    private int absoluteEggCooldown = this.f_19796_.m_188503_(12000) + 12000;
    private int age;

    protected PrehistoricFish(EntityType<? extends PrehistoricFish> entityType, Level level) {
        super(entityType, level);
        this.animationLocation = FossilMod.location("animations/entity/" + EntityType.m_20613_(entityType).m_135815_() + ".animation.json");
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean canSpawn(EntityType<? extends PrehistoricFish> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return pos.m_123342_() < level.m_5736_() && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BABY, (Object)false);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("disableGoalAI", false);
        tag.m_128379_("disableMoveAI", false);
        tag.m_128379_("disableLookAI", false);
        this.f_19804_.m_135372_(DEBUG, (Object)tag);
    }

    @NotNull
    public abstract PrehistoricEntityInfo info();

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AbsoluteEggCooldown", this.absoluteEggCooldown);
        compound.m_128405_("Age", this.age);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.absoluteEggCooldown = compound.m_128451_("AbsoluteEggCooldown");
        this.setAge(compound.m_128451_("Age"));
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)this.info().bucketItem);
    }

    public void m_6872_(ItemStack bucket) {
        super.m_6872_(bucket);
        CompoundTag tag = bucket.m_41784_();
        tag.m_128405_("AbsoluteEggCooldown", this.absoluteEggCooldown);
        tag.m_128405_("Age", this.age);
    }

    public void m_142278_(CompoundTag tag) {
        super.m_142278_(tag);
        if (tag.m_128441_("AbsoluteEggCooldown")) {
            this.absoluteEggCooldown = tag.m_128451_("AbsoluteEggCooldown");
        }
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
    }

    @NotNull
    protected SoundEvent m_5699_() {
        return SoundEvents.f_11760_;
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(BABY);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
        this.f_19804_.m_135381_(BABY, (Object)(age < 0 ? 1 : 0));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (BABY.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        this.m_6858_(this.m_21566_().m_24999_() >= 1.25);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            PrehistoricFish closestMate;
            if (this.absoluteEggCooldown > 0) {
                --this.absoluteEggCooldown;
            }
            if (this.m_20069_() && this.getAge() >= 0 && this.absoluteEggCooldown <= 0 && (closestMate = this.getClosestMate()) != null) {
                this.absoluteEggCooldown = 48000 + this.f_19796_.m_188503_(48000);
                closestMate.absoluteEggCooldown = 48000 + this.f_19796_.m_188503_(48000);
                this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)this.info().eggItem)));
            }
        }
    }

    @Nullable
    private PrehistoricFish getClosestMate() {
        List sameTypes = this.f_19853_.m_6443_(this.getClass(), this.m_20191_().m_82377_(2.0, 2.0, 2.0), fish -> fish != this && fish.getAge() >= 0);
        double shortestDistance = Double.MAX_VALUE;
        PrehistoricFish other = null;
        for (PrehistoricFish sameType : sameTypes) {
            if (this.m_20280_((Entity)sameType) > shortestDistance) continue;
            other = sameType;
            shortestDistance = this.m_20280_((Entity)other);
        }
        return other;
    }

    @Override
    public CompoundTag getDebugTag() {
        return (CompoundTag)this.f_19804_.m_135370_(DEBUG);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (spawnData instanceof Prehistoric.PrehistoricGroupData) {
            Prehistoric.PrehistoricGroupData prehistoricGroupData = (Prehistoric.PrehistoricGroupData)spawnData;
            this.setAge(prehistoricGroupData.ageInDays() * 24000);
        } else {
            this.setAge(0);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public Map<AnimationCategory, AnimationHolder> getAnimations() {
        if (this.f_19853_.f_46443_) {
            return AnimationCategoryLoader.CLIENT.getAnimations(this.animationLocation);
        }
        return AnimationCategoryLoader.SERVER.getAnimations(this.animationLocation);
    }

    @Override
    public Map<String, ? extends AnimationInfo> getAllAnimations() {
        if (this.f_19853_.f_46443_) {
            return ClientAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
        }
        return this.getServerAnimationInfos();
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        return this.getRandomAnimation(category);
    }

    @Override
    public Map<String, ServerAnimationInfo> getServerAnimationInfos() {
        return ServerAnimationInfoLoader.INSTANCE.getAnimations(this.animationLocation).animations();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new PausableAnimationController<PrehistoricFish>(this, "Movement/Idle", 4, this.animationLogic::fishPredicate);
        controllerRegistrar.add(animationControllerArray);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public AnimationLogic<PrehistoricFish> getAnimationLogic() {
        return this.animationLogic;
    }

    @NotNull
    public AnimationInfo nextBeachedAnimation() {
        return this.getAnimation(AnimationCategory.BEACHED);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        this.m_21557_(disableAI);
    }
}

