/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoRandomSwimGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EnterWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WaterPlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomSwimMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.MeganeuraFlyingMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MeganeuraAttachSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Meganeura
extends Prehistoric
implements FlyingAnimal,
SwimmingAnimal {
    public static final String ATTACK = "animation.meganeura.attack";
    public static final String IDLE = "animation.meganeura.idle";
    public static final String WALK = "animation.meganeura.walk";
    public static final EntityDataAccessor<Float> ATTACHED_X = SynchedEntityData.m_135353_(Meganeura.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> ATTACHED_Y = SynchedEntityData.m_135353_(Meganeura.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> ATTACHED_Z = SynchedEntityData.m_135353_(Meganeura.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(Meganeura.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final EntityDataAccessor<Boolean> ATTACHED = SynchedEntityData.m_135353_(Meganeura.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final MeganeuraAttachSystem attachSystem = this.registerSystem(new MeganeuraAttachSystem(this));
    private final PathNavigation flightNav = new FlyingPathNavigation((Mob)this, this.f_19853_);
    private final PathNavigation amphibiousNav = new AmphibiousPathNavigation<Meganeura>(this, this.f_19853_);
    private final MoveControl flightMoveControl = new MeganeuraFlyingMoveControl(this);
    private final MoveControl aquaticMoveControl = new CustomSwimMoveControl<Meganeura>(this);
    private final MoveControl landMoveControl = new SmoothTurningMoveControl(this);
    protected boolean isLandNavigator;
    protected boolean isAirNavigator;
    private int timeInWater = 0;
    private int timeOnLand = 0;
    private int dimensionSwitchCooldown = -1;

    public Meganeura(EntityType<Meganeura> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.f_21345_.m_25352_(0, (Goal)new DinoPanicGoal(this, 1.5));
        this.f_21345_.m_25352_(12, (Goal)this.matingGoal);
        this.f_21345_.m_25352_(15, (Goal)new EatFromFeederGoal(this));
        this.f_21345_.m_25352_(16, (Goal)new EatItemEntityGoal(this));
        this.f_21345_.m_25352_(17, new WaterPlayGoal<Meganeura>(this, 1.0));
        this.f_21345_.m_25352_(20, (Goal)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 5.0f, 2.0f, false));
        this.f_21345_.m_25352_(21, new EnterWaterGoal<Meganeura>(this, 1.0f));
        this.f_21345_.m_25352_(22, (Goal)new MeganeuraWanderAndAttachGoal(this));
        this.f_21345_.m_25352_(23, new DinoRandomSwimGoal<Meganeura>(this, 1.0));
        this.f_21345_.m_25352_(25, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DinoOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinoOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinoHurtByTargetGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new HuntingTargetGoal(this));
    }

    @Override
    protected void m_8022_() {
        boolean bl = !this.m_5803_() && !this.attachSystem.isAttached();
        this.f_21345_.m_25360_(Goal.Flag.MOVE, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.JUMP, bl && !this.sitSystem.isSitting());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, bl);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACHED_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACHED_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACHED_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.UP);
        this.f_19804_.m_135372_(ATTACHED, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (ATTACHED_FACE.equals(key)) {
            if (this.attachSystem.getAttachmentFace() == Direction.UP) {
                this.dimensionSwitchCooldown = 20;
            } else {
                this.m_6210_();
            }
        }
        super.m_7350_(key);
    }

    @Override
    @NotNull
    protected SleepSystem createSleepSystem() {
        return new MeganeuraSleepSystem(this);
    }

    @Override
    protected boolean canAgeUpNaturally() {
        if (this.m_20069_() && this.m_6162_() && (this.m_146764_() + 1) / 24000 >= this.data().teenAgeDays()) {
            return false;
        }
        return super.canAgeUpNaturally();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source == this.f_19853_.m_269111_().m_269318_()) {
            return false;
        }
        boolean hurt = super.m_6469_(source, amount);
        if (hurt) {
            this.attachSystem.stopAttaching(1000 + this.f_19796_.m_188503_(1500));
        }
        return hurt;
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.usesAttachHitBox()) {
            return super.m_6972_(poseIn).m_20390_(1.0f, 2.0f);
        }
        return super.m_6972_(poseIn);
    }

    public boolean m_6783_(double distance) {
        double d = this.m_20205_();
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return distance < (d *= 64.0 * Meganeura.m_20150_()) * d;
    }

    @Override
    protected void m_8024_() {
        this.switchNavigator();
        super.m_8024_();
        if (this.m_20069_()) {
            ++this.timeInWater;
            this.timeOnLand = 0;
        } else if (this.f_19861_) {
            this.timeInWater = 0;
            ++this.timeOnLand;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.dimensionSwitchCooldown > 0) {
            --this.dimensionSwitchCooldown;
            if (this.dimensionSwitchCooldown == 0) {
                this.m_6210_();
                this.dimensionSwitchCooldown = -1;
            }
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    @Override
    public boolean m_6094_() {
        return super.m_6094_() && !this.attachSystem.isAttached();
    }

    public boolean m_29443_() {
        return !this.m_20096_() && !this.attachSystem.isAttached();
    }

    private void switchNavigator() {
        if (this.isLandNavigator) {
            if (this.m_6162_()) {
                if (this.m_20069_()) {
                    this.f_21342_ = this.aquaticMoveControl;
                    this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
                    this.f_21344_ = this.amphibiousNav;
                    this.isLandNavigator = false;
                }
            } else {
                this.f_21342_ = this.flightMoveControl;
                this.f_21365_ = new LookControl((Mob)this);
                this.f_21344_ = this.flightNav;
                this.isLandNavigator = false;
                this.isAirNavigator = true;
            }
        } else if (this.isAirNavigator) {
            if (this.m_6162_()) {
                this.f_21342_ = this.landMoveControl;
                this.f_21365_ = new LookControl((Mob)this);
                this.f_21344_ = this.amphibiousNav;
                this.isLandNavigator = true;
                this.isAirNavigator = false;
            }
        } else if (this.m_6162_()) {
            if (!this.m_20069_() && this.m_20096_()) {
                this.f_21342_ = this.landMoveControl;
                this.f_21365_ = new LookControl((Mob)this);
                this.f_21344_ = this.amphibiousNav;
                this.isLandNavigator = true;
            }
        } else {
            this.f_21342_ = this.flightMoveControl;
            this.f_21365_ = new LookControl((Mob)this);
            this.f_21344_ = this.flightNav;
            this.isLandNavigator = false;
            this.isAirNavigator = true;
        }
    }

    public MeganeuraAttachSystem getAttachSystem() {
        return this.attachSystem;
    }

    public boolean usesAttachHitBox() {
        return this.attachSystem == null || this.attachSystem.getAttachmentFace().m_122434_().m_122479_();
    }

    @Override
    public int timeInWater() {
        return this.timeInWater;
    }

    @Override
    public int timeOnLand() {
        return this.timeOnLand;
    }

    public boolean m_6063_() {
        return !this.m_6162_();
    }

    public boolean m_6040_() {
        return this.m_6162_();
    }

    @Override
    public boolean isAmphibious() {
        return this.m_6162_();
    }

    @Override
    public boolean canSwim() {
        return this.m_6162_();
    }

    @Override
    public double swimSpeed() {
        return 1.0;
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.MEGANEURA;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42412_;
    }

    @Override
    public PrehistoricEntityInfoAI.Moving aiMovingType() {
        return this.m_6162_() ? PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC : PrehistoricEntityInfoAI.Moving.FLIGHT;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MEGANEURA_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.MEGANEURA_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MEGANEURA_DEATH.get();
    }

    @Override
    protected float m_6121_() {
        return super.m_6121_() * 0.5f;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationLogic<Prehistoric> animationLogic = this.getAnimationLogic();
        PausableAnimationController<Meganeura> ctrl = new PausableAnimationController<Meganeura>(this, "Movement/Idle", 5, state -> {
            AnimationController controller = state.getController();
            if (animationLogic.tryNextAnimation(state, controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = animationLogic.getActiveAnimation(controller.getName());
            Animation.LoopType loopType = null;
            if (activeAnimation.isPresent() && activeAnimation.get().forced() && !animationLogic.isAnimationDone(controller.getName())) {
                loopType = activeAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE;
            } else if (this.m_5803_()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (this.sitSystem.isSitting()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (state.isMoving()) {
                if (this.m_6162_()) {
                    if (this.m_20069_()) {
                        animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
                    }
                } else if (this.m_20069_()) {
                    animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
                } else if (this.m_29443_()) {
                    animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                }
            } else if (this.m_29443_()) {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
            } else {
                animationLogic.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = animationLogic.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                if (loopType == null) {
                    loopType = newAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE;
                }
                controller.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName(), loopType));
            }
            return PlayState.CONTINUE;
        });
        this.registerEatingListeners(ctrl);
        controllerRegistrar.add(new AnimationController[]{ctrl});
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new PausableAnimationController<Meganeura>(this, "Attack", 0, this.getAnimationLogic()::attackPredicate);
        controllerRegistrar.add(animationControllerArray);
    }

    static class MeganeuraWanderAndAttachGoal
    extends DinoWanderGoal {
        private final Meganeura meganeura;

        public MeganeuraWanderAndAttachGoal(Meganeura meganeura) {
            super(meganeura, 1.0, 10);
            this.meganeura = meganeura;
        }

        @Override
        public boolean m_8036_() {
            if (this.meganeura.m_6162_() || this.meganeura.attachSystem.attachStarted()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        @Nullable
        protected Vec3 m_7037_() {
            if (this.meganeura.attachSystem.getAttachCooldown() == 0) {
                RandomSource random = this.meganeura.f_19796_;
                Level level = this.f_25725_.f_19853_;
                for (int i = 0; i < 5; ++i) {
                    BlockPos blockPos = this.f_25725_.m_20183_().m_7918_(random.m_188503_(16) - 8, random.m_188503_(10) - 2, random.m_188503_(16) - 8);
                    BlockHitResult hitResult = level.m_45547_(new ClipContext(this.f_25725_.m_146892_(), Vec3.m_82512_((Vec3i)blockPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.WATER, (Entity)this.f_25725_));
                    if (hitResult.m_6662_() == HitResult.Type.MISS || hitResult.m_82434_().m_122434_().m_122478_() || !level.m_8055_(hitResult.m_82425_()).m_60783_((BlockGetter)level, hitResult.m_82425_(), hitResult.m_82434_())) continue;
                    this.meganeura.attachSystem.setAttachTarget(hitResult.m_82425_().m_7949_(), hitResult.m_82434_());
                    return Vec3.m_82512_((Vec3i)hitResult.m_82425_());
                }
            }
            Vec3 view = this.f_25725_.m_20252_(0.0f);
            Vec3 pos = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)8, (int)7, (double)view.f_82479_, (double)view.f_82481_, (float)1.5707964f, (int)3, (int)1);
            if (pos != null) {
                return pos;
            }
            return AirAndWaterRandomPos.m_148357_((PathfinderMob)this.f_25725_, (int)8, (int)4, (int)-2, (double)view.f_82479_, (double)view.f_82481_, (double)1.5707963705062866);
        }
    }

    class MeganeuraSleepSystem
    extends SleepSystem {
        public MeganeuraSleepSystem(Meganeura mob) {
            super(mob);
        }

        @Override
        protected boolean canSleep() {
            if (!super.canSleep()) {
                return false;
            }
            if (!Meganeura.this.m_6162_() && !Meganeura.this.attachSystem.isAttached()) {
                if (!Meganeura.this.attachSystem.attachStarted()) {
                    Meganeura.this.attachSystem.setAttachCooldown(0);
                }
                return false;
            }
            return true;
        }
    }
}

