/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class C2SVerticalFlightMessage {
    private static final int STOP = 0;
    private static final int FLY_UP = 1;
    private static final int FLY_DOWN = 2;
    private final int entityId;
    private final int code;

    public static C2SVerticalFlightMessage flyUp(int entityId) {
        return new C2SVerticalFlightMessage(entityId, 1);
    }

    public static C2SVerticalFlightMessage flyDown(int entityId) {
        return new C2SVerticalFlightMessage(entityId, 2);
    }

    public static C2SVerticalFlightMessage stop(int entityId) {
        return new C2SVerticalFlightMessage(entityId, 0);
    }

    public C2SVerticalFlightMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.code = buf.readInt();
    }

    public C2SVerticalFlightMessage(int entityId, int code) {
        this.entityId = entityId;
        this.code = code;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.code);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.CLIENT) {
            return;
        }
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Entity entity = player.f_19853_.m_6815_(this.entityId);
            if (entity instanceof PrehistoricFlying) {
                PrehistoricFlying mob = (PrehistoricFlying)entity;
                LivingEntity rider = entity.m_6688_();
                if (rider != null && rider.m_19879_() == player.m_19879_()) {
                    if (this.code == 1) {
                        mob.setFlyingUp(true);
                        mob.setFlyingDown(false);
                    } else if (this.code == 2) {
                        mob.setFlyingUp(false);
                        mob.setFlyingDown(true);
                    } else if (this.code == 0) {
                        mob.setFlyingUp(false);
                        mob.setFlyingDown(false);
                    }
                }
            }
        });
    }
}

