/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.api;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public record HitboxData(String name, Vec3 pos, float width, float height, String ref, boolean isAttackBox, boolean isAnchor) {
    @ApiStatus.Internal
    public float getFrustumWidthRadius() {
        return (float)Math.max(Math.abs(this.pos.f_82479_) + (double)(this.width / 2.0f), Math.abs(this.pos.f_82481_) + (double)(this.width / 2.0f));
    }

    @ApiStatus.Internal
    public float getFrustumHeight() {
        return (float)this.pos.f_82480_ + this.height;
    }

    @ApiStatus.Internal
    public static HitboxData readBuf(FriendlyByteBuf buf) {
        return new HitboxData(buf.m_130277_(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat(), buf.readFloat(), buf.m_130277_(), buf.readBoolean(), buf.readBoolean());
    }

    @ApiStatus.Internal
    public static void writeBuf(FriendlyByteBuf buf, HitboxData hitbox) {
        buf.m_130070_(hitbox.name);
        buf.writeDouble(hitbox.pos.f_82479_);
        buf.writeDouble(hitbox.pos.f_82480_);
        buf.writeDouble(hitbox.pos.f_82481_);
        buf.writeFloat(hitbox.width);
        buf.writeFloat(hitbox.height);
        buf.m_130070_(hitbox.ref);
        buf.writeBoolean(hitbox.isAttackBox);
        buf.writeBoolean(hitbox.isAnchor);
    }
}

