/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.util;

import com.github.teamfossilsarcheology.fossil.entity.data.Attribute;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.tags.ModBlockTags;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final int IMMOBILE = 0;
    public static final int ATTACK = 5;
    public static final int SLEEP = 10;
    public static final int NEEDS = 15;
    public static final int WANDER = 20;
    public static final int LOOK = 25;
    public static final float SWING_ANIM_THRESHOLD = 0.008f;

    public static void spawnParticles(class_1937 level, class_2394 particleOptions, int count, class_238 aabb) {
        for (int i = 0; i < count; ++i) {
            double motionX = level.method_8409().method_43059() * 0.07;
            double motionY = level.method_8409().method_43059() * 0.07;
            double motionZ = level.method_8409().method_43059() * 0.07;
            float x = (float)((double)level.method_8409().method_43057() * (aabb.field_1320 - aabb.field_1323) + aabb.field_1323);
            float y = (float)((double)level.method_8409().method_43057() * (aabb.field_1325 - aabb.field_1322) + aabb.field_1322);
            float z = (float)((double)level.method_8409().method_43057() * (aabb.field_1324 - aabb.field_1321) + aabb.field_1321);
            level.method_8406(particleOptions, (double)x, (double)y, (double)z, motionX, motionY, motionZ);
        }
    }

    public static void spawnParticles(class_1297 entity, class_2394 particleOptions, int count) {
        Util.spawnParticles(entity.field_6002, particleOptions, count, entity.method_5830());
    }

    public static void spawnItemParticles(class_1297 entity, class_1792 item, int count) {
        Util.spawnItemParticles(entity.field_6002, item, count, entity.method_5830());
    }

    public static void spawnItemParticles(class_1937 level, class_1792 item, int count, class_238 aabb) {
        Util.spawnParticles(level, (class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)item)), count, aabb);
    }

    public static boolean isEntityLargerThan(class_1297 entity, float size) {
        return entity.method_17681() > size;
    }

    public static boolean canBreak(class_1937 level, class_2338 targetPos, float maxHardness) {
        class_2680 state = level.method_8320(targetPos);
        if (state.method_26164(ModBlockTags.UNBREAKABLE) || state.method_26214((class_1922)level, targetPos) >= maxHardness || state.method_26214((class_1922)level, targetPos) < 0.0f) {
            return false;
        }
        return !state.method_26220((class_1922)level, targetPos).method_1110() && state.method_26227().method_15769();
    }

    public static boolean canReachPrey(Prehistoric prehistoric, class_1297 target) {
        return prehistoric.getEntityHitboxData().getAttackBounds().method_994(target.method_5829()) && prehistoric.method_5985().method_6369(target);
    }

    public static boolean canSeeFood(Prehistoric dino, class_2338 position) {
        class_243 target = new class_243((double)position.method_10263() + 0.5, (double)position.method_10264(), (double)position.method_10260() + 0.5);
        class_3959.class_242 fluid = class_3959.class_242.field_1348;
        if (!(dino instanceof SwimmingAnimal)) {
            fluid = class_3959.class_242.field_1347;
        }
        class_3965 rayTrace = dino.method_37908().method_17742(new class_3959(dino.method_33571(), target, class_3959.class_3960.field_17558, fluid, (class_1297)dino));
        return position.equals((Object)rayTrace.method_17777());
    }

    public static double attributeToSpeed(double speed) {
        return 44.23174 * class_3532.method_33723((double)speed) - 0.504912 * speed + 0.0592455;
    }

    public static double attributeToSpeed(double speed, double sprintMod, boolean isSprinting) {
        return Util.attributeToSpeed(isSprinting ? speed * sprintMod : speed);
    }

    public static double calculateSpeed(EntityDataLoader.Data data, float scale, boolean swim) {
        boolean maxBelow1;
        Attribute attributes = data.attributes();
        double baseSpeed = swim ? attributes.baseSwimSpeed() : attributes.baseSpeed();
        double minSpeed = swim ? attributes.minSwimSpeed() : attributes.minSpeed();
        double maxSpeed = swim ? attributes.maxSwimSpeed() : attributes.maxSpeed();
        double newSpeed = baseSpeed;
        boolean minAbove1 = data.minScale() >= 1.0f;
        boolean bl = maxBelow1 = data.maxScale() <= 1.0f;
        if (scale < 1.0f) {
            float max;
            float min = data.minScale();
            float f = max = maxBelow1 ? data.maxScale() : 1.0f;
            if (min != max) {
                newSpeed = class_3532.method_16436((double)((scale - min) / (max - min)), (double)minSpeed, (double)(maxBelow1 ? maxSpeed : baseSpeed));
            }
        } else {
            float min = data.minScale() < 1.0f ? 1.0f : data.minScale();
            float max = data.maxScale();
            newSpeed = max != min ? class_3532.method_16436((double)((scale - min) / (max - min)), (double)(minAbove1 ? minSpeed : baseSpeed), (double)maxSpeed) : maxSpeed;
        }
        return newSpeed;
    }

    @Nullable
    public static <T extends class_1297> T getNearestEntity(Class<? extends T> entityClazz, class_1308 attacker, class_238 searchArea, Predicate<T> predicate) {
        List entities = attacker.field_6002.method_8390(entityClazz, searchArea, entity -> true);
        double shortestDist = -1.0;
        class_1297 target = null;
        for (class_1297 entity2 : entities) {
            if (!attacker.method_5985().method_6369(entity2) || !predicate.test(entity2)) continue;
            double currentDist = entity2.method_5858((class_1297)attacker);
            if (shortestDist != -1.0 && currentDist >= shortestDist) continue;
            shortestDist = currentDist;
            target = entity2;
        }
        return (T)target;
    }

    public static float yRotToYaw(double yRot) {
        return (float)class_3532.method_15338((double)(yRot + 90.0));
    }

    public static float yawToYRot(double yaw) {
        return (float)class_3532.method_15338((double)(yaw - 90.0));
    }

    public static float clampTo360(double x) {
        return (float)(x - Math.floor(x / 360.0) * 360.0);
    }

    public static class_243 directionVecTo(class_1297 start, class_1297 end) {
        return end.method_19538().method_1020(start.method_19538());
    }

    public static boolean movingAwayFrom(class_1297 target, class_1297 start) {
        return target.method_18798().method_1033() > 0.2 && target.method_18798().method_1026(Util.directionVecTo(start, target)) > 0.0;
    }

    public static Pair<class_2350, Double> getClosestSide(class_238 bounding, class_2338 blockPos) {
        class_238 aabb = bounding.method_997(class_243.method_24955((class_2382)blockPos).method_1021(-1.0));
        double maxX = Math.abs(Math.abs(aabb.field_1320) - 0.5);
        double minZ = Math.abs(Math.abs(aabb.field_1321) - 0.5);
        double maxZ = Math.abs(Math.abs(aabb.field_1324) - 0.5);
        double smallest = Math.abs(Math.abs(aabb.field_1323) - 0.5);
        class_2350 dir = class_2350.field_11039;
        if (maxX < smallest) {
            smallest = maxX;
            dir = class_2350.field_11034;
        }
        if (minZ < smallest) {
            smallest = minZ;
            dir = class_2350.field_11043;
        }
        if (maxZ < smallest) {
            smallest = maxZ;
            dir = class_2350.field_11035;
        }
        return Pair.of((Object)dir, (Object)smallest);
    }
}

