/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.fabric.client.model;

import com.github.teamfossilsarcheology.fossil.client.model.block.PlantBlockModel;
import com.github.teamfossilsarcheology.fossil.fabric.client.model.FabricPlantUnbakedModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;

public class PlantModelPlugin
implements PreparableModelLoadingPlugin<Map<class_2960, FabricPlantUnbakedModel>> {
    public void onInitializeModelLoader(Map<class_2960, FabricPlantUnbakedModel> data, ModelLoadingPlugin.Context pluginContext) {
        pluginContext.resolveModel().register(context -> (class_1100)data.get(context.id()));
    }

    public static class Loader
    implements PreparableModelLoadingPlugin.DataLoader<Map<class_2960, FabricPlantUnbakedModel>> {
        static final Gson GSON = new GsonBuilder().registerTypeAdapter(PlantBlockModel.class, (Object)new PlantBlockModel.Deserializer()).registerTypeAdapter(PlantBlockModel.PlantBlockElement.class, (Object)new PlantBlockModel.PlantBlockElement.Deserializer()).registerTypeAdapter(PlantBlockModel.PlantBlockElementFace.class, (Object)new PlantBlockModel.PlantBlockElementFace.Deserializer()).registerTypeAdapter(PlantBlockModel.PlantBlockFaceUV.class, (Object)new PlantBlockModel.PlantBlockFaceUV.Deserializer()).create();

        public CompletableFuture<Map<class_2960, FabricPlantUnbakedModel>> load(class_3300 resourceManager, Executor executor) {
            return CompletableFuture.supplyAsync(() -> resourceManager.method_14488("models", location -> location.method_12836().equals("fossil") && location.method_12832().contains(".json")), executor).thenApplyAsync(resources -> {
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                for (class_2960 location : resources.keySet()) {
                    try {
                        class_3298 resource = resourceManager.getResourceOrThrow(location);
                        try {
                            InputStream inputStream = resource.method_14482();
                            try {
                                JsonObject jsonObject = ((JsonElement)class_3518.method_15284((Gson)GSON, (String)IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset()), JsonElement.class)).getAsJsonObject();
                                if (!jsonObject.has("loader") || !jsonObject.get("loader").getAsString().equals(PlantBlockModel.LOADER.toString())) continue;
                                map.put(Loader.fixLocation(location), new FabricPlantUnbakedModel((PlantBlockModel)GSON.getAdapter(PlantBlockModel.class).fromJsonTree((JsonElement)jsonObject)));
                            }
                            finally {
                                if (inputStream == null) continue;
                                inputStream.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return map;
            });
        }

        private static class_2960 fixLocation(class_2960 location) {
            return new class_2960(location.method_12836(), location.method_12832().replaceFirst("models/", "").replaceFirst(".json", ""));
        }
    }
}

