/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.custom_blocks;

import com.github.teamfossilsarcheology.fossil.block.PrehistoricPlantInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TallBerryBushBlock
extends DoublePlantBlock
implements BonemealableBlock {
    private final PrehistoricPlantInfo info;

    protected TallBerryBushBlock(PrehistoricPlantInfo info) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60918_(SoundType.f_56757_));
        this.info = info;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public abstract IntegerProperty ageProperty();

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            if ((Integer)state.m_61143_((Property)this.ageProperty()) == 0) {
                return Shapes.m_83040_();
            }
            return this.getShapesByAge()[(Integer)state.m_61143_((Property)this.ageProperty())].m_83216_(0.0, -1.0, 0.0);
        }
        return this.getShapesByAge()[(Integer)state.m_61143_((Property)this.ageProperty())];
    }

    protected abstract VoxelShape[] getShapesByAge();

    protected abstract int getCreateUpperAge();

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && this.getShapesByAge()[((Integer)state.m_61143_((Property)this.ageProperty())).intValue()].m_83215_().f_82292_ < 1.0) {
            return state;
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && (Integer)state.m_61143_((Property)this.ageProperty()) < this.info.maxAge();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)this.ageProperty());
        if (i < this.info.maxAge() && random.m_188503_(5) == 0 && level.m_45524_(pos.m_7494_(), 0) >= 9) {
            this.updateAge((Level)level, pos, state, i + 1);
        }
    }

    protected void updateAge(Level level, BlockPos pos, BlockState state, int nextAge) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            BlockPos posAbove = pos.m_7494_();
            BlockState stateAbove = level.m_8055_(posAbove);
            if (stateAbove.m_60713_((Block)this.info.getPlantBlock())) {
                level.m_7731_(posAbove, (BlockState)stateAbove.m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(nextAge)), 2);
            } else {
                if (!stateAbove.m_60795_()) {
                    return;
                }
                if (nextAge >= this.getCreateUpperAge()) {
                    level.m_7731_(posAbove, (BlockState)DoublePlantBlock.m_182453_((LevelReader)level, (BlockPos)posAbove, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(nextAge)), 3);
                }
            }
        } else {
            level.m_7731_(pos.m_7495_(), (BlockState)level.m_8055_(pos.m_7495_()).m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(nextAge)), 2);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.ageProperty(), (Comparable)Integer.valueOf(nextAge)), 2);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isMaxAge;
        int i = (Integer)state.m_61143_((Property)this.ageProperty());
        boolean bl = isMaxAge = i == this.info.maxAge();
        if (!isMaxAge && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i >= this.info.berryAge()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int dropAmount = 1 + level.f_46441_.m_188503_(2) + i - this.info.berryAge();
            BlockPos sourcePos = state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos;
            SweetBerryBushBlock.m_49840_((Level)level, (BlockPos)sourcePos, (ItemStack)new ItemStack((ItemLike)this.info.berryItem().get(), dropAmount));
            level.m_5594_(null, sourcePos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            this.updateAge(level, pos, state, this.info.berryAge() - 1);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{this.ageProperty()});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)this.ageProperty()) < this.info.maxAge();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateAge((Level)level, pos, state, (Integer)state.m_61143_((Property)this.ageProperty()) + 1);
    }
}

