/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnalyzerBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.EnergyContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.inventory.AnalyzerMenu;
import com.github.teamfossilsarcheology.fossil.recipe.AnalyzerRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzerBlockEntity
extends EnergyContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_FOR_DOWN = new int[]{9, 10, 11, 12};
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return AnalyzerBlockEntity.this.cookingProgress;
                }
                case 1: {
                    return AnalyzerBlockEntity.this.energyStorage.getEnergy();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AnalyzerBlockEntity.this.cookingProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)13, (Object)ItemStack.f_41583_);
    private int rawIndex = -1;

    public AnalyzerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ANALYZER.get(), blockPos, blockState);
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AnalyzerBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= 0) {
            if (this.cookingProgress > 0) {
                this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)200);
            }
            return;
        }
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.canProcess()) {
            ++this.cookingProgress;
            if (this.cookingProgress >= 200) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
            if (FossilConfig.isEnabled("machinesRequireEnergy")) {
                this.energyStorage.extractEnergy(FossilConfig.getInt("machineEnergyUsage"));
            }
        } else {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)200);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (BlockState)state.m_61124_((Property)AnalyzerBlock.ACTIVE, (Comparable)Boolean.valueOf(this.cookingProgress > 0));
            level.m_7731_(pos, state, 3);
        }
        if (dirty) {
            AnalyzerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean isAnalyzable(ItemStack itemStack) {
        return ModRecipes.getAnalyzerRecipeForItem((Container)new SimpleContainer(new ItemStack[]{itemStack}), this.f_58857_) != null;
    }

    @Override
    protected boolean canProcess() {
        int slot;
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= FossilConfig.getInt("machineEnergyUsage")) {
            return false;
        }
        this.rawIndex = -1;
        for (slot = 0; slot < 9; ++slot) {
            if (((ItemStack)this.items.get(slot)).m_41619_() || !this.isAnalyzable((ItemStack)this.items.get(slot))) continue;
            this.rawIndex = slot;
            break;
        }
        if (this.rawIndex != -1) {
            for (slot = 9; slot < 13; ++slot) {
                if (!((ItemStack)this.items.get(slot)).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createItem() {
        if (this.canProcess()) {
            ItemStack input = (ItemStack)this.items.get(this.rawIndex);
            AnalyzerRecipe recipe = ModRecipes.getAnalyzerRecipeForItem((Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_);
            if (recipe == null) {
                return;
            }
            ItemStack output = recipe.m_5874_(this).m_41777_();
            if (output.m_41613_() > 1) {
                output.m_41764_(1 + this.f_58857_.f_46441_.m_188503_(output.m_41613_() - 1));
            }
            if (!output.m_41619_()) {
                ItemStack itemStack;
                int slot;
                for (slot = 9; slot < 13; ++slot) {
                    itemStack = (ItemStack)this.items.get(slot);
                    if (!itemStack.m_41656_(output) || itemStack.m_41613_() + output.m_41613_() >= 64) continue;
                    itemStack.m_41764_(itemStack.m_41613_() + output.m_41613_());
                    input.m_41774_(1);
                    return;
                }
                for (slot = 9; slot < 13; ++slot) {
                    itemStack = (ItemStack)this.items.get(slot);
                    if (!itemStack.m_41619_()) continue;
                    this.items.set(slot, (Object)output);
                    input.m_41774_(1);
                    return;
                }
            }
        }
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.fossil.analyzer");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new AnalyzerMenu(containerId, inventory, this, this.dataAccess);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return slot < SLOTS_FOR_DOWN[0] && this.isAnalyzable(stack);
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_UP;
    }

    public boolean m_7155_(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction != Direction.UP && slot >= SLOTS_FOR_DOWN[0];
    }
}

