/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.FeederBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.inventory.FeederMenu;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeederBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int SIZE = 3;
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2};
    private static final String[] NAMES = new String[]{"Meat", "Plant", "Fish"};
    private static final FoodType[] FOOD_TYPES = new FoodType[]{FoodType.MEAT, FoodType.PLANT, FoodType.FISH};
    private final Map<FoodType, Integer> foodStored = new Object2IntOpenHashMap(3);
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return FeederBlockEntity.this.foodStored.getOrDefault((Object)FOOD_TYPES[index], 0);
        }

        public void m_8050_(int index, int value) {
            FeederBlockEntity.this.foodStored.put(FOOD_TYPES[index], value);
        }

        public int m_6499_() {
            return 3;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private int ticksExisted;

    public FeederBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FEEDER.get(), blockPos, blockState);
        for (FoodType type : FOOD_TYPES) {
            this.foodStored.put(type, 0);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FeederBlockEntity blockEntity) {
        ++blockEntity.ticksExisted;
        boolean dirty = false;
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            int foodPoints;
            FoodType type = FOOD_TYPES[i];
            int current = blockEntity.foodStored.get((Object)type);
            blockEntity.foodStored.put(type, Math.max(current, 0));
            ItemStack foodStack = blockEntity.m_8020_(i);
            if (foodStack.m_41619_() || blockEntity.ticksExisted % 5 != 0 || current >= 10000 || (foodPoints = FoodMappings.getFoodAmount((ItemLike)foodStack.m_41720_(), type)) <= 0) continue;
            dirty = true;
            blockEntity.foodStored.put(type, current + foodPoints);
            foodStack.m_41774_(1);
        }
        if (dirty) {
            state = (BlockState)((BlockState)state.m_61124_((Property)FeederBlock.HERB, (Comparable)Boolean.valueOf(blockEntity.foodStored.get((Object)FoodType.PLANT) > 0))).m_61124_((Property)FeederBlock.CARN, (Comparable)Boolean.valueOf(blockEntity.foodStored.get((Object)FoodType.MEAT) > 0 || blockEntity.foodStored.get((Object)FoodType.FISH) > 0));
            level.m_7731_(pos, state, 3);
            FeederBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            this.foodStored.put(FOOD_TYPES[i], Integer.valueOf(tag.m_128448_(NAMES[i])));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (int i = 0; i < FOOD_TYPES.length; ++i) {
            tag.m_128376_(NAMES[i], (short)this.foodStored.get((Object)FOOD_TYPES[i]).intValue());
        }
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.fossil.feeder");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new FeederMenu(containerId, inventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(Diet diet) {
        for (Map.Entry<FoodType, Integer> entry : this.foodStored.entrySet()) {
            if (entry.getValue() <= 0 || !diet.canEat(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    public Integer getSignalStrength() {
        return this.foodStored.values().stream().reduce(Integer::sum).orElse(0);
    }

    public void feedDinosaur(Prehistoric mob) {
        if (this.f_58857_ != null) {
            int feedAmount = 0;
            Diet diet = mob.data().diet();
            for (Map.Entry<FoodType, Integer> entry : this.foodStored.entrySet()) {
                if (entry.getValue() <= 0 || !diet.canEat(entry.getKey())) continue;
                this.foodStored.put(entry.getKey(), entry.getValue() - 1);
                ++feedAmount;
                break;
            }
            if (feedAmount > 0) {
                BlockState blockState = (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)FeederBlock.HERB, (Comparable)Boolean.valueOf(this.foodStored.get((Object)FoodType.PLANT) > 0))).m_61124_((Property)FeederBlock.CARN, (Comparable)Boolean.valueOf(this.foodStored.get((Object)FoodType.MEAT) > 0 || this.foodStored.get((Object)FoodType.FISH) > 0));
                this.f_58857_.m_46597_(this.m_58899_(), blockState);
                FeederBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)blockState);
                mob.feed(feedAmount);
            }
        }
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return FoodMappings.getFoodAmount((ItemLike)stack.m_41720_(), FOOD_TYPES[index]) > 0;
    }

    public int @NotNull [] m_7071_(Direction side) {
        return side != Direction.DOWN ? SLOTS_TOP : new int[]{};
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int getValue(FoodType type) {
        return this.foodStored.get((Object)type);
    }
}

