/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.FileLoader;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;

public class SkeletonGeoModelLoader
extends ResourceLoader<Map<ResourceLocation, BakedGeoModel>> {
    public static final SkeletonGeoModelLoader INSTANCE = new SkeletonGeoModelLoader();
    private Map<ResourceLocation, BakedGeoModel> geoModels = ImmutableMap.of();

    public SkeletonGeoModelLoader() {
        super(PackType.CLIENT_RESOURCES, "geo/entity", ".json");
    }

    @NotNull
    protected Map<ResourceLocation, BakedGeoModel> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ResourceLocation resourceLocation : this.listResources(resourceManager).keySet()) {
            Model model = FileLoader.loadModelFile((ResourceLocation)resourceLocation, (ResourceManager)resourceManager);
            map.put(resourceLocation, BakedModelFactory.getForNamespace((String)resourceLocation.m_135827_()).constructGeoModel(GeometryTree.fromModel((Model)model)));
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, BakedGeoModel> files, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(files);
        this.geoModels = mapBuilder.build();
        FossilMod.LOGGER.info("Loaded {} skeleton models", (Object)this.geoModels.size());
    }

    public BakedGeoModel getSkeletonModel(ResourceLocation file) {
        return this.geoModels.get(file);
    }
}

