/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import software.bernie.geckolib.core.object.Color;

public class InstructionRenderUtil {
    public static void renderTextBatch(PoseStack poseStack, Minecraft minecraft, List<Pair<Vec3, Instruction>> positions) {
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85836_();
        for (int i = 0; i < positions.size(); ++i) {
            String string;
            Vec3 pos = (Vec3)positions.get(i).left();
            Instruction instruction = (Instruction)positions.get(i).right();
            poseStack.m_85836_();
            poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            poseStack.m_252931_(new Matrix4f().rotation((Quaternionfc)minecraft.f_91063_.m_109153_().m_253121_()));
            poseStack.m_85841_(0.02f, -0.02f, 0.02f);
            poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
            if (instruction instanceof Instruction.Idle) {
                Instruction.Idle idle = (Instruction.Idle)instruction;
                string = String.format("%s: %s (%s seconds)", new Object[]{i, instruction.type, idle.duration / 20});
            } else if (instruction instanceof Instruction.AttachTo) {
                Instruction.AttachTo attachTo = (Instruction.AttachTo)instruction;
                string = String.format("%s: %s %s", new Object[]{i, instruction.type, attachTo.direction});
            } else {
                string = String.format("%s: %s", new Object[]{i, instruction.type});
            }
            float g = (float)(-minecraft.f_91062_.m_92895_(string)) / 2.0f;
            int color = -1;
            if (InstructionTab.highlightInstruction == instruction) {
                color = Color.RED.hashCode();
            }
            minecraft.f_91062_.m_252905_(string, g, 0.0f, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, true, 0, 0xF000F0);
            poseStack.m_85849_();
        }
        bufferSource.m_109911_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        poseStack.m_85849_();
    }

    public static void renderFloatingText(PoseStack poseStack, Minecraft minecraft, String text, Vec3 pos) {
        RenderSystem.m_69493_();
        RenderSystem.m_69458_((boolean)true);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85836_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        poseStack.m_252931_(new Matrix4f().rotation((Quaternionfc)minecraft.f_91063_.m_109153_().m_253121_()));
        poseStack.m_85841_(0.02f, -0.02f, 0.02f);
        poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
        float g = (float)(-minecraft.f_91062_.m_92895_(text)) / 2.0f;
        int color = -1;
        minecraft.f_91062_.m_252905_(text, g, 0.0f, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, true, 0, 0xF000F0);
        bufferSource.m_109911_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        poseStack.m_85849_();
    }

    private static float nanoToPulse(long finishNanoTime) {
        return 0.1f + 0.5f * Math.abs(Mth.m_14031_((float)((float)finishNanoTime / 5.0E8f)));
    }

    public static void renderWholeBox(PoseStack poseStack, BlockPos pos, Color color, long finishNanoTime) {
        InstructionRenderUtil.renderWholeBox(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, InstructionRenderUtil.nanoToPulse(finishNanoTime));
    }

    public static void renderWholeBox(PoseStack poseStack, BlockPos pos, float r, float g, float b, float a) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        bufferBuilder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, 0.0f, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, maxY, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, maxY, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, 0.0f, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, 0.0f, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, 0.0f, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, 0.0f, maxY, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, maxY, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, 0.0f, 0.0f).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, 0.0f, maxZ).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
        poseStack.m_85849_();
    }

    public static void renderDownArrow(PoseStack poseStack, Vec3 pos, Color color, float scale, long finishNanoTime) {
        float seconds = (float)finishNanoTime / 1.0E9f;
        InstructionRenderUtil.renderArrow(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, true, scale, seconds * 120.0f % 360.0f, Mth.m_14031_((float)seconds) * 0.25f);
    }

    public static void renderArrow(PoseStack poseStack, Vec3 pos, Color color, float yRot) {
        InstructionRenderUtil.renderArrow(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, false, 1.0f, yRot, 0.0f);
    }

    public static void renderArrow(PoseStack poseStack, Vec3 pos, float r, float g, float b, float a, boolean down, float scale, float yRot, float bounce) {
        poseStack.m_85836_();
        poseStack.m_85837_(pos.m_7096_(), pos.m_7098_() + (double)bounce, pos.m_7094_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        poseStack.m_85841_(scale, scale, scale);
        if (!down) {
            float i = 0.3f;
            float o = -0.2f;
            poseStack.m_252880_(0.0f, i, o);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, -i, -o);
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float min = -0.25f;
        float max = 0.25f;
        bufferBuilder.m_252986_(matrix4f, 0.0f, min, 0.0f).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, max, max).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, max, max).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, max, min).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, max, min).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, max, max).m_85950_(r * 0.7f, g * 0.7f, b * 0.7f, a).m_5752_();
        tesselator.m_85914_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, max, max, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, max, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, max, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, max, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        tesselator.m_85914_();
        float minY = max;
        float maxY = minY + 0.5f;
        float minU = (min /= 2.0f) - 0.05f;
        float maxU = (max /= 2.0f) + 0.05f;
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, min, minY, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, minY, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, minU, maxY, minU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, minU, maxY, maxU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxU, maxY, maxU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, minY, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, minY, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, min, minY, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, minY, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, minU, maxY, minU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxU, maxY, minU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxU, maxY, maxU).m_85950_(r * 0.85f, g * 0.85f, b * 0.85f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, minY, min).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        bufferBuilder.m_252986_(matrix4f, max, minY, max).m_85950_(r * 0.6f, g * 0.6f, b * 0.6f, a).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
        poseStack.m_85849_();
    }
}

