/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionRenderUtil;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderUtil;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.object.Color;

public class InstructionRenderer {
    private static final Map<BlockPos, Integer> countAtPos = new Object2IntOpenHashMap();
    private static final List<Pair<Vec3, Instruction>> texts = new ArrayList<Pair<Vec3, Instruction>>();
    public static Vec3 rulerStartPos;
    public static Vec3 rulerEndPos;

    public static void render(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, long finishNanoTime, Frustum frustum) {
        RenderSystem.m_69478_();
        Minecraft mc = Minecraft.m_91087_();
        if (InstructionTab.activeEntity != null) {
            Instruction instruction;
            List<Instruction> instructions = InstructionTab.INSTRUCTIONS.get(InstructionTab.activeEntity.m_20148_()).instructions();
            countAtPos.clear();
            texts.clear();
            BlockPos currentPos = InstructionTab.activeEntity.m_20183_();
            for (int i = 0; i < instructions.size(); ++i) {
                instruction = instructions.get(i);
                if (instruction instanceof Instruction.MoveTo) {
                    Instruction.MoveTo moveTo = (Instruction.MoveTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, moveTo.target, Color.WHITE);
                    currentPos = moveTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.FlyTo) {
                    Instruction.FlyTo flyTo = (Instruction.FlyTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, flyTo.target, Color.WHITE);
                    currentPos = flyTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.FlyLand) {
                    Instruction.FlyLand flyLand = (Instruction.FlyLand)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, flyLand.target, Color.WHITE);
                    currentPos = flyLand.target;
                    continue;
                }
                if (instruction instanceof Instruction.TeleportTo) {
                    Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)instruction;
                    if (!frustum.m_113029_(new AABB(teleportTo.target))) continue;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, teleportTo.target, Color.PINK);
                    InstructionRenderUtil.renderArrow(poseStack, Vec3.m_82539_((Vec3i)teleportTo.target).m_82520_(0.0, 1.0, 0.0), Color.ofRGBA((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f), -(teleportTo.rotation - 180));
                    currentPos = teleportTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.AttachTo) {
                    Instruction.AttachTo attachTo = (Instruction.AttachTo)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, attachTo.target, Color.GREEN);
                    Vec3 pos = attachTo.location;
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(pos.f_82479_ - 0.05, pos.f_82480_, pos.f_82481_ - 0.05, pos.f_82479_ + 0.05, pos.f_82480_ + 0.05, pos.f_82481_ + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    currentPos = attachTo.target;
                    continue;
                }
                if (instruction instanceof Instruction.LeapLand) {
                    Instruction.LeapLand leapLand = (Instruction.LeapLand)instruction;
                    InstructionRenderer.addPosition(poseStack, buffer, instruction, new BlockPos(leapLand.location), Color.GREEN);
                    Vec3 pos = leapLand.locationAbove;
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(pos.f_82479_ - 0.05, pos.f_82480_, pos.f_82481_ - 0.05, pos.f_82479_ + 0.05, pos.f_82480_ + 0.05, pos.f_82481_ + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    currentPos = new BlockPos(leapLand.location);
                    continue;
                }
                if (instruction instanceof Instruction.PlayAnim) {
                    Instruction.PlayAnim playAnim = (Instruction.PlayAnim)instruction;
                    continue;
                }
                if (!(instruction instanceof Instruction.Idle)) continue;
                Instruction.Idle idle = (Instruction.Idle)instruction;
                int stack = countAtPos.compute(currentPos, (blockPos, count) -> count == null ? 1 : count + 1);
                texts.add((Pair<Vec3, Instruction>)Pair.of((Object)Vec3.m_82512_((Vec3i)currentPos).m_82520_(0.0, 0.5 + (double)stack * 0.2, 0.0), (Object)instruction));
            }
            InstructionRenderUtil.renderTextBatch(poseStack, mc, texts);
            instruction = InstructionTab.highlightInstruction;
            if (instruction instanceof Instruction.MoveTo) {
                Instruction.MoveTo moveTo = (Instruction.MoveTo)instruction;
                InstructionRenderer.addPosition(poseStack, buffer, moveTo, moveTo.target, Color.RED);
            }
            if (InstructionTab.activeEntity != null && frustum.m_113029_(InstructionTab.activeEntity.m_6921_())) {
                Prehistoric entity = InstructionTab.activeEntity;
                double lerpX = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
                double lerpY = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
                double lerpZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
                Vec3 pos = new Vec3(lerpX, lerpY + (double)entity.m_20206_() + 1.0, lerpZ);
                InstructionRenderUtil.renderDownArrow(poseStack, pos, Color.ofRGBA((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f), Math.max(1.0f, entity.m_20205_()), finishNanoTime);
            }
        }
        if (InstructionTab.positionMode == Instruction.Type.FLY_TO) {
            targetPos = PathingDebug.getAirHitResult(mc);
            InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f), finishNanoTime);
            InstructionRenderUtil.renderFloatingText(poseStack, Minecraft.m_91087_(), String.valueOf(PathingDebug.pickBlockOffset), Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, 0.7, 0.0));
        } else if (InstructionTab.positionMode != Instruction.Type.IDLE) {
            targetPos = PathingDebug.getBlockHitResult(mc);
            InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f), finishNanoTime);
            if (InstructionTab.positionMode == Instruction.Type.TELEPORT_TO) {
                InstructionRenderUtil.renderArrow(poseStack, Vec3.m_82539_((Vec3i)targetPos).m_82520_(0.0, 1.0, 0.0), Color.ofRGBA((float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f), InstructionTab.teleportRotation);
            }
            InstructionRenderUtil.renderFloatingText(poseStack, Minecraft.m_91087_(), String.valueOf(PathingDebug.pickBlockOffset), Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, 0.7, 0.0));
        }
        if (DebugScreen.rulerMode > 0) {
            Vec3 pos = PathingDebug.getHitResult(mc);
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(pos.f_82479_ - 0.05, pos.f_82480_, pos.f_82481_ - 0.05, pos.f_82479_ + 0.05, pos.f_82480_ + 0.05, pos.f_82481_ + 0.05), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        if (rulerStartPos != null) {
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(InstructionRenderer.rulerStartPos.f_82479_ - 0.05, InstructionRenderer.rulerStartPos.f_82480_, InstructionRenderer.rulerStartPos.f_82481_ - 0.05, InstructionRenderer.rulerStartPos.f_82479_ + 0.05, InstructionRenderer.rulerStartPos.f_82480_ + 0.05, InstructionRenderer.rulerStartPos.f_82481_ + 0.05), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        }
        if (rulerEndPos != null) {
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(InstructionRenderer.rulerEndPos.f_82479_ - 0.05, InstructionRenderer.rulerEndPos.f_82480_, InstructionRenderer.rulerEndPos.f_82481_ - 0.05, InstructionRenderer.rulerEndPos.f_82479_ + 0.05, InstructionRenderer.rulerEndPos.f_82480_ + 0.05, InstructionRenderer.rulerEndPos.f_82481_ + 0.05), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (rulerEndPos != null && rulerStartPos != null) {
            Vec3 vec = rulerEndPos.m_82546_(rulerStartPos);
            PathingRenderUtil.renderLine(poseStack, rulerStartPos, rulerStartPos.m_82549_(vec));
            InstructionRenderUtil.renderFloatingText(poseStack, mc, String.valueOf(vec.m_82553_()), rulerStartPos.m_82549_(vec.m_82490_(0.5)).m_82520_(0.0, 0.5, 0.0));
        }
    }

    private static void addPosition(PoseStack poseStack, MultiBufferSource buffer, Instruction instruction, BlockPos target, Color color) {
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)new AABB(target), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        int stack = countAtPos.compute(target, (blockPos, count) -> count == null ? 1 : count + 1);
        texts.add((Pair<Vec3, Instruction>)Pair.of((Object)Vec3.m_82512_((Vec3i)target).m_82520_(0.0, 0.5 + (double)stack * 0.2, 0.0), (Object)instruction));
    }
}

