/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.PathingScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugCenteredPathNavigation;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathNavigation;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.SweepPathNavigation;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.WaterPathNavigation;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PathingDebug {
    public static PlayerPathNavigation pathNavigation1;
    public static DebugCenteredPathNavigation pathNavigation3;
    public static SweepPathNavigation pathNavigation4;
    public static WaterPathNavigation pathNavigation5;
    public static BlockPos pos1;
    public static BlockPos pos2;
    public static Vec3 pos3;
    public static boolean showHelpMenu;
    public static boolean addNodeToPathMode;
    public static int pickBlockOffset;
    private static final Map<BlockPathTypes, Float> pathfindingMalus;

    public static void addToPath(BlockPos pos) {
        if (pathNavigation1 != null && pathNavigation1.getPath() != null) {
            pathNavigation1.getPath().addForcedNode(pos);
        }
        if (pathNavigation3 != null && pathNavigation3.getPath() != null) {
            pathNavigation3.getPath().addForcedNode(pos);
        }
        if (pathNavigation4 != null && pathNavigation4.getPath() != null) {
            pathNavigation4.getPath().addForcedNode(pos);
        }
        if (pathNavigation5 != null && pathNavigation5.getPath() != null) {
            pathNavigation5.getPath().addForcedNode(pos);
        }
    }

    public static void removeFromPath(BlockPos pos) {
        if (pathNavigation1 != null && pathNavigation1.getPath() != null) {
            pathNavigation1.getPath().removeForcedNode(pos);
        }
        if (pathNavigation3 != null && pathNavigation3.getPath() != null) {
            pathNavigation3.getPath().removeForcedNode(pos);
        }
        if (pathNavigation4 != null && pathNavigation4.getPath() != null) {
            pathNavigation4.getPath().removeForcedNode(pos);
        }
        if (pathNavigation5 != null && pathNavigation5.getPath() != null) {
            pathNavigation5.getPath().removeForcedNode(pos);
        }
    }

    public static void rePath() {
        if (PathingScreen.currentNav != null && pos1 != null && pos2 != null) {
            PathingScreen.currentNav.stop();
            PathingScreen.currentNav.moveTo(pos2);
        }
    }

    public static void setPos1(BlockPos pos1) {
        PathingDebug.pos1 = pos1;
        if (pathNavigation1 != null && pos2 != null) {
            pathNavigation1.moveTo(pos2);
            pathNavigation3.moveTo(pos2);
            pathNavigation4.moveTo(pos2);
            pathNavigation5.moveTo(pos2);
        }
    }

    public static void setPos2(BlockPos pos2) {
        PathingDebug.pos2 = pos2;
        if (pathNavigation1 != null && pos1 != null) {
            pathNavigation1.moveTo(pos2);
            pathNavigation3.moveTo(pos2);
            pathNavigation4.moveTo(pos2);
            pathNavigation5.moveTo(pos2);
        }
    }

    public static void setPos3(Vec3 pos3) {
        PathingDebug.pos3 = pos3;
        if (pathNavigation4 != null) {
            pathNavigation4.setSweepStartPos(pos3);
        }
        if (pathNavigation5 != null) {
            pathNavigation5.setSweepStartPos(pos3);
        }
    }

    public static Vec3 getHitResult(Minecraft mc) {
        Entity camera = mc.m_91288_();
        Vec3 eye = camera.m_146892_();
        Vec3 view = camera.m_20252_(1.0f);
        double range = 30.0;
        Vec3 end = eye.m_82520_(view.f_82479_ * range, view.f_82480_ * range, view.f_82481_ * range);
        BlockHitResult hitResult = camera.f_19853_.m_45547_(new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, camera));
        return hitResult.m_82450_();
    }

    public static BlockHitResult getOffsetHitResult(Minecraft mc) {
        Entity camera = mc.m_91288_();
        Vec3 eye = camera.m_146892_();
        Vec3 view = camera.m_20252_(1.0f);
        double range = 30.0;
        Vec3 end = eye.m_82520_(view.f_82479_ * range, view.f_82480_ * range, view.f_82481_ * range);
        if (!mc.f_91073_.m_6425_(new BlockPos(eye)).m_76178_()) {
            eye = eye.m_82549_(view.m_82490_(2.0));
        }
        return camera.f_19853_.m_45547_(new ClipContext(eye.m_82549_(view.m_82490_((double)pickBlockOffset)), end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, camera));
    }

    public static BlockPos getBlockHitResult(Minecraft mc) {
        BlockHitResult hitResult = PathingDebug.getOffsetHitResult(mc);
        return hitResult.m_82425_().m_121945_(hitResult.m_82434_());
    }

    public static BlockPos getAirHitResult(Minecraft mc) {
        Entity camera = mc.m_91288_();
        Vec3 eye = camera.m_146892_();
        Vec3 view = camera.m_20252_(1.0f);
        return new BlockPos(eye.m_82549_(view.m_82490_((double)(pickBlockOffset + 1))));
    }

    public static float getPathfindingMalus(BlockPathTypes nodeType) {
        Float float_ = pathfindingMalus.get(nodeType);
        return float_ == null ? nodeType.m_77124_() : float_.floatValue();
    }

    public static void setPathfindingMalus(BlockPathTypes nodeType, float malus) {
        pathfindingMalus.put(nodeType, Float.valueOf(malus));
    }

    public static void tick() {
        if (pathNavigation1 != null) {
            pathNavigation1.tick();
        }
        if (pathNavigation3 != null) {
            pathNavigation3.tick();
        }
    }

    static {
        pathfindingMalus = Maps.newEnumMap(BlockPathTypes.class);
    }
}

