/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayerPath {
    private Node[] openSet = new Node[0];
    private Node[] closedSet = new Node[0];
    public final List<Node> nodes;
    @Nullable
    public Set<Target> targetNodes;
    private int nextNodeIndex;
    public int sweepNextNodeIndex;
    private final BlockPos target;
    private final float distToTarget;
    private final boolean reached;
    public final List<BlockPos> blockPoses;

    public PlayerPath(List<Node> list, BlockPos blockPos, boolean bl) {
        this.nodes = list;
        this.blockPoses = list.stream().map(node -> new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_)).collect(Collectors.toList());
        this.target = blockPos;
        this.distToTarget = list.isEmpty() ? Float.MAX_VALUE : this.nodes.get(this.nodes.size() - 1).m_77306_(this.target);
        this.reached = bl;
    }

    public boolean removeForcedNode(BlockPos pos) {
        int idx = this.blockPoses.indexOf(pos);
        if (idx != -1) {
            this.nodes.remove(idx);
            this.blockPoses.remove(idx);
            return true;
        }
        return false;
    }

    public boolean addForcedNode(BlockPos pos) {
        if (!this.blockPoses.contains(pos)) {
            this.nodes.add(new Node(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            this.blockPoses.add(pos);
            return true;
        }
        return false;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public Node getEndNode() {
        if (!this.nodes.isEmpty()) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public Node getNode(int index) {
        return this.nodes.get(index);
    }

    public void truncateNodes(int length) {
        if (this.nodes.size() > length) {
            this.nodes.subList(length, this.nodes.size()).clear();
        }
    }

    public void replaceNode(int index, Node point) {
        this.nodes.set(index, point);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public int getDebugNodeIndex() {
        return Math.min(this.getNodeCount() - 1, PathingRenderer.pathIndex);
    }

    public void setSweepNodeIndex(int currentPathIndex) {
        this.sweepNextNodeIndex = Math.min(this.getNodeCount() - 1, currentPathIndex);
    }

    public Vec3 getEntityPosAtNode(int index) {
        Node node = this.nodes.get(index);
        double d = (double)node.f_77271_ + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
        double e = node.f_77272_;
        double f = (double)node.f_77273_ + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
        return new Vec3(d, e, f);
    }

    public BlockPos getNodePos(int i) {
        return this.nodes.get(i).m_77288_();
    }

    public Vec3 getSweepEntityPos(Entity entity) {
        return this.getEntityPosAtNode(this.sweepNextNodeIndex);
    }

    public Vec3 getNextEntityPos(Entity entity) {
        return this.getEntityPosAtNode(Math.min(this.getNodeCount() - 1, PathingRenderer.pathIndex));
    }

    public BlockPos getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).m_77288_();
    }

    public Node getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public Node getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable PlayerPath pathentity) {
        if (pathentity == null) {
            return false;
        }
        if (pathentity.nodes.size() != this.nodes.size()) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = this.nodes.get(i);
            Node node2 = pathentity.nodes.get(i);
            if (node.f_77271_ == node2.f_77271_ && node.f_77272_ == node2.f_77272_ && node.f_77273_ == node2.f_77273_) continue;
            return false;
        }
        return true;
    }

    void setDebug(Node[] openSet, Node[] closedSet, Set<Target> targetNodes) {
        this.openSet = openSet;
        this.closedSet = closedSet;
        this.targetNodes = targetNodes;
    }

    public Node[] getOpenSet() {
        return this.openSet;
    }

    public Node[] getClosedSet() {
        return this.closedSet;
    }

    public boolean canReach() {
        return this.reached;
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }
}

